/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.heat;

import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class HeatBehaviour<Tile extends TileEntity> {
    private String id;
    private IHeatExchangerLogic connectedHeatLogic;
    private World world;
    private BlockPos pos;
    private Tile cachedTE;
    private IBlockState blockState;
    private EnumFacing direction;

    public void initialize(String id, IHeatExchangerLogic connectedHeatLogic, World world, BlockPos pos, EnumFacing direction) {
        this.connectedHeatLogic = connectedHeatLogic;
        this.world = world;
        this.pos = pos;
        this.direction = direction;
        this.cachedTE = null;
        this.blockState = null;
    }

    public IHeatExchangerLogic getHeatExchanger() {
        return this.connectedHeatLogic;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public Tile getTileEntity() {
        if (this.cachedTE == null || this.cachedTE.func_145837_r()) {
            this.cachedTE = this.world.func_175625_s(this.pos);
        }
        return this.cachedTE;
    }

    public IBlockState getBlockState() {
        if (this.blockState == null) {
            this.blockState = this.world.func_180495_p(this.pos);
        }
        return this.blockState;
    }

    public abstract String getId();

    public abstract boolean isApplicable();

    public abstract void update();

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("x", this.pos.func_177958_n());
        tag.func_74768_a("y", this.pos.func_177956_o());
        tag.func_74768_a("z", this.pos.func_177952_p());
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public boolean equals(Object o) {
        if (o instanceof HeatBehaviour) {
            HeatBehaviour behaviour = (HeatBehaviour)o;
            return behaviour.getId().equals(this.getId()) && behaviour.getPos().equals((Object)this.getPos());
        }
        return false;
    }

    public int hashCode() {
        int i = this.getId().hashCode();
        i = i * 31 + this.getPos().hashCode();
        return i;
    }
}

