/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.crafttweaker;

import com.google.common.collect.Lists;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.utils.Utils;

@ZenClass(value="mods.jaopca.OreEntry")
@ZenRegister
public class OreEntry {
    private final IOreEntry entry;

    public OreEntry(IOreEntry entry) {
        this.entry = entry;
    }

    @ZenGetter(value="oreName")
    public String getOreName() {
        return this.entry.getOreName();
    }

    @ZenGetter(value="oreNameSynonyms")
    public List<String> getOreNameSynonyms() {
        return Lists.newArrayList(this.entry.getOreNameSynonyms());
    }

    @ZenMethod
    public IOreDictEntry getOreDictEntry(String prefix) {
        return CraftTweakerMC.getOreDict((String)(prefix + this.entry.getOreName()));
    }

    @ZenMethod
    public IItemStack getItemStack(String prefix) {
        return CraftTweakerMC.getIItemStack((ItemStack)Utils.getOreStack(prefix, this.entry, 1));
    }

    @ZenMethod
    public IItemStack getItemStack(String name, String prefix) {
        return CraftTweakerMC.getIItemStack((ItemStack)Utils.getJAOPCAOrOreStack(name, prefix, this.entry, 1));
    }

    @ZenMethod
    public ILiquidStack getLiquidStack(String prefix) {
        return (ILiquidStack)CraftTweakerMC.getIIngredient((Object)Utils.getFluidStack(prefix, this.entry, 1));
    }

    @ZenMethod
    public ILiquidStack getLiquidStack(String name, String prefix) {
        return (ILiquidStack)CraftTweakerMC.getIIngredient((Object)Utils.getJAOPCAOrFluidStack(name, prefix, this.entry, 1));
    }

    @ZenGetter(value="hasExtra")
    public boolean hasExtra() {
        return this.entry.hasExtra();
    }

    @ZenGetter(value="extra")
    public OreEntry getExtra() {
        return JAOPCAApi.ORE_ENTRY_LIST.stream().filter(entry -> this.entry.getExtra().equals(entry.getExtra())).map(OreEntry::new).findAny().orElse(null);
    }

    @ZenGetter(value="extraName")
    public String getExtraName() {
        return this.entry.getExtra();
    }

    @ZenMethod
    public IOreDictEntry getOreDictEntryExtra(String prefix) {
        return CraftTweakerMC.getOreDict((String)(prefix + this.entry.getExtra()));
    }

    @ZenMethod
    public IItemStack getItemStackExtra(String prefix) {
        return CraftTweakerMC.getIItemStack((ItemStack)Utils.getOreStackExtra(prefix, this.entry, 1));
    }

    @ZenMethod
    public IItemStack getItemStackExtra(String name, String prefix) {
        return CraftTweakerMC.getIItemStack((ItemStack)Utils.getJAOPCAOrOreStackExtra(name, prefix, this.entry, 1));
    }

    @ZenMethod
    public ILiquidStack getLiquidStackExtra(String prefix) {
        return (ILiquidStack)CraftTweakerMC.getIIngredient((Object)Utils.getFluidStackExtra(prefix, this.entry, 1));
    }

    @ZenMethod
    public ILiquidStack getLiquidStackExtra(String name, String prefix) {
        return (ILiquidStack)CraftTweakerMC.getIIngredient((Object)Utils.getJAOPCAOrFluidStackExtra(name, prefix, this.entry, 1));
    }

    @ZenGetter(value="hasSecondExtra")
    public boolean hasSecondExtra() {
        return this.entry.hasSecondExtra();
    }

    @ZenGetter(value="secondExtra")
    public OreEntry getSecondExtra() {
        return JAOPCAApi.ORE_ENTRY_LIST.stream().filter(entry -> this.entry.getSecondExtra().equals(entry.getSecondExtra())).map(OreEntry::new).findAny().orElse(null);
    }

    @ZenGetter(value="secondExtraName")
    public String getSecondExtraName() {
        return this.entry.getSecondExtra();
    }

    @ZenMethod
    public IOreDictEntry getOreDictEntrySecondExtra(String prefix) {
        return CraftTweakerMC.getOreDict((String)(prefix + this.entry.getSecondExtra()));
    }

    @ZenMethod
    public IItemStack getItemStackSecondExtra(String prefix) {
        return CraftTweakerMC.getIItemStack((ItemStack)Utils.getOreStackSecondExtra(prefix, this.entry, 1));
    }

    @ZenMethod
    public IItemStack getItemStackSecondExtra(String name, String prefix) {
        return CraftTweakerMC.getIItemStack((ItemStack)Utils.getJAOPCAOrOreStackSecondExtra(name, prefix, this.entry, 1));
    }

    @ZenMethod
    public ILiquidStack getLiquidStackSecondExtra(String prefix) {
        return (ILiquidStack)CraftTweakerMC.getIIngredient((Object)Utils.getFluidStackSecondExtra(prefix, this.entry, 1));
    }

    @ZenMethod
    public ILiquidStack getLiquidStackSecondExtra(String name, String prefix) {
        return (ILiquidStack)CraftTweakerMC.getIIngredient((Object)Utils.getJAOPCAOrFluidStackSecondExtra(name, prefix, this.entry, 1));
    }

    @ZenGetter(value="hasThirdExtra")
    public boolean hasThirdExtra() {
        return this.entry.hasThirdExtra();
    }

    @ZenGetter(value="thirdExtra")
    public OreEntry getThirdExtra() {
        return JAOPCAApi.ORE_ENTRY_LIST.stream().filter(entry -> this.entry.getThirdExtra().equals(entry.getThirdExtra())).map(OreEntry::new).findAny().orElse(null);
    }

    @ZenGetter(value="thirdExtraName")
    public String getThirdExtraName() {
        return this.entry.getThirdExtra();
    }

    @ZenMethod
    public IOreDictEntry getOreDictEntryThirdExtra(String prefix) {
        return CraftTweakerMC.getOreDict((String)(prefix + this.entry.getThirdExtra()));
    }

    @ZenMethod
    public IItemStack getItemStackThirdExtra(String prefix) {
        return CraftTweakerMC.getIItemStack((ItemStack)Utils.getOreStackThirdExtra(prefix, this.entry, 1));
    }

    @ZenMethod
    public IItemStack getItemStackThirdExtra(String name, String prefix) {
        return CraftTweakerMC.getIItemStack((ItemStack)Utils.getJAOPCAOrOreStackThirdExtra(name, prefix, this.entry, 1));
    }

    @ZenMethod
    public ILiquidStack getLiquidStackThirdExtra(String prefix) {
        return (ILiquidStack)CraftTweakerMC.getIIngredient((Object)Utils.getFluidStackThirdExtra(prefix, this.entry, 1));
    }

    @ZenMethod
    public ILiquidStack getLiquidStackThirdExtra(String name, String prefix) {
        return (ILiquidStack)CraftTweakerMC.getIIngredient((Object)Utils.getJAOPCAOrFluidStackThirdExtra(name, prefix, this.entry, 1));
    }

    @ZenGetter(value="energyModifier")
    public double getEnergyModifier() {
        return this.entry.getEnergyModifier();
    }

    @ZenGetter(value="rarity")
    public double getRarity() {
        return this.entry.getRarity();
    }

    @ZenGetter(value="oreType")
    public String getOreType() {
        return Utils.toLowerCase(this.entry.getOreType().name());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OreEntry)) {
            return false;
        }
        OreEntry other = (OreEntry)obj;
        return this.entry == other.entry;
    }

    public int hashCode() {
        return this.entry.hashCode() + 7;
    }
}

