/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import appeng.core.AEConfig;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.utils.Utils;

public class ModuleAppliedEnergistics
extends ModuleBase {
    @Override
    public String getName() {
        return "appliedenergistics";
    }

    @Override
    public List<String> getDependencies() {
        return Lists.newArrayList((Object[])new String[]{"dust"});
    }

    @Override
    public void init() {
        float doubleChance = (float)(AEConfig.instance().getOreDoublePercentage() / 100.0);
        block5: for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"dust")) {
            if (entry.getModuleBlacklist().contains(this.getName())) continue;
            ItemStack dust = Utils.getOreStack("dust", entry, 1);
            switch (entry.getOreType()) {
                case GEM: 
                case GEM_ORELESS: {
                    for (ItemStack stack : Utils.getOres("gem" + entry.getOreName())) {
                        ModuleAppliedEnergistics.addGrinderRecipe(stack, dust, Utils.energyI(entry, 4.0));
                    }
                    continue block5;
                }
                case INGOT: {
                    for (ItemStack stack : Utils.getOres("ore" + entry.getOreName())) {
                        ModuleAppliedEnergistics.addGrinderRecipe(stack, dust, dust, doubleChance, Utils.energyI(entry, 8.0));
                    }
                }
                case INGOT_ORELESS: {
                    for (ItemStack stack : Utils.getOres("ingot" + entry.getOreName())) {
                        ModuleAppliedEnergistics.addGrinderRecipe(stack, dust, Utils.energyI(entry, 4.0));
                    }
                    continue block5;
                }
            }
        }
    }

    public static void addGrinderRecipe(ItemStack in, ItemStack out, ItemStack optional, float chance, int turns) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("in", (NBTBase)in.func_77955_b(new NBTTagCompound()));
        tag.func_74782_a("out", (NBTBase)out.func_77955_b(new NBTTagCompound()));
        tag.func_74782_a("optional", (NBTBase)optional.func_77955_b(new NBTTagCompound()));
        tag.func_74776_a("chance", chance);
        tag.func_74768_a("turns", turns);
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"add-grindable", (NBTTagCompound)tag);
    }

    public static void addGrinderRecipe(ItemStack in, ItemStack out, int turns) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("in", (NBTBase)in.func_77955_b(new NBTTagCompound()));
        tag.func_74782_a("out", (NBTBase)out.func_77955_b(new NBTTagCompound()));
        tag.func_74768_a("turns", turns);
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"add-grindable", (NBTTagCompound)tag);
    }
}

