/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.content.tank.SynchronizedTankData;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public final class FluidRenderer {
    private static final int BLOCK_STAGES = 1000;
    private static Map<RenderData, MekanismRenderer.DisplayInteger[]> cachedCenterFluids = new HashMap<RenderData, MekanismRenderer.DisplayInteger[]>();
    private static Map<ValveRenderData, MekanismRenderer.DisplayInteger> cachedValveFluids = new HashMap<ValveRenderData, MekanismRenderer.DisplayInteger>();

    public static void translateToOrigin(Coord4D origin) {
        GL11.glTranslated((double)FluidRenderer.getX(origin.x), (double)FluidRenderer.getY(origin.y), (double)FluidRenderer.getZ(origin.z));
    }

    public static int getStages(RenderData data) {
        return data.height * 1000;
    }

    public static void pop() {
        GL11.glPopAttrib();
        GlStateManager.func_179121_F();
    }

    public static void push() {
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public static MekanismRenderer.DisplayInteger getTankDisplay(RenderData data) {
        return FluidRenderer.getTankDisplay(data, 1.0);
    }

    public static MekanismRenderer.DisplayInteger getTankDisplay(RenderData data, double scale) {
        MekanismRenderer.DisplayInteger[] ret;
        int maxStages = FluidRenderer.getStages(data);
        int stage = Math.min(maxStages, (int)(scale * (double)maxStages));
        if (cachedCenterFluids.containsKey(data) && (ret = cachedCenterFluids.get(data))[stage] != null) {
            return ret[stage];
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(MekanismRenderer.getFluidTexture(data.fluidType, MekanismRenderer.FluidType.STILL));
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        if (!cachedCenterFluids.containsKey(data)) {
            cachedCenterFluids.put(data, new MekanismRenderer.DisplayInteger[maxStages + 1]);
        }
        FluidRenderer.cachedCenterFluids.get((Object)data)[stage] = display;
        if (maxStages == 0) {
            stage = 1;
            maxStages = 1;
        }
        if (data.fluidType.getFluid().getStill(data.fluidType) != null) {
            toReturn.minX = 0.01;
            toReturn.minY = 0.01;
            toReturn.minZ = 0.01;
            toReturn.maxX = (double)data.length - 0.01;
            toReturn.maxY = (double)((float)stage / (float)maxStages * (float)data.height) - 0.01;
            toReturn.maxZ = (double)data.width - 0.01;
            MekanismRenderer.renderObject(toReturn);
        }
        MekanismRenderer.DisplayInteger.endList();
        return display;
    }

    public static MekanismRenderer.DisplayInteger getValveDisplay(ValveRenderData data) {
        if (cachedValveFluids.containsKey(data)) {
            return cachedValveFluids.get(data);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        MekanismRenderer.prepFlowing(toReturn, data.fluidType);
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        cachedValveFluids.put(data, display);
        switch (data.side) {
            case DOWN: {
                toReturn.minX = 0.3;
                toReturn.minY = 1.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = 0.7;
                toReturn.maxY = 1.5;
                toReturn.maxZ = 0.7;
                break;
            }
            case UP: {
                toReturn.minX = 0.3;
                toReturn.minY = (double)(-data.height) - 0.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = 0.7;
                toReturn.maxY = -0.01;
                toReturn.maxZ = 0.7;
                break;
            }
            case NORTH: {
                toReturn.minX = 0.3;
                toReturn.minY = (double)(-FluidRenderer.getValveFluidHeight(data)) + 0.01;
                toReturn.minZ = 1.02;
                toReturn.maxX = 0.7;
                toReturn.maxY = 0.7;
                toReturn.maxZ = 1.4;
                break;
            }
            case SOUTH: {
                toReturn.minX = 0.3;
                toReturn.minY = (double)(-FluidRenderer.getValveFluidHeight(data)) + 0.01;
                toReturn.minZ = -0.4;
                toReturn.maxX = 0.7;
                toReturn.maxY = 0.7;
                toReturn.maxZ = -0.02;
                break;
            }
            case WEST: {
                toReturn.minX = 1.02;
                toReturn.minY = (double)(-FluidRenderer.getValveFluidHeight(data)) + 0.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = 1.4;
                toReturn.maxY = 0.7;
                toReturn.maxZ = 0.7;
                break;
            }
            case EAST: {
                toReturn.minX = -0.4;
                toReturn.minY = (double)(-FluidRenderer.getValveFluidHeight(data)) + 0.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = -0.02;
                toReturn.maxY = 0.7;
                toReturn.maxZ = 0.7;
                break;
            }
        }
        if (data.fluidType.getFluid().getFlowing(data.fluidType) != null) {
            MekanismRenderer.renderObject(toReturn);
        }
        MekanismRenderer.DisplayInteger.endList();
        return display;
    }

    private static int getValveFluidHeight(ValveRenderData data) {
        return data.valveLocation.y - data.location.y;
    }

    private static double getX(int x) {
        return (double)x - TileEntityRendererDispatcher.field_147554_b;
    }

    private static double getY(int y) {
        return (double)y - TileEntityRendererDispatcher.field_147555_c;
    }

    private static double getZ(int z) {
        return (double)z - TileEntityRendererDispatcher.field_147552_d;
    }

    public static void resetDisplayInts() {
        cachedCenterFluids.clear();
        cachedValveFluids.clear();
    }

    public static class ValveRenderData
    extends RenderData {
        public EnumFacing side;
        public Coord4D valveLocation;

        public static ValveRenderData get(RenderData renderData, SynchronizedTankData.ValveData valveData) {
            ValveRenderData data = new ValveRenderData();
            data.location = renderData.location;
            data.height = renderData.height;
            data.length = renderData.length;
            data.width = renderData.width;
            data.fluidType = renderData.fluidType;
            data.side = valveData.side;
            data.valveLocation = valveData.location;
            return data;
        }

        @Override
        public boolean equals(Object data) {
            return data instanceof ValveRenderData && super.equals(data) && ((ValveRenderData)data).side.equals((Object)this.side);
        }

        @Override
        public int hashCode() {
            int code = 1;
            code = 31 * code + super.hashCode();
            code = 31 * code + this.side.ordinal();
            code = 31 * code + this.valveLocation.hashCode();
            return code;
        }
    }

    public static class RenderData {
        public Coord4D location;
        public int height;
        public int length;
        public int width;
        public FluidStack fluidType;

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.location.hashCode();
            code = 31 * code + this.height;
            code = 31 * code + this.length;
            code = 31 * code + this.width;
            code = 31 * code + this.fluidType.getFluid().getName().hashCode();
            code = 31 * code + (this.fluidType.tag != null ? this.fluidType.tag.hashCode() : 0);
            return code;
        }

        public boolean equals(Object data) {
            return data instanceof RenderData && ((RenderData)data).height == this.height && ((RenderData)data).length == this.length && ((RenderData)data).width == this.width && ((RenderData)data).fluidType.isFluidEqual(this.fluidType);
        }
    }
}

