/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModIdentifier {
    private static final Logger log = LogManager.getLogger();

    public static Set<ModContainer> identifyFromStacktrace(Throwable e) {
        Map<File, Set<ModContainer>> modMap = ModIdentifier.makeModMap();
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        while (e != null) {
            for (StackTraceElement element : e.getStackTrace()) {
                classes.add(element.getClassName());
            }
            e = e.getCause();
        }
        LinkedHashSet<ModContainer> mods = new LinkedHashSet<ModContainer>();
        for (String className : classes) {
            Set<ModContainer> classMods = ModIdentifier.identifyFromClass(className, modMap);
            if (classMods == null) continue;
            mods.addAll(classMods);
        }
        return mods;
    }

    public static Set<ModContainer> identifyFromClass(String className) {
        return ModIdentifier.identifyFromClass(className, ModIdentifier.makeModMap());
    }

    private static Set<ModContainer> identifyFromClass(String className, Map<File, Set<ModContainer>> modMap) {
        if (className.startsWith("org.spongepowered.asm.mixin.")) {
            return Collections.emptySet();
        }
        String untrasformedName = ModIdentifier.untransformName(Launch.classLoader, className);
        URL url = Launch.classLoader.getResource(untrasformedName.replace('.', '/') + ".class");
        log.debug(className + " = " + untrasformedName + " = " + url);
        if (url == null) {
            log.warn("Failed to identify " + className + " (untransformed name: " + untrasformedName + ")");
            return Collections.emptySet();
        }
        try {
            if (url.getProtocol().equals("jar")) {
                url = new URL(url.getFile().substring(0, url.getFile().indexOf(33)));
            }
            return modMap.get(new File(url.toURI()).getCanonicalFile());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<File, Set<ModContainer>> makeModMap() {
        HashMap<File, Set<ModContainer>> modMap = new HashMap<File, Set<ModContainer>>();
        for (ModContainer mod : Loader.instance().getModList()) {
            Set currentMods = modMap.getOrDefault(mod.getSource(), new HashSet());
            currentMods.add(mod);
            try {
                modMap.put(mod.getSource().getCanonicalFile(), currentMods);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            modMap.remove(Loader.instance().getMinecraftModContainer().getSource());
            modMap.remove(((ModContainer)Loader.instance().getIndexedModList().get("FML")).getSource());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return modMap;
    }

    private static String untransformName(LaunchClassLoader launchClassLoader, String className) {
        try {
            Method untransformNameMethod = LaunchClassLoader.class.getDeclaredMethod("untransformName", String.class);
            untransformNameMethod.setAccessible(true);
            return (String)untransformNameMethod.invoke((Object)launchClassLoader, className);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

