/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import me.lucko.luckperms.lib.configurate.ConfigValue;
import me.lucko.luckperms.lib.configurate.SimpleConfigurationNode;
import me.lucko.luckperms.lib.configurate.Types;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class ListConfigValue
extends ConfigValue {
    final AtomicReference<List<SimpleConfigurationNode>> values = new AtomicReference(new ArrayList());

    ListConfigValue(SimpleConfigurationNode holder) {
        super(holder);
    }

    ListConfigValue(SimpleConfigurationNode holder, Object startValue) {
        super(holder);
        SimpleConfigurationNode child = holder.createNode(0);
        child.attached = true;
        child.setValue(startValue);
        this.values.get().add(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Object getValue() {
        List<SimpleConfigurationNode> values;
        List<SimpleConfigurationNode> list = values = this.values.get();
        synchronized (list) {
            ArrayList<Object> ret = new ArrayList<Object>(values.size());
            for (SimpleConfigurationNode obj : values) {
                ret.add(obj.getValue());
            }
            return ret;
        }
    }

    @Override
    public void setValue(@Nullable Object value) {
        if (!(value instanceof Collection)) {
            value = Collections.singleton(value);
        }
        Collection valueAsList = value;
        ArrayList<SimpleConfigurationNode> newValue = new ArrayList<SimpleConfigurationNode>(valueAsList.size());
        int count = 0;
        for (Object o : valueAsList) {
            if (o == null) continue;
            SimpleConfigurationNode child = this.holder.createNode(count);
            newValue.add(count, child);
            child.attached = true;
            child.setValue(o);
            ++count;
        }
        ListConfigValue.detachNodes(this.values.getAndSet(newValue));
    }

    @Override
    public @Nullable SimpleConfigurationNode putChild(@NonNull Object key, @Nullable SimpleConfigurationNode value) {
        return this.putChild((Integer)key, value, false);
    }

    @Override
    @Nullable SimpleConfigurationNode putChildIfAbsent(@NonNull Object key, @Nullable SimpleConfigurationNode value) {
        return this.putChild((Integer)key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleConfigurationNode putChild(int index, @Nullable SimpleConfigurationNode value, boolean onlyIfAbsent) {
        List<SimpleConfigurationNode> values;
        SimpleConfigurationNode ret = null;
        do {
            List<SimpleConfigurationNode> list = values = this.values.get();
            synchronized (list) {
                if (value == null) {
                    if (index < values.size()) {
                        ret = values.remove(index);
                        for (int i = index; i < values.size(); ++i) {
                            values.get((int)i).key = index;
                        }
                    }
                } else if (index >= 0 && index < values.size()) {
                    if (onlyIfAbsent) {
                        return values.get(index);
                    }
                    ret = values.set(index, value);
                } else if (index == -1) {
                    values.add(value);
                    value.key = values.lastIndexOf(value);
                } else {
                    values.add(index, value);
                }
            }
        } while (!this.values.compareAndSet(values, values));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable SimpleConfigurationNode getChild(@Nullable Object key) {
        List<SimpleConfigurationNode> values;
        Integer value = Types.asInt(key);
        if (value == null || value < 0) {
            return null;
        }
        List<SimpleConfigurationNode> list = values = this.values.get();
        synchronized (list) {
            if (value >= values.size()) {
                return null;
            }
            return values.get(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Iterable<SimpleConfigurationNode> iterateChildren() {
        List<SimpleConfigurationNode> values;
        List<SimpleConfigurationNode> list = values = this.values.get();
        synchronized (list) {
            return ImmutableList.copyOf(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void detachNodes(List<SimpleConfigurationNode> children) {
        List<SimpleConfigurationNode> list = children;
        synchronized (list) {
            for (SimpleConfigurationNode node : children) {
                node.attached = false;
                node.clear();
            }
        }
    }

    @Override
    public void clear() {
        List oldValues = this.values.getAndSet(new ArrayList());
        ListConfigValue.detachNodes(oldValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListConfigValue that = (ListConfigValue)o;
        return Objects.equal(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.values});
    }
}

