/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate.commented;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import me.lucko.luckperms.lib.configurate.ConfigurationOptions;
import me.lucko.luckperms.lib.configurate.SimpleConfigurationNode;
import me.lucko.luckperms.lib.configurate.commented.CommentedConfigurationNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleCommentedConfigurationNode
extends SimpleConfigurationNode
implements CommentedConfigurationNode {
    private final AtomicReference<String> comment = new AtomicReference();

    public static @NonNull SimpleCommentedConfigurationNode root() {
        return SimpleCommentedConfigurationNode.root(ConfigurationOptions.defaults());
    }

    public static @NonNull SimpleCommentedConfigurationNode root(@NonNull ConfigurationOptions options) {
        return new SimpleCommentedConfigurationNode(null, null, options);
    }

    protected SimpleCommentedConfigurationNode(@Nullable Object path, @Nullable SimpleConfigurationNode parent, @NonNull ConfigurationOptions options) {
        super(path, parent, options);
    }

    @Override
    public @NonNull Optional<String> getComment() {
        return Optional.ofNullable(this.comment.get());
    }

    @Override
    public @NonNull SimpleCommentedConfigurationNode setComment(@Nullable String comment) {
        this.attachIfNecessary();
        this.comment.set(comment);
        return this;
    }

    @Override
    public @Nullable SimpleCommentedConfigurationNode getParent() {
        return (SimpleCommentedConfigurationNode)super.getParent();
    }

    @Override
    protected SimpleCommentedConfigurationNode createNode(Object path) {
        return new SimpleCommentedConfigurationNode(path, this, this.getOptions());
    }

    @Override
    public @NonNull SimpleCommentedConfigurationNode setValue(@Nullable Object value) {
        if (value instanceof CommentedConfigurationNode && ((CommentedConfigurationNode)value).getComment().isPresent()) {
            this.setComment(((CommentedConfigurationNode)value).getComment().get());
        }
        return (SimpleCommentedConfigurationNode)super.setValue(value);
    }

    @Override
    public @NonNull SimpleCommentedConfigurationNode mergeValuesFrom(@NonNull ConfigurationNode other) {
        Optional<String> otherComment;
        if (other instanceof CommentedConfigurationNode && (otherComment = ((CommentedConfigurationNode)other).getComment()).isPresent()) {
            this.comment.compareAndSet(null, otherComment.get());
        }
        return (SimpleCommentedConfigurationNode)super.mergeValuesFrom(other);
    }

    @Override
    public @NonNull SimpleCommentedConfigurationNode getNode(Object ... path) {
        return (SimpleCommentedConfigurationNode)super.getNode(path);
    }

    public @NonNull List<? extends SimpleCommentedConfigurationNode> getChildrenList() {
        return super.getChildrenList();
    }

    public @NonNull Map<Object, ? extends SimpleCommentedConfigurationNode> getChildrenMap() {
        return super.getChildrenMap();
    }

    @Override
    public @NonNull SimpleCommentedConfigurationNode getAppendedNode() {
        return (SimpleCommentedConfigurationNode)super.getAppendedNode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleCommentedConfigurationNode)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimpleCommentedConfigurationNode that = (SimpleCommentedConfigurationNode)o;
        return this.comment.equals(that.comment);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.comment.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SimpleCommentedConfigurationNode{super=" + super.toString() + ", comment=" + this.comment + '}';
    }
}

