/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate.loader;

import com.google.common.collect.Collections2;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import me.lucko.luckperms.lib.configurate.loader.CommentHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum CommentHandlers implements CommentHandler
{
    HASH("#"),
    DOUBLE_SLASH("//"),
    SLASH_BLOCK{

        @Override
        public @NonNull Optional<String> extractHeader(@NonNull BufferedReader reader) throws IOException {
            StringBuilder build = new StringBuilder();
            String line = reader.readLine();
            if (line == null) {
                return Optional.empty();
            }
            if (!line.trim().startsWith("/*")) {
                return Optional.empty();
            }
            if (this.handleSingleLine(build, line = line.substring(line.indexOf("/*") + 2))) {
                line = reader.readLine();
                while (line != null && this.handleSingleLine(build, line)) {
                    line = reader.readLine();
                }
            }
            if ((line = reader.readLine()) != null && !line.trim().isEmpty()) {
                return Optional.empty();
            }
            if (build.length() > 0) {
                return Optional.of(build.toString());
            }
            return Optional.empty();
        }

        private boolean handleSingleLine(StringBuilder builder, String line) {
            boolean moreLines = true;
            if (line.trim().endsWith("*/")) {
                if ((line = line.substring(0, line.lastIndexOf("*/"))).endsWith(" ")) {
                    line = line.substring(0, line.length() - 1);
                }
                moreLines = false;
                if (line.isEmpty()) {
                    return false;
                }
            }
            if (line.trim().startsWith("*")) {
                line = line.substring(line.indexOf("*") + 1);
            }
            if (line.startsWith(" ")) {
                line = line.substring(1);
            }
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line.replace("\r", "").replace("\n", "").replace("\r\n", ""));
            return moreLines;
        }

        @Override
        public @NonNull Collection<String> toComment(@NonNull Collection<String> lines) {
            if (lines.size() == 1) {
                return lines.stream().map(i -> "/* " + i + " */").collect(Collectors.toList());
            }
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("/*");
            ret.addAll(lines.stream().map(i -> " * " + i).collect(Collectors.toList()));
            ret.add(" */");
            return ret;
        }
    };

    private static final int READAHEAD_LEN = 4096;
    private final String commentPrefix;

    private CommentHandlers(String commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    private CommentHandlers() {
        this((String)null);
    }

    @Override
    public @NonNull Optional<String> extractHeader(@NonNull BufferedReader reader) throws IOException {
        StringBuilder build = new StringBuilder();
        String line = reader.readLine();
        while (line != null) {
            if (line.trim().startsWith(this.commentPrefix)) {
                if ((line = line.substring(line.indexOf(this.commentPrefix) + 1)).startsWith(" ")) {
                    line = line.substring(1);
                }
                if (build.length() > 0) {
                    build.append("\n");
                }
            } else {
                if (line.trim().isEmpty()) break;
                return Optional.empty();
            }
            build.append(line);
            line = reader.readLine();
        }
        return build.length() > 0 ? Optional.of(build.toString()) : Optional.empty();
    }

    @Override
    public @NonNull Collection<String> toComment(@NonNull Collection<String> lines) {
        return Collections2.transform(lines, s -> {
            if (s.startsWith(" ")) {
                return this.commentPrefix + s;
            }
            return this.commentPrefix + " " + s;
        });
    }

    public static @Nullable String extractComment(@NonNull BufferedReader reader, CommentHandler ... allowedHeaderTypes) throws IOException {
        reader.mark(4096);
        for (CommentHandler handler : allowedHeaderTypes) {
            Optional<String> comment = handler.extractHeader(reader);
            if (comment.isPresent()) {
                return comment.get();
            }
            reader.reset();
        }
        return null;
    }
}

