/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.caffeine.cache.stats;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import me.lucko.luckperms.lib.caffeine.cache.stats.CacheStats;
import me.lucko.luckperms.lib.caffeine.cache.stats.DisabledStatsCounter;
import me.lucko.luckperms.lib.caffeine.cache.stats.GuardedStatsCounter;

@ThreadSafe
public interface StatsCounter {
    public void recordHits(@Nonnegative int var1);

    public void recordMisses(@Nonnegative int var1);

    public void recordLoadSuccess(@Nonnegative long var1);

    public void recordLoadFailure(@Nonnegative long var1);

    @Deprecated
    public void recordEviction();

    default public void recordEviction(int weight) {
        this.recordEviction();
    }

    @Nonnull
    public CacheStats snapshot();

    @Nonnull
    public static StatsCounter disabledStatsCounter() {
        return DisabledStatsCounter.INSTANCE;
    }

    @Nonnull
    public static StatsCounter guardedStatsCounter(@Nonnull StatsCounter statsCounter) {
        return new GuardedStatsCounter(statsCounter);
    }
}

