/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.CollisionHelper;
import vswe.superfactory.Localization;
import vswe.superfactory.blocks.ConnectionBlock;
import vswe.superfactory.blocks.ConnectionBlockType;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.ComponentMenuContainerTypes;
import vswe.superfactory.components.ContainerFilter;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.RadioButton;
import vswe.superfactory.components.RadioButtonList;
import vswe.superfactory.components.ScrollController;
import vswe.superfactory.components.Variable;
import vswe.superfactory.components.VariableColor;
import vswe.superfactory.components.internal.IContainerSelection;
import vswe.superfactory.interfaces.Color;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiBase;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.interfaces.IAdvancedTooltip;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;
import vswe.superfactory.tiles.TileEntityManager;

public abstract class ComponentMenuContainer
extends ComponentMenu {
    private static final int BACK_SIZE_H = 9;
    private static final int BACK_SIZE_W = 9;
    private static final int BACK_SRC_X = 46;
    private static final int BACK_SRC_Y = 52;
    private static final int BACK_X = 108;
    private static final int BACK_Y = 57;
    private static final int CHECK_BOX_FILTER_INVERT_Y = 55;
    private static final int CHECK_BOX_FILTER_SPACING = 12;
    private static final int CHECK_BOX_FILTER_Y = 5;
    private static final int FILTER_BUTTON_X = 90;
    private static final int FILTER_BUTTON_Y = 0;
    private static final int FILTER_RESET_BUTTON_X = 70;
    private static final int INVENTORY_SIZE = 16;
    private static final int INVENTORY_SRC_X = 30;
    private static final int INVENTORY_SRC_Y = 20;
    private static final int MENU_WIDTH = 120;
    private static final String NBT_SELECTION = "InventorySelection";
    private static final String NBT_SELECTION_ID = "InventoryID";
    private static final String NBT_SHARED = "SharedCommand";
    private static final int RADIO_BUTTON_MULTI_X = 2;
    private static final int RADIO_BUTTON_MULTI_Y = 27;
    private static final int RADIO_BUTTON_SPACING = 15;
    private static final int TEXT_MULTI_ERROR_Y = 30;
    private static final int TEXT_MULTI_MARGIN_X = 5;
    private static final int TEXT_MULTI_Y = 10;
    private static final ContainerFilter filter = new ContainerFilter();
    private static boolean hasUpdated;
    protected RadioButtonList radioButtonsMulti;
    protected ScrollController<IContainerSelection> scrollController;
    protected List<Integer> selectedInventories;
    private List<Button> buttons;
    @SideOnly(value=Side.CLIENT)
    private GuiManager cachedInterface;
    private boolean clientUpdate;
    private Page currentPage;
    private List<Variable> filterVariables;
    private List<IContainerSelection> inventories;
    private ConnectionBlockType validType;

    public ComponentMenuContainer(FlowComponent parent, ConnectionBlockType validType) {
        super(parent);
        this.validType = validType;
        this.selectedInventories = new ArrayList<Integer>();
        this.filterVariables = new ArrayList<Variable>();
        this.radioButtonsMulti = new RadioButtonList(){

            @Override
            public void updateSelectedOption(int selectedOption) {
                DataWriter dw = ComponentMenuContainer.this.getWriterForServerComponentPacket();
                ComponentMenuContainer.this.writeRadioButtonData(dw, selectedOption);
                PacketHandler.sendDataToServer(dw);
            }
        };
        this.initRadioButtons();
        this.scrollController = new ScrollController<IContainerSelection>(this.getDefaultSearch()){
            private IContainerSelection cachedContainer;
            private int cachedId;
            @SideOnly(value=Side.CLIENT)
            private ToolTip cachedTooltip;
            private boolean keepCache;
            private boolean locked;
            private int lockedX;
            private int lockedY;

            @Override
            protected List<IContainerSelection> getSearchResults(String search, boolean all) {
                if (search.equals("") || !ComponentMenuContainer.this.clientUpdate || ComponentMenuContainer.this.cachedInterface == null) {
                    return new ArrayList<IContainerSelection>();
                }
                if (ComponentMenuContainer.this.inventories == null) {
                    ComponentMenuContainer.this.inventories = ComponentMenuContainer.this.getInventories(ComponentMenuContainer.this.getParent().getManager());
                }
                if (search.equals(".var")) {
                    return new ArrayList<IContainerSelection>(ComponentMenuContainer.this.filterVariables);
                }
                boolean noFilter = search.equals(".nofilter");
                boolean selected = search.equals(".selected");
                ArrayList<IContainerSelection> ret = new ArrayList<IContainerSelection>(ComponentMenuContainer.this.inventories);
                Iterator iterator = ret.iterator();
                while (iterator.hasNext()) {
                    IContainerSelection element = (IContainerSelection)iterator.next();
                    if (selected && ComponentMenuContainer.this.selectedInventories.contains(element.getId())) continue;
                    if (!element.isVariable()) {
                        ConnectionBlock block = (ConnectionBlock)element;
                        if (noFilter || (all || block.getName(ComponentMenuContainer.this.cachedInterface).toLowerCase().contains(search)) && filter.matches(ComponentMenuContainer.this.getParent().getManager(), ComponentMenuContainer.this.selectedInventories, block)) continue;
                    }
                    iterator.remove();
                }
                return ret;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            protected void onClick(IContainerSelection iContainerSelection, int mX, int mY, int button) {
                if (GuiScreen.func_146272_n() && mX != -1 && mY != -1) {
                    if (this.cachedTooltip != null && this.cachedId == iContainerSelection.getId()) {
                        if (!this.locked) {
                            this.lockedX = mX;
                            this.lockedY = mY;
                        }
                        this.locked = !this.locked;
                    }
                } else {
                    ComponentMenuContainer.this.setSelectedInventoryAndSync(iContainerSelection.getId(), !ComponentMenuContainer.this.selectedInventories.contains(iContainerSelection.getId()));
                }
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            protected void draw(GuiManager gui, IContainerSelection iContainerSelection, int x, int y, boolean hover) {
                ComponentMenuContainer.this.drawContainer(gui, iContainerSelection, ComponentMenuContainer.this.selectedInventories, x, y, hover);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void drawMouseOver(GuiManager gui, int mX, int mY) {
                if (this.locked && GuiBase.func_146272_n()) {
                    this.drawMouseOver(gui, this.cachedContainer, this.lockedX, this.lockedY, mX, mY);
                    this.cachedTooltip.drawMouseOverMouseOver(gui, this.lockedX + gui.getAdvancedToolTipContentStartX(this.cachedTooltip), this.lockedY + gui.getAdvancedToolTipContentStartY(this.cachedTooltip), mX, mY);
                } else {
                    this.locked = false;
                    this.keepCache = false;
                    super.drawMouseOver(gui, mX, mY);
                    if (!this.keepCache) {
                        this.cachedTooltip = null;
                        this.cachedContainer = null;
                    }
                }
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            protected void drawMouseOver(GuiManager gui, IContainerSelection iContainerSelection, int mX, int mY) {
                this.drawMouseOver(gui, iContainerSelection, mX, mY, mX, mY);
            }

            @SideOnly(value=Side.CLIENT)
            private void drawMouseOver(GuiManager gui, IContainerSelection iContainerSelection, int x, int y, int mX, int mY) {
                boolean isBlock;
                boolean bl = isBlock = !iContainerSelection.isVariable();
                if (GuiScreen.func_146272_n() && isBlock) {
                    if (this.cachedTooltip == null || this.cachedId != iContainerSelection.getId()) {
                        this.cachedContainer = iContainerSelection;
                        this.cachedTooltip = new ToolTip(gui, (ConnectionBlock)iContainerSelection);
                        this.cachedId = iContainerSelection.getId();
                    }
                    this.keepCache = true;
                    gui.drawMouseOver(this.cachedTooltip, x, y, mX, mY);
                } else {
                    List<String> lines = ComponentMenuContainer.this.getMouseOverForContainer(iContainerSelection, ComponentMenuContainer.this.selectedInventories);
                    if (isBlock) {
                        if (lines == null) {
                            lines = new ArrayList<String>();
                        }
                        lines.add("");
                        lines.add((Object)((Object)Color.GRAY) + Localization.TOOLTIP_EXTRA_INFO.toString());
                    }
                    gui.drawMouseOver(lines, mX, mY);
                }
            }

            @SideOnly(value=Side.CLIENT)
            class ToolTip
            implements IAdvancedTooltip {
                private static final int SRC_X = 30;
                private static final int SRC_Y = 20;
                List<String> lockedSuffix;
                List<String> prefix;
                List<String> suffix;
                private List<String>[] itemTexts;
                private ItemStack[] items = new ItemStack[EnumFacing.values().length];

                @SideOnly(value=Side.CLIENT)
                public ToolTip(GuiManager gui, ConnectionBlock block) {
                    this.itemTexts = new List[EnumFacing.values().length];
                    World world = block.getTileEntity().func_145831_w();
                    int x = block.getTileEntity().func_174877_v().func_177958_n();
                    int y = block.getTileEntity().func_174877_v().func_177956_o();
                    int z = block.getTileEntity().func_174877_v().func_177952_p();
                    for (EnumFacing direction : EnumFacing.values()) {
                        ItemStack item;
                        int targetX = x + direction.func_82601_c();
                        int targetY = y + direction.func_96559_d();
                        int targetZ = z + direction.func_82599_e();
                        this.items[direction.ordinal()] = item = gui.getItemStackFromBlock(world, targetX, targetY, targetZ);
                        ArrayList<String> text = new ArrayList<String>();
                        if (!item.func_190926_b()) {
                            text.add(gui.getItemName(item));
                        }
                        String side = Localization.getDirectionLocalization(direction).toString();
                        text.add((Object)((Object)Color.YELLOW) + side);
                        TileEntity te = world.func_175625_s(new BlockPos(targetX, targetY, targetZ));
                        if (te instanceof TileEntitySign) {
                            TileEntitySign sign = (TileEntitySign)te;
                            for (ITextComponent txt : sign.field_145915_a) {
                                if (txt.func_150254_d().isEmpty()) continue;
                                text.add((Object)((Object)Color.GRAY) + txt.func_150254_d());
                            }
                        }
                        this.itemTexts[direction.ordinal()] = text;
                    }
                    this.prefix = ComponentMenuContainer.this.getMouseOverForContainer(block, ComponentMenuContainer.this.selectedInventories);
                    this.prefix.add("");
                    this.prefix.add((Object)((Object)Color.LIGHT_BLUE) + Localization.TOOLTIP_ADJACENT.toString());
                    this.suffix = new ArrayList<String>();
                    this.suffix.add((Object)((Object)Color.GRAY) + Localization.TOOLTIP_LOCK.toString());
                    this.lockedSuffix = gui.getLinesFromText(Localization.TOOLTIP_UNLOCK.toString(), this.getMinWidth(gui));
                    for (int i = 0; i < this.lockedSuffix.size(); ++i) {
                        this.lockedSuffix.set(i, (Object)((Object)Color.GRAY) + this.lockedSuffix.get(i));
                    }
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public int getMinWidth(GuiBase gui) {
                    return 110;
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public int getExtraHeight(GuiBase gui) {
                    return 70;
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void drawContent(GuiBase gui, int x, int y, int mX, int mY) {
                    this.drawBlock(gui, x + 25, y + 5, mX, mY, EnumFacing.NORTH);
                    this.drawBlock(gui, x + 5, y + 25, mX, mY, EnumFacing.WEST);
                    this.drawBlock(gui, x + 25, y + 45, mX, mY, EnumFacing.SOUTH);
                    this.drawBlock(gui, x + 45, y + 25, mX, mY, EnumFacing.EAST);
                    this.drawBlock(gui, x + 80, y + 15, mX, mY, EnumFacing.UP);
                    this.drawBlock(gui, x + 80, y + 35, mX, mY, EnumFacing.DOWN);
                }

                @SideOnly(value=Side.CLIENT)
                private void drawBlock(GuiBase gui, int x, int y, int mX, int mY, EnumFacing direction) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GuiBase.bindTexture(gui.getComponentResource());
                    gui.drawTexture(x, y, 30, 20 + (CollisionHelper.inBounds(x, y, 16, 16, mX, mY) ? 16 : 0), 16, 16);
                    ItemStack item = this.items[direction.ordinal()];
                    if (!item.func_190926_b()) {
                        gui.drawItemStack(item, x, y);
                        gui.drawItemAmount(item, x, y);
                    }
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public List<String> getPrefix(GuiBase gui) {
                    return this.prefix;
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public List<String> getSuffix(GuiBase gui) {
                    return locked ? this.lockedSuffix : this.suffix;
                }

                @SideOnly(value=Side.CLIENT)
                private void drawMouseOverMouseOver(GuiBase gui, int x, int y, int mX, int mY) {
                    boolean ignored = this.drawBlockMouseOver(gui, x + 25, y + 5, mX, mY, EnumFacing.NORTH) || this.drawBlockMouseOver(gui, x + 5, y + 25, mX, mY, EnumFacing.WEST) || this.drawBlockMouseOver(gui, x + 25, y + 45, mX, mY, EnumFacing.SOUTH) || this.drawBlockMouseOver(gui, x + 45, y + 25, mX, mY, EnumFacing.EAST) || this.drawBlockMouseOver(gui, x + 80, y + 15, mX, mY, EnumFacing.UP) || this.drawBlockMouseOver(gui, x + 80, y + 35, mX, mY, EnumFacing.DOWN);
                }

                @SideOnly(value=Side.CLIENT)
                private boolean drawBlockMouseOver(GuiBase gui, int x, int y, int mX, int mY, EnumFacing direction) {
                    if (CollisionHelper.inBounds(x, y, 16, 16, mX, mY)) {
                        List<String> itemText = this.itemTexts[direction.ordinal()];
                        if (itemText != null) {
                            gui.drawMouseOver(itemText, mX, mY);
                        }
                        return true;
                    }
                    return false;
                }
            }
        };
        this.buttons = new ArrayList<Button>();
        this.buttons.add(new PageButton(Localization.FILTER_SHORT, Page.MAIN, Localization.FILTER_LONG, Page.FILTER, false, 102, 21));
        this.buttons.add(new PageButton(Localization.MULTI_SHORT, Page.MAIN, Localization.MULTI_LONG, Page.MULTI, false, 111, 21));
        Page[] subFilterPages = new Page[]{Page.POSITION, Page.DISTANCE, Page.SELECTION, Page.VARIABLE};
        for (int i = 0; i < subFilterPages.length; ++i) {
            this.buttons.add(new PageButton(Localization.SUB_MENU_SHORT, Page.FILTER, Localization.SUB_MENU_LONG, subFilterPages[i], true, 90, 5 + 12 * i + 0));
        }
        this.buttons.add(new Button(Localization.CLEAR_SHORT, Page.FILTER, Localization.CLEAR_LONG, true, 70, 55){

            @Override
            void onClick() {
                filter.clear();
            }
        });
        this.buttons.add(new Button(Localization.SELECT_ALL_SHORT, Page.MAIN, Localization.SELECT_ALL_LONG, false, 102, 51){

            @Override
            void onClick() {
                for (IContainerSelection iContainerSelection : ComponentMenuContainer.this.scrollController.getResult()) {
                    if (ComponentMenuContainer.this.selectedInventories.contains(iContainerSelection.getId())) continue;
                    ComponentMenuContainer.this.scrollController.onClick(iContainerSelection, -1, -1, 0);
                }
            }
        });
        this.buttons.add(new Button(Localization.SELECT_NONE_SHORT, Page.MAIN, Localization.SELECT_NONE_LONG, false, 111, 51){

            @Override
            void onClick() {
                for (IContainerSelection iContainerSelection : ComponentMenuContainer.this.scrollController.getResult()) {
                    if (!ComponentMenuContainer.this.selectedInventories.contains(iContainerSelection.getId())) continue;
                    ComponentMenuContainer.this.scrollController.onClick(iContainerSelection, -1, -1, 0);
                }
            }
        });
        this.buttons.add(new Button(Localization.SELECT_INVERT_SHORT, Page.MAIN, Localization.SELECT_INVERT_LONG, false, 102, 60){

            @Override
            void onClick() {
                for (IContainerSelection iContainerSelection : ComponentMenuContainer.this.scrollController.getResult()) {
                    ComponentMenuContainer.this.scrollController.onClick(iContainerSelection, -1, -1, 0);
                }
            }
        });
        this.buttons.add(new Button(Localization.SELECT_VARIABLE_SHORT, Page.MAIN, Localization.SELECT_VARIABLE_LONG, false, 111, 60){

            @Override
            void onClick() {
                if (ComponentMenuContainer.this.scrollController.getText().equals(".var")) {
                    ComponentMenuContainer.this.scrollController.setTextAndCursor(".all");
                } else {
                    ComponentMenuContainer.this.scrollController.setTextAndCursor(".var");
                }
            }
        });
        this.currentPage = Page.MAIN;
    }

    protected String getDefaultSearch() {
        return ".all";
    }

    @SideOnly(value=Side.CLIENT)
    void drawContainer(GuiManager gui, IContainerSelection iContainerSelection, List<Integer> selected, int x, int y, boolean hover) {
        int srcInventoryX = selected.contains(iContainerSelection.getId()) ? 1 : 0;
        int srcInventoryY = hover ? 1 : 0;
        gui.drawTexture(x, y, 30 + srcInventoryX * 16, 20 + srcInventoryY * 16, 16, 16);
        iContainerSelection.draw(gui, x, y);
    }

    List<String> getMouseOverForContainer(IContainerSelection iContainerSelection, List<Integer> selected) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.cachedInterface != null) {
            String[] desc;
            for (String s : desc = iContainerSelection.getDescription(this.cachedInterface).split("\n")) {
                ret.add(s);
            }
            if (selected.contains(iContainerSelection.getId())) {
                ret.add((Object)((Object)Color.GREEN) + Localization.SELECTED.toString());
            }
        }
        return ret;
    }

    protected void initRadioButtons() {
        this.radioButtonsMulti.add(new RadioButtonInventory(0, Localization.RUN_SHARED_ONCE));
        this.radioButtonsMulti.add(new RadioButtonInventory(1, Localization.RUN_ONE_PER_TARGET));
    }

    private void writeRadioButtonData(DataWriter dw, int option) {
        dw.writeBoolean(true);
        dw.writeData(option, DataBitHelper.MENU_INVENTORY_MULTI_SELECTION_TYPE);
    }

    private void setSelectedInventoryAndSync(int val, boolean select) {
        DataWriter dw = this.getWriterForServerComponentPacket();
        this.writeData(dw, val, select);
        PacketHandler.sendDataToServer(dw);
    }

    private void writeData(DataWriter dw, int id, boolean select) {
        dw.writeBoolean(false);
        dw.writeInventoryId(this.getParent().getManager(), id);
        dw.writeBoolean(select);
    }

    private List<IContainerSelection> getInventories(TileEntityManager manager) {
        EnumSet<ConnectionBlockType> validTypes = this.getValidTypes();
        List<ConnectionBlock> tempInventories = manager.getConnectedInventories();
        ArrayList<IContainerSelection> ret = new ArrayList<IContainerSelection>();
        this.filterVariables.clear();
        for (int i = 0; i < manager.getVariables().length; ++i) {
            Variable variable = manager.getVariables()[i];
            if (!this.isVariableAllowed(validTypes, i)) continue;
            ret.add(variable);
            this.filterVariables.add(variable);
        }
        for (ConnectionBlock tempInventory : tempInventories) {
            if (!tempInventory.isOfAnyType(validTypes)) continue;
            ret.add(tempInventory);
        }
        if (this.getParent().isInventoryListDirty()) {
            this.getParent().setInventoryListDirty(false);
            this.scrollController.getSearchResults();
        }
        ComponentMenuContainer.filter.scrollControllerVariable.getSearchResults();
        return ret;
    }

    protected EnumSet<ConnectionBlockType> getValidTypes() {
        return EnumSet.of(this.validType);
    }

    public boolean isVariableAllowed(EnumSet<ConnectionBlockType> validTypes, int i) {
        Variable variable = this.getParent().getManager().getVariables()[i];
        if (variable.isValid()) {
            EnumSet<ConnectionBlockType> variableValidTypes = ((ComponentMenuContainerTypes)variable.getDeclaration().getMenus().get(1)).getValidTypes();
            for (ConnectionBlockType type : validTypes) {
                if (!ConnectionBlock.isOfType(variableValidTypes, type)) continue;
                return true;
            }
        }
        return false;
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }

    public List<Variable> getFilterVariables() {
        return this.filterVariables;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        this.clientUpdate = true;
        this.cachedInterface = gui;
        ComponentMenuContainer.filter.currentMenu = this;
        if (this.currentPage == Page.MAIN) {
            this.inventories = this.getInventories(gui.getManager());
            this.scrollController.draw(gui, mX, mY);
        } else if (this.currentPage == Page.MULTI) {
            gui.drawCenteredString(this.selectedInventories.size() + " " + Localization.SELECTED_CONTAINERS.toString(), 5, 10, 0.9f, 110, 0x404040);
            Object error = null;
            if (this.radioButtonsMulti.size() == 0) {
                error = Localization.NO_MULTI_SETTING.toString();
            } else if (!this.hasMultipleInventories()) {
                error = Localization.SINGLE_SELECTED.toString();
            }
            if (error != null) {
                gui.drawSplitString((String)error, 5, 30, 110, 0.7f, 0x404040);
            }
            if (this.hasMultipleInventories()) {
                this.radioButtonsMulti.draw(gui, mX, mY);
            }
        } else if (this.currentPage == Page.POSITION) {
            gui.drawString(Localization.RELATIVE_COORDINATES.toString(), 5, 60, 0.5f, 0x404040);
        } else if (this.currentPage == Page.SELECTION) {
            ComponentMenuContainer.filter.radioButtonsSelection.draw(gui, mX, mY);
        } else if (this.currentPage == Page.VARIABLE) {
            ComponentMenuContainer.filter.radioButtonVariable.draw(gui, mX, mY);
            if (filter.isVariableListVisible()) {
                this.inventories = this.getInventories(gui.getManager());
                ComponentMenuContainer.filter.scrollControllerVariable.draw(gui, mX, mY);
            }
        }
        ComponentMenuContainer.filter.textBoxes.draw(gui, mX, mY);
        for (Button button : this.buttons) {
            button.draw(gui, mX, mY);
        }
        ComponentMenuContainer.filter.checkBoxes.draw(gui, mX, mY);
        if (this.currentPage.parent != null) {
            int srcBackX = this.inBackBounds(mX, mY) ? 1 : 0;
            gui.drawTexture(108, 57, 46 + srcBackX * 9, 52, 9, 9);
        }
        hasUpdated = false;
    }

    private boolean inBackBounds(int mX, int mY) {
        return CollisionHelper.inBounds(108, 57, 9, 9, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        ComponentMenuContainer.filter.currentMenu = this;
        if (this.currentPage == Page.MAIN) {
            this.scrollController.drawMouseOver(gui, mX, mY);
        } else if (this.currentPage == Page.VARIABLE && filter.isVariableListVisible()) {
            ComponentMenuContainer.filter.scrollControllerVariable.drawMouseOver(gui, mX, mY);
        } else if (this.currentPage == Page.POSITION && CollisionHelper.inBounds(5, 60, 100, 5, mX, mY)) {
            String str = Localization.ABSOLUTE_RANGES.toString() + ":";
            str = str + "\n" + Localization.X.toString() + " (" + (ComponentMenuContainer.filter.lowerRange[0].getNumber() + this.getParent().getManager().func_174877_v().func_177958_n()) + ", " + (ComponentMenuContainer.filter.higherRange[0].getNumber() + this.getParent().getManager().func_174877_v().func_177958_n()) + ")";
            str = str + "\n" + Localization.Y.toString() + " (" + (ComponentMenuContainer.filter.lowerRange[1].getNumber() + this.getParent().getManager().func_174877_v().func_177956_o()) + ", " + (ComponentMenuContainer.filter.higherRange[1].getNumber() + this.getParent().getManager().func_174877_v().func_177956_o()) + ")";
            str = str + "\n" + Localization.Z.toString() + " (" + (ComponentMenuContainer.filter.lowerRange[2].getNumber() + this.getParent().getManager().func_174877_v().func_177952_p()) + ", " + (ComponentMenuContainer.filter.higherRange[2].getNumber() + this.getParent().getManager().func_174877_v().func_177952_p()) + ")";
            gui.drawMouseOver(str, mX, mY);
        }
        for (Button button : this.buttons) {
            button.drawMouseOver(gui, mX, mY);
        }
        if (this.currentPage.parent != null && this.inBackBounds(mX, mY)) {
            gui.drawMouseOver(Localization.GO_BACK.toString(), mX, mY);
        }
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        ComponentMenuContainer.filter.currentMenu = this;
        if (this.currentPage == Page.MAIN) {
            this.scrollController.onClick(mX, mY, b);
        } else if (this.currentPage == Page.MULTI) {
            if (this.hasMultipleInventories()) {
                this.radioButtonsMulti.onClick(mX, mY, b);
            }
        } else if (this.currentPage == Page.SELECTION) {
            ComponentMenuContainer.filter.radioButtonsSelection.onClick(mX, mY, b);
        } else if (this.currentPage == Page.VARIABLE) {
            ComponentMenuContainer.filter.radioButtonVariable.onClick(mX, mY, b);
            if (filter.isVariableListVisible()) {
                ComponentMenuContainer.filter.scrollControllerVariable.onClick(mX, mY, b);
            }
        }
        for (Button button : this.buttons) {
            if (!button.inBounds(mX, mY)) continue;
            button.onClick();
            break;
        }
        ComponentMenuContainer.filter.checkBoxes.onClick(mX, mY);
        ComponentMenuContainer.filter.textBoxes.onClick(mX, mY, b);
        if (this.currentPage.parent != null && this.inBackBounds(mX, mY)) {
            this.currentPage = this.currentPage.parent;
        }
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
        ComponentMenuContainer.filter.currentMenu = this;
        this.scrollController.onRelease(mX, mY);
        ComponentMenuContainer.filter.scrollControllerVariable.onRelease(mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        ComponentMenuContainer.filter.currentMenu = this;
        return this.currentPage == Page.MAIN ? this.scrollController.onKeyStroke(gui, c, k) : ComponentMenuContainer.filter.textBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeData(this.getOption(), DataBitHelper.MENU_INVENTORY_MULTI_SELECTION_TYPE);
        dw.writeInventoryId(this.getParent().getManager(), this.selectedInventories.size());
        for (int selectedInventory : this.selectedInventories) {
            dw.writeInventoryId(this.getParent().getManager(), selectedInventory);
        }
    }

    @Override
    public void readData(DataReader dr) {
        this.setOption(dr.readData(DataBitHelper.MENU_INVENTORY_MULTI_SELECTION_TYPE));
        this.selectedInventories.clear();
        int count = dr.readInventoryId();
        for (int i = 0; i < count; ++i) {
            this.selectedInventories.add(dr.readInventoryId());
        }
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        this.setOption(((ComponentMenuContainer)menu).getOption());
        this.selectedInventories.clear();
        for (int selectedInventory : ((ComponentMenuContainer)menu).selectedInventories) {
            this.selectedInventories.add(selectedInventory);
        }
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        int id;
        int i;
        ComponentMenuContainer newDataInv = (ComponentMenuContainer)newData;
        if (newDataInv.getOption() != this.getOption()) {
            this.setOption(newDataInv.getOption());
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            this.writeRadioButtonData(dw, this.getOption());
            PacketHandler.sendDataToListeningClients(container, dw);
        }
        int count = newDataInv.selectedInventories.size();
        for (i = 0; i < count; ++i) {
            id = newDataInv.selectedInventories.get(i);
            if (this.selectedInventories.contains(id)) continue;
            this.selectedInventories.add(id);
            this.sendClientData(container, id, true);
        }
        for (i = this.selectedInventories.size() - 1; i >= 0; --i) {
            id = this.selectedInventories.get(i);
            if (newDataInv.selectedInventories.contains(id)) continue;
            this.selectedInventories.remove(i);
            this.sendClientData(container, id, false);
        }
    }

    private void sendClientData(ContainerManager container, int id, boolean select) {
        DataWriter dw = this.getWriterForClientComponentPacket(container);
        this.writeData(dw, id, select);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.selectedInventories.clear();
        if (version < 2) {
            this.selectedInventories.add(Integer.valueOf(nbtTagCompound.func_74765_d(NBT_SELECTION)));
            this.setOption(0);
        } else {
            if (!pickup) {
                NBTTagList tagList = nbtTagCompound.func_150295_c(NBT_SELECTION, 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound selectionTag = tagList.func_150305_b(i);
                    int id = selectionTag.func_74765_d(NBT_SELECTION_ID);
                    if (version < 7) {
                        id += VariableColor.values().length;
                    }
                    this.selectedInventories.add(id);
                }
            }
            this.setOption(nbtTagCompound.func_74771_c(NBT_SHARED));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        NBTTagList tagList = new NBTTagList();
        if (!pickup) {
            for (int i = 0; i < this.selectedInventories.size(); ++i) {
                NBTTagCompound selectionTag = new NBTTagCompound();
                selectionTag.func_74777_a(NBT_SELECTION_ID, (short)this.selectedInventories.get(i).intValue());
                tagList.func_74742_a((NBTBase)selectionTag);
            }
        }
        nbtTagCompound.func_74782_a(NBT_SELECTION, (NBTBase)tagList);
        nbtTagCompound.func_74774_a(NBT_SHARED, (byte)this.getOption());
    }

    @Override
    public void update(float partial) {
        this.scrollController.update(partial);
        if (!hasUpdated) {
            ComponentMenuContainer.filter.scrollControllerVariable.update(partial);
            hasUpdated = true;
        }
    }

    @Override
    public void doScroll(int scroll) {
        if (this.currentPage == Page.MAIN) {
            this.scrollController.doScroll(scroll);
        } else if (this.currentPage == Page.VARIABLE) {
            ComponentMenuContainer.filter.scrollControllerVariable.doScroll(scroll);
        }
    }

    public int getOption() {
        return this.radioButtonsMulti.getSelectedOption();
    }

    protected void setOption(int val) {
        this.radioButtonsMulti.setSelectedOption(val);
    }

    private boolean hasMultipleInventories() {
        return this.selectedInventories.size() > 1 || this.selectedInventories.size() > 0 && this.selectedInventories.get(0) < VariableColor.values().length;
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        if (dr.readBoolean()) {
            this.setOption(dr.readData(DataBitHelper.MENU_INVENTORY_MULTI_SELECTION_TYPE));
        } else {
            int id = dr.readInventoryId();
            if (dr.readBoolean()) {
                this.selectedInventories.add(id);
            } else {
                this.selectedInventories.remove((Object)id);
            }
        }
    }

    public List<Integer> getSelectedInventories() {
        return this.selectedInventories;
    }

    public void setSelectedInventories(List<Integer> selectedInventories) {
        this.selectedInventories = selectedInventories;
    }

    protected class RadioButtonInventory
    extends RadioButton {
        public RadioButtonInventory(int id, Localization text) {
            super(2, 27 + id * 15, text);
        }
    }

    private class PageButton
    extends Button {
        private Page targetPage;

        private PageButton(Localization label, Page page, Localization description, Page targetPage, boolean wide, int x, int y) {
            super(label, page, description, wide, x, y);
            this.targetPage = targetPage;
        }

        @Override
        void onClick() {
            ComponentMenuContainer.this.currentPage = this.targetPage;
        }
    }

    private abstract class Button {
        private final int height;
        private final int srcX;
        private final int srcY;
        private final int width;
        Localization description;
        Localization label;
        Page page;
        int x;
        int y;

        protected Button(Localization label, Page page, Localization description, boolean wide, int x, int y) {
            this.x = x;
            this.y = y;
            this.page = page;
            this.label = label;
            this.description = description;
            if (wide) {
                this.width = 20;
                this.srcX = 58;
            } else {
                this.width = 8;
                this.srcX = 50;
            }
            this.height = 8;
            this.srcY = 189;
        }

        abstract void onClick();

        @SideOnly(value=Side.CLIENT)
        void draw(GuiManager gui, int mX, int mY) {
            if (this.isVisible()) {
                gui.drawTexture(this.x, this.y, this.srcX, this.srcY + (this.inBounds(mX, mY) ? this.height : 0), this.width, this.height);
                gui.drawCenteredString(this.label.toString(), this.x + 1, this.y + 2, 0.7f, this.width - 2, 0x404040);
            }
        }

        boolean inBounds(int mX, int mY) {
            return this.isVisible() && CollisionHelper.inBounds(this.x, this.y, this.width, this.height, mX, mY);
        }

        boolean isVisible() {
            return ComponentMenuContainer.this.currentPage == this.page;
        }

        @SideOnly(value=Side.CLIENT)
        void drawMouseOver(GuiManager gui, int mX, int mY) {
            if (this.inBounds(mX, mY)) {
                gui.drawMouseOver(this.description.toString(), mX, mY);
            }
        }
    }

    public static enum Page {
        MAIN(null),
        MULTI(MAIN),
        FILTER(MAIN),
        POSITION(FILTER),
        DISTANCE(FILTER),
        SELECTION(FILTER),
        VARIABLE(FILTER);

        private Page parent;

        private Page(Page parent) {
            this.parent = parent;
        }
    }
}

