/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.pdd;

import com.google.common.base.Preconditions;
import gcewing.sg.features.pdd.AddressData;
import gcewing.sg.features.pdd.AddressDataEntry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;
import org.yaml.snakeyaml.DumperOptions;

public final class AddressNameRegistry {
    private static final Map<String, AddressDataEntry> entries = new HashMap<String, AddressDataEntry>();
    private static final String ADDRESSES_NODE = "addresses";

    public static ConfigurationNode createRootNode(Path path) throws IOException {
        YAMLConfigurationLoader loader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(path)).setFlowStyle(DumperOptions.FlowStyle.BLOCK).build();
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
            ConfigurationNode node = loader.createEmptyNode(ConfigurationOptions.defaults());
            node.getNode(ADDRESSES_NODE, "ABCD-EFG-HI", "name").setValue("Descriptive Name Here");
            node.getNode(ADDRESSES_NODE, "ABCD-EFG-HI", "locked").setValue(false);
            loader.save(node);
        }
        return loader.load(ConfigurationOptions.defaults());
    }

    public static void populateNames(ConfigurationNode root) {
        Preconditions.checkNotNull((Object)root);
        entries.clear();
        ConfigurationNode addressesRoot = root.getNode(ADDRESSES_NODE);
        for (Map.Entry<Object, ? extends ConfigurationNode> addressEntry : addressesRoot.getChildrenMap().entrySet()) {
            String address = addressEntry.getKey().toString().toLowerCase();
            String name = addressEntry.getValue().getNode("name").getString("");
            boolean locked = addressEntry.getValue().getNode("locked").getBoolean(true);
            if (name.isEmpty()) {
                System.err.println("Unable to add default PDD entry, missing name!");
                continue;
            }
            entries.put(address, new AddressDataEntry(name, locked));
        }
    }

    public static Optional<AddressDataEntry> getEntry(String address) {
        Preconditions.checkNotNull((Object)address);
        return Optional.ofNullable(entries.get(address));
    }

    public static Collection<Map.Entry<String, AddressDataEntry>> getEntries() {
        return Collections.unmodifiableCollection(entries.entrySet());
    }

    public static List<AddressData> getDefaultPDDEntries() {
        int index = 0;
        ArrayList<AddressData> addresses = new ArrayList<AddressData>();
        for (Map.Entry<String, AddressDataEntry> entry : AddressNameRegistry.getEntries()) {
            String address = entry.getKey();
            String name = entry.getValue().getName();
            boolean locked = entry.getValue().isLocked();
            if (address.length() == 11 && address.substring(4, 5).equalsIgnoreCase("-") && address.substring(8, 9).equalsIgnoreCase("-")) {
                addresses.add(new AddressData(name, address.toUpperCase(), locked, index, 0));
                ++index;
                continue;
            }
            System.err.println("Unable to add default PDD entry, invalid address format!");
        }
        return addresses;
    }
}

