/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.model;

import io.netty.buffer.ByteBuf;
import net.malisis.advert.advert.AdvertSelection;
import net.malisis.advert.model.AdvertModel;
import net.malisis.advert.renderer.AdvertRenderer;
import net.malisis.advert.tileentity.AdvertTileEntity;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.interaction.UICheckBox;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.icon.Icon;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TriangularColumn
extends AdvertModel<Variant> {
    private Shape base;
    private Shape topBottom;
    private Shape panels;
    @SideOnly(value=Side.CLIENT)
    private Icon icon;
    private AnimationRenderer ar;
    private Rotation rotation;

    public TriangularColumn() {
        this.name = this.id = "triangular_column";
        this.availableSlots = 3;
        this.width = 1.4f;
        this.height = 2.5f;
        this.objFile = new ResourceLocation("malisisadvert", "models/triangular_column.obj");
        this.placeHolder = new ResourceLocation("malisisadvert", "textures/blocks/MA23.png");
        if (MalisisCore.isClient()) {
            this.icon = Icon.from((String)"malisisadvert:blocks/triangular_column");
        }
    }

    @Override
    public void loadModelFile() {
        super.loadModelFile();
        this.base = this.model.getShape("base");
        this.topBottom = this.model.getShape("PanelsTopBottom");
        this.panels = this.model.getShape("Panels");
        this.ar = new AnimationRenderer();
        this.rotation = (Rotation)((Rotation)new Rotation(360.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f).forTicks(600)).loop(-1);
    }

    @Override
    public Variant defaultVariant(boolean wallMounted) {
        return new Variant();
    }

    @Override
    public AxisAlignedBB[] getBoundingBox(Variant variant) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)-0.2f, 0.0, (double)0.9f, (double)1.2f, 3.0, (double)-0.3f);
        return new AxisAlignedBB[]{aabb};
    }

    @Override
    public int getGuiComponent(MalisisGui gui, UIContainer<?> container, Variant variant, boolean wallMounted) {
        UICheckBox cb = (UICheckBox)new UICheckBox(gui, "malisisadvert.gui.model.triangular_column.rotate").setName("rotate");
        cb.setChecked(variant.rotate);
        container.add(new UIComponent[]{cb});
        return 15;
    }

    @Override
    public Variant getVariantFromGui(UIContainer<?> container) {
        Variant variant = new Variant();
        UICheckBox cb = (UICheckBox)container.getComponent("rotate");
        variant.rotate = cb.isChecked();
        return variant;
    }

    @Override
    public void renderBlock(AdvertRenderer renderer, AdvertTileEntity tileEntity, RenderParameters rp, Variant variant) {
        rp.icon.set((Object)this.icon);
        renderer.drawShape(this.base, rp);
    }

    @Override
    public void renderTileEntity(AdvertRenderer renderer, AdvertTileEntity tileEntity, RenderParameters rp, Variant variant) {
        if (variant.rotate) {
            this.ar.animate((ITransformable)this.topBottom, (Transformation)this.rotation);
        }
        this.topBottom.applyMatrix();
        renderer.next(4);
        rp.icon.set((Object)this.icon);
        renderer.drawShape(this.topBottom, rp);
        renderer.next(7);
        if (variant.rotate) {
            this.ar.animate((ITransformable)this.panels, (Transformation)this.rotation);
        }
        this.panels.applyMatrix();
        for (int i = 0; i < this.panels.getFaces().length; ++i) {
            Face face = this.panels.getFaces()[i];
            AdvertSelection as = tileEntity.getSelection(i);
            renderer.renderAdvertFace(face, as);
        }
    }

    public static class Variant
    implements AdvertModel.IModelVariant {
        boolean rotate = true;

        @Override
        public boolean isWallMounted() {
            return false;
        }

        @Override
        public void readFromNBT(NBTTagCompound tagCompound) {
            this.rotate = tagCompound.func_74764_b("rotate") ? tagCompound.func_74767_n("rotate") : true;
        }

        @Override
        public void writeToNBT(NBTTagCompound tagCompound) {
            tagCompound.func_74757_a("rotate", this.rotate);
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            this.rotate = buf.readBoolean();
        }

        @Override
        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.rotate);
        }
    }
}

