/*
 * Decompiled with CFR 0.152.
 */
package fr.nocturne123.questionstime;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import fr.nocturne123.questionstime.CommandCreateQuestion;
import fr.nocturne123.questionstime.QuestionTask;
import fr.nocturne123.questionstime.handler.ConfigHandler;
import fr.nocturne123.questionstime.handler.EventHandler;
import fr.nocturne123.questionstime.handler.MessageHandler;
import fr.nocturne123.questionstime.question.Question;
import fr.nocturne123.questionstime.question.QuestionCreator;
import fr.nocturne123.questionstime.question.QuestionSerializer;
import fr.nocturne123.questionstime.question.component.Malus;
import fr.nocturne123.questionstime.question.component.MalusSerializer;
import fr.nocturne123.questionstime.question.component.Prize;
import fr.nocturne123.questionstime.question.component.PrizeSerializer;
import fr.nocturne123.questionstime.util.TextUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppedEvent;
import org.spongepowered.api.event.service.ChangeServiceProviderEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

@Plugin(id="questionstime", name="QuestionsTime", version="1.1.7", description="Ask questions and gain prize for the winner", authors={"Nocturne123"})
public class QuestionsTime {
    private static QuestionsTime instance;
    @Inject
    private Logger logger;
    @Inject
    private Game game;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path path;
    @Inject
    private PluginContainer container;
    private ArrayList<Question> questions;
    public final Text qtPrefix = Text.builder((String)"[").color(TextColors.AQUA).append(new Text[]{Text.builder((String)"QT").color(TextColors.YELLOW).append(new Text[]{Text.builder((String)"] ").color(TextColors.AQUA).build()}).build()}).build();
    private Question currentQuestion;
    private EconomyService economy;
    private ArrayList<QuestionCreator> questionCreator;
    private long timedQuestionStarted;
    private Task taskTimer;

    @Listener
    public void onServerInitialization(GameInitializationEvent e) {
        instance = this;
        this.getConsole().sendMessage(TextUtils.Console.creatorNormalWithPrefix("~~~QUESTIONSTIME~~~"));
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(Question.class), (TypeSerializer)new QuestionSerializer());
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(Prize.class), (TypeSerializer)new PrizeSerializer());
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(Malus.class), (TypeSerializer)new MalusSerializer());
        this.questions = new ArrayList();
        if (this.path != null) {
            ConfigHandler.init(this.path);
            MessageHandler.init(this.path);
        } else {
            this.logger.warn("The file instance which is essential to access the config file was null. This shouldn't never happen. Try to restart the server ?");
        }
        this.questionCreator = new ArrayList();
        Sponge.getServiceManager().provide(EconomyService.class).ifPresent(economyService -> {
            this.economy = economyService;
        });
        Sponge.getEventManager().registerListeners((Object)this, (Object)new EventHandler());
        CommandSpec commandQTCreate = CommandSpec.builder().description((Text)Text.builder((String)"Create a question easily").color(TextColors.GREEN).build()).permission("questionstime.command.create").executor((CommandExecutor)new CommandCreateQuestion()).build();
        CommandSpec commandQTBase = CommandSpec.builder().description((Text)Text.builder((String)"The main QuestionsTime command").color(TextColors.YELLOW).build()).permission("questionstime.command.base").child((CommandCallable)commandQTCreate, new String[]{"create"}).build();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)commandQTBase, new String[]{"questionstime", "qt"});
    }

    @Listener
    public void onServerStart(GameStartedServerEvent e) {
        if (this.questions.size() > 0) {
            this.getConsole().sendMessage(TextUtils.Console.creatorComposed("Loaded ", "" + this.questions.size(), " question(s) !"));
            this.sayNewQuestion();
        } else {
            this.getConsole().sendMessage(TextUtils.Console.creatorError(" No questions were register. Do you add questions ?"));
        }
    }

    @Listener
    public void onServerStop(GameStoppedEvent e) {
    }

    @Listener
    public void onServerProviderChange(ChangeServiceProviderEvent e) {
        if (e.getService().equals(EconomyService.class)) {
            this.economy = (EconomyService)e.getNewProviderRegistration().getProvider();
        }
    }

    public void sayNewQuestion() {
        this.logger.debug("say a new question");
        if (this.questions.size() > 0) {
            if (ConfigHandler.isRandomTick()) {
                this.startIntervalQuestion();
            } else {
                this.startFixTimeQuestion();
            }
        }
    }

    private void startFixTimeQuestion() {
        Task.builder().execute((Runnable)new QuestionTask(this)).async().delayTicks((long)ConfigHandler.getCooldown()).name("[QT]FixTimeQuestion").submit((Object)this);
    }

    private void startIntervalQuestion() {
        Task.builder().execute(task -> Task.builder().execute((Runnable)new QuestionTask(this)).async().delayTicks((long)RandomUtils.nextInt((int)1, (int)(ConfigHandler.getMaxCooldown() - ConfigHandler.getMinCooldown()))).name("[QT]SecondIntervalQuestion").submit((Object)this)).async().delayTicks((long)ConfigHandler.getMinCooldown()).name("[QT]MainIntervalQuestion").submit((Object)this);
    }

    public Game getGame() {
        return this.game;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static QuestionsTime getInstance() {
        return instance;
    }

    public void addQuestion(Question question) {
        this.questions.add(question);
    }

    public ArrayList<Question> getQuestions() {
        return this.questions;
    }

    public Optional<Question> getCurrentQuestion() {
        return Optional.ofNullable(this.currentQuestion);
    }

    public void setPlayedQuestion(Question currentQuestion) {
        this.currentQuestion = currentQuestion;
    }

    public PluginContainer getContainer() {
        return this.container;
    }

    public Optional<EconomyService> getEconomy() {
        return Optional.ofNullable(this.economy);
    }

    public void addCreator(UUID uuid) {
        this.questionCreator.add(new QuestionCreator(uuid));
    }

    public void removeCreator(UUID uuid) {
        this.questionCreator.removeIf(qc -> qc.getCreator().equals(uuid));
    }

    public boolean isCreator(UUID uuid) {
        for (QuestionCreator qc : this.questionCreator) {
            if (!qc.getCreator().equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public Optional<QuestionCreator> getQuestionCreator(UUID uuid) {
        for (QuestionCreator qc : this.questionCreator) {
            if (!qc.getCreator().equals(uuid)) continue;
            return Optional.of(qc);
        }
        return Optional.empty();
    }

    public int getSpongeAPI() {
        char version = Sponge.getPlatform().getContainer(Platform.Component.API).getVersion().orElse("0").charAt(0);
        return StringUtils.isNumeric((CharSequence)String.valueOf(version)) ? CharUtils.toIntValue((char)version) : 0;
    }

    public ConsoleSource getConsole() {
        return Sponge.getGame().getServer().getConsole();
    }

    public void startTimer(Task task) {
        this.timedQuestionStarted = System.currentTimeMillis();
        this.taskTimer = task;
    }

    public long getTimerStarted() {
        return System.currentTimeMillis() - this.timedQuestionStarted;
    }

    public void stopTimer() {
        if (this.taskTimer != null) {
            this.taskTimer.cancel();
        }
        this.timedQuestionStarted = 0L;
    }
}

