/*
 * Decompiled with CFR 0.152.
 */
package fr.nocturne123.questionstime.message;

import fr.nocturne123.questionstime.QuestionsTime;
import fr.nocturne123.questionstime.handler.MessageHandler;
import fr.nocturne123.questionstime.message.component.MessageComponent;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextTemplate;

public class Message {
    private MessageHandler.Messages message;
    private Map<MessageComponent, Object> components;

    private Message(MessageBuilder builder) {
        this.components = builder.components;
        this.message = builder.message;
    }

    public Text getFormattedMessage() {
        TextTemplate textTemplate = MessageHandler.getTextTemplate(this.message);
        HashMap<String, Text> args = new HashMap<String, Text>();
        for (Map.Entry<MessageComponent, Object> entry : this.components.entrySet()) {
            MessageComponent component = entry.getKey();
            Text text = component.process(entry.getValue());
            args.put(component.getName(), text);
        }
        return Text.of((String)textTemplate.apply(args).build().toPlain());
    }

    public String getSection() {
        return this.message.getSection();
    }

    public int getComponentSize() {
        return this.components.size();
    }

    public static MessageBuilder builder(MessageHandler.Messages message) {
        return new MessageBuilder(message);
    }

    public static class MessageBuilder {
        private MessageHandler.Messages message;
        private Map<MessageComponent, Object> components = new HashMap<MessageComponent, Object>();

        public MessageBuilder(MessageHandler.Messages message) {
            this.message = message;
        }

        public <T> MessageBuilder setComponent(MessageComponent<T> component, T value) {
            if (value != null && component != null) {
                this.components.put(component, value);
            } else {
                QuestionsTime.getInstance().getLogger().warn("The component or his value is/are null or empty {component=" + component + ",value=" + value + "}");
            }
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }
}

