/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.enchantments;

import crafttweaker.api.data.DataList;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.DataShort;
import crafttweaker.api.data.IData;
import crafttweaker.api.enchantments.IEnchantment;
import crafttweaker.api.enchantments.IEnchantmentDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.enchantments.MCEnchantmentDefinition;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MCEnchantment
implements IEnchantment {
    private final Enchantment definition;
    private int level;

    public MCEnchantment(int id, int lvl) {
        this(Enchantment.func_185262_c((int)id), lvl);
    }

    public MCEnchantment(Enchantment enchantment, int level) {
        this.definition = enchantment;
        this.level = level;
    }

    @Override
    public IEnchantmentDefinition getDefinition() {
        return new MCEnchantmentDefinition(this.definition);
    }

    @Override
    public Map<String, IData> makeTagInternal() {
        HashMap<String, IData> map = new HashMap<String, IData>();
        map.put("id", new DataShort((short)this.getDefinition().getID()));
        map.put("lvl", new DataShort((short)this.level));
        return map;
    }

    @Override
    public IData makeTag() {
        return new DataMap(Collections.singletonMap("ench", new DataList(Collections.singletonList(new DataMap(this.makeTagInternal(), false)), false)), false);
    }

    @Override
    public IData makeBookTag() {
        return new DataMap(Collections.singletonMap("StoredEnchantments", new DataList(Collections.singletonList(new DataMap(this.makeTagInternal(), false)), false)), false);
    }

    @Override
    public IItemStack makeBook() {
        NBTTagCompound result = new NBTTagCompound();
        result.func_74782_a("StoredEnchantments", (NBTBase)new NBTTagList());
        result.func_150295_c("StoredEnchantments", 10).func_74742_a((NBTBase)this.makeNBTInternal());
        ItemStack book = new ItemStack(Items.field_151134_bR);
        book.func_77982_d(result);
        return new MCItemStack(book);
    }

    public NBTTagCompound makeNBTInternal() {
        NBTTagCompound enchant = new NBTTagCompound();
        enchant.func_74777_a("id", (short)this.getDefinition().getID());
        enchant.func_74777_a("lvl", (short)this.level);
        return enchant;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public String displayName() {
        return this.definition.func_77316_c(this.level);
    }
}

