/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.chestrefill;

import io.github.aquerr.chestrefill.PluginInfo;
import io.github.aquerr.chestrefill.commands.AssignKitCommand;
import io.github.aquerr.chestrefill.commands.CreateCommand;
import io.github.aquerr.chestrefill.commands.CreateKitCommand;
import io.github.aquerr.chestrefill.commands.HelpCommand;
import io.github.aquerr.chestrefill.commands.KitsCommand;
import io.github.aquerr.chestrefill.commands.ListCommand;
import io.github.aquerr.chestrefill.commands.RefillAllCommand;
import io.github.aquerr.chestrefill.commands.RefillCommand;
import io.github.aquerr.chestrefill.commands.RemoveCommand;
import io.github.aquerr.chestrefill.commands.RemoveKitCommand;
import io.github.aquerr.chestrefill.commands.SetnameCommand;
import io.github.aquerr.chestrefill.commands.TimeCommand;
import io.github.aquerr.chestrefill.commands.UpdateCommand;
import io.github.aquerr.chestrefill.commands.arguments.ContainerNameArgument;
import io.github.aquerr.chestrefill.commands.arguments.KitNameArgument;
import io.github.aquerr.chestrefill.entities.RefillableContainer;
import io.github.aquerr.chestrefill.entities.SelectionMode;
import io.github.aquerr.chestrefill.listeners.ContainerBreakListener;
import io.github.aquerr.chestrefill.listeners.PlayerJoinListener;
import io.github.aquerr.chestrefill.listeners.RightClickListener;
import io.github.aquerr.chestrefill.managers.ContainerManager;
import io.github.aquerr.chestrefill.scheduling.ContainerScheduler;
import io.github.aquerr.chestrefill.version.VersionChecker;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameLoadCompleteEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

@Plugin(id="chestrefill", name="Chest Refill", version="1.5.0", description="Plugin for restoring contents of a container after the specified time.", authors={"Aquerr"}, url="https://github.com/Aquerr/ChestRefill")
public class ChestRefill {
    public static final Map<List<String>, CommandSpec> SUBCOMMANDS = new HashMap<List<String>, CommandSpec>();
    public static final Map<UUID, SelectionMode> PLAYER_CHEST_SELECTION_MODE = new HashMap<UUID, SelectionMode>();
    public static final Map<UUID, String> PLAYER_CHEST_NAME = new HashMap<UUID, String>();
    public static final Map<UUID, Integer> CONTAINER_TIME_CHANGE_PLAYER = new HashMap<UUID, Integer>();
    public static final Map<UUID, RefillableContainer> PLAYER_COPY_REFILLABLE_CONTAINER = new HashMap<UUID, RefillableContainer>();
    public static final Map<UUID, String> PLAYER_KIT_NAME = new HashMap<UUID, String>();
    public static final Map<UUID, String> PLAYER_KIT_ASSIGN = new HashMap<UUID, String>();
    private ContainerScheduler containerScheduler;
    private ContainerManager containerManager;
    private static ChestRefill chestRefill;
    @Inject
    private Logger _logger;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path _configDir;

    public static ChestRefill getInstance() {
        if (chestRefill != null) {
            return chestRefill;
        }
        return new ChestRefill();
    }

    public Logger getLogger() {
        return this._logger;
    }

    public Path getConfigDir() {
        return this._configDir;
    }

    @Listener
    public void onGameInitialization(GameInitializationEvent event) {
        chestRefill = this;
        this.containerManager = new ContainerManager(this, this.getConfigDir());
        this.containerScheduler = new ContainerScheduler(this);
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.YELLOW, "Chest Refill is loading... :D"}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.YELLOW, "Initializing commands..."}));
        this.initCommands();
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.YELLOW, "Initializing listeners..."}));
        this.initListeners();
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.YELLOW, "Chest Refill is ready!"}));
        CompletableFuture.runAsync(() -> {
            if (VersionChecker.isLatest("1.5.0")) {
                Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.GREEN, "You are using the latest version!"}));
            } else {
                Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.RED, "An update for ", TextColors.YELLOW, "Chest Refill", TextColors.RED, " is available online!"}));
            }
        });
    }

    @Listener
    public void onGameLoad(GameLoadCompleteEvent event) {
        this.containerManager.restoreRefilling();
        this.containerManager.startLookingForEmptyContainers();
    }

    public ContainerManager getContainerManager() {
        return this.containerManager;
    }

    public ContainerScheduler getContainerScheduler() {
        return this.containerScheduler;
    }

    public ConsoleSource getConsole() {
        return Sponge.getServer().getConsole();
    }

    private void initCommands() {
        SUBCOMMANDS.put(Arrays.asList("help"), CommandSpec.builder().description((Text)Text.of((String)"Displays all available commands")).permission("chestrefill.command.help").executor((CommandExecutor)new HelpCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("c", "create"), CommandSpec.builder().description((Text)Text.of((String)"Toggles chest creation mode")).permission("chestrefill.command.create").arguments(GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"chest name")))).executor((CommandExecutor)new CreateCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("r", "remove"), CommandSpec.builder().description((Text)Text.of((String)"Toggles chest removal mode")).permission("chestrefill.command.remove").executor((CommandExecutor)new RemoveCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("u", "update"), CommandSpec.builder().description((Text)Text.of((String)"Toggles chest update mode")).permission("chestrefill.command.update").executor((CommandExecutor)new UpdateCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("t", "time"), CommandSpec.builder().description((Text)Text.of((String)"Change chest's refill time")).permission("chestrefill.command.time").arguments(GenericArguments.optional((CommandElement)GenericArguments.integer((Text)Text.of((String)"time")))).executor((CommandExecutor)new TimeCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("l", "list"), CommandSpec.builder().description((Text)Text.of((String)"Show all refilling chests")).permission("chestrefill.command.list").executor((CommandExecutor)new ListCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("refill"), CommandSpec.builder().description((Text)Text.of((String)"Force refill a specific container")).permission("chestrefill.command.refill").arguments((CommandElement)new ContainerNameArgument((Text)Text.of((String)"chest name"))).executor((CommandExecutor)new RefillCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("refillall"), CommandSpec.builder().description((Text)Text.of((String)"Force refill all containers")).permission("chestrefill.command.refillall").executor((CommandExecutor)new RefillAllCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("setname"), CommandSpec.builder().description((Text)Text.of((String)"Set name for a refillable container")).permission("chestrefill.command.setname").arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)"name")))).executor((CommandExecutor)new SetnameCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("createkit"), CommandSpec.builder().description((Text)Text.of((String)"Toggles kit creation mode")).permission("chestrefill.command.kit.create").arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)"kit name")))).executor((CommandExecutor)new CreateKitCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("removekit"), CommandSpec.builder().description((Text)Text.of((String)"Removes a kit")).permission("chestrefill.command.kit.remove").arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)"kit name")))).executor((CommandExecutor)new RemoveKitCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("assignkit"), CommandSpec.builder().description((Text)Text.of((String)"Toggles assign mode")).permission("chestrefill.command.kit.assign").arguments(GenericArguments.onlyOne((CommandElement)new KitNameArgument((Text)Text.of((String)"kit name")))).executor((CommandExecutor)new AssignKitCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("kits"), CommandSpec.builder().description((Text)Text.of((String)"Shows available kits")).permission("chestrefill.command.kit.kits").executor((CommandExecutor)new KitsCommand(this)).build());
        CommandSpec mainCommand = CommandSpec.builder().description((Text)Text.of((String)"Displays all available commands")).executor((CommandExecutor)new HelpCommand(this)).children(SUBCOMMANDS).build();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)mainCommand, new String[]{"chestrefill", "cr"});
    }

    private void initListeners() {
        Sponge.getEventManager().registerListeners((Object)this, (Object)new RightClickListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new ContainerBreakListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerJoinListener(this));
    }
}

