/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.chestrefill.commands;

import com.google.common.collect.Lists;
import io.github.aquerr.chestrefill.ChestRefill;
import io.github.aquerr.chestrefill.commands.AbstractCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class HelpCommand
extends AbstractCommand
implements CommandExecutor {
    public HelpCommand(ChestRefill plugin) {
        super(plugin);
    }

    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Map<List<String>, CommandSpec> commands = ChestRefill.SUBCOMMANDS;
        ArrayList helpList = Lists.newArrayList();
        for (List<String> aliases : commands.keySet()) {
            CommandSpec commandSpec = commands.get(aliases);
            Text commandHelp = Text.builder().append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, "/cr " + aliases.toString().replace("[", "").replace("]", "")})}).build()}).append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.WHITE, " - " + ((Text)commandSpec.getShortDescription(source).get()).toPlain() + "\n"})}).build()}).append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GRAY, "Usage: /cr " + aliases.toString().replace("[", "").replace("]", "") + " " + commandSpec.getUsage(source).toPlain()})}).build()}).build();
            helpList.add(commandHelp);
        }
        helpList.sort(Text::compareTo);
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        PaginationList.Builder paginationBuilder = paginationService.builder().title(Text.of((Object[])new Object[]{TextColors.GOLD, "Chest Refill v1.5.0"})).padding(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "-"})).contents((Iterable)helpList).linesPerPage(14);
        paginationBuilder.sendTo((MessageReceiver)source);
        return CommandResult.success();
    }
}

