/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.chestrefill.commands;

import io.github.aquerr.chestrefill.ChestRefill;
import io.github.aquerr.chestrefill.PluginInfo;
import io.github.aquerr.chestrefill.commands.AbstractCommand;
import io.github.aquerr.chestrefill.entities.RefillableContainer;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class RefillCommand
extends AbstractCommand
implements CommandExecutor {
    public RefillCommand(ChestRefill plugin) {
        super(plugin);
    }

    public CommandResult execute(CommandSource source, CommandContext args) throws CommandException {
        Optional optionalChestName = args.getOne((Text)Text.of((String)"chest name"));
        if (optionalChestName.isPresent()) {
            String chestName = (String)optionalChestName.get();
            Collection<RefillableContainer> containerList = super.getPlugin().getContainerManager().getRefillableContainers();
            for (RefillableContainer refillableContainer : containerList) {
                if (refillableContainer.getName() == null || !refillableContainer.getName().equals(chestName)) continue;
                boolean didSucceed = super.getPlugin().getContainerManager().refillContainer(refillableContainer.getContainerLocation());
                if (didSucceed) {
                    source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.YELLOW, "Successfully refilled the container!"}));
                    break;
                }
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.RED, "Could not refill the container!"}));
                break;
            }
        }
        return CommandResult.success();
    }
}

