/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.chestrefill.listeners;

import io.github.aquerr.chestrefill.ChestRefill;
import io.github.aquerr.chestrefill.entities.ContainerLocation;
import io.github.aquerr.chestrefill.entities.RefillableContainer;
import io.github.aquerr.chestrefill.listeners.AbstractListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.world.Location;

public class ContainerBreakListener
extends AbstractListener {
    private final List<RefillableContainer> destroyedContainers = new ArrayList<RefillableContainer>();

    public ContainerBreakListener(ChestRefill plugin) {
        super(plugin);
    }

    @Listener
    public void onRefillableEntityBreak(ChangeBlockEvent.Break event) {
        block0: for (Transaction transaction : event.getTransactions()) {
            if (!((BlockSnapshot)transaction.getOriginal()).getLocation().isPresent()) continue;
            ContainerLocation containerLocation = new ContainerLocation(((BlockSnapshot)transaction.getOriginal()).getPosition(), ((BlockSnapshot)transaction.getOriginal()).getWorldUniqueId());
            for (RefillableContainer refillableContainer : super.getPlugin().getContainerManager().getRefillableContainers()) {
                if (!refillableContainer.getContainerLocation().equals(containerLocation)) continue;
                this.destroyedContainers.add(refillableContainer);
                super.getPlugin().getContainerManager().removeRefillableContainer(containerLocation);
                continue block0;
            }
        }
    }

    @Listener
    public void onItemDrop(DropItemEvent event) {
        Optional blockSnapshot = event.getCause().first(BlockSnapshot.class);
        if (blockSnapshot.isPresent() && ((BlockSnapshot)blockSnapshot.get()).getLocation().isPresent()) {
            ContainerLocation containerLocation = new ContainerLocation(((Location)((BlockSnapshot)blockSnapshot.get()).getLocation().get()).getBlockPosition(), ((BlockSnapshot)blockSnapshot.get()).getWorldUniqueId());
            for (RefillableContainer refillableContainer : this.destroyedContainers) {
                if (!refillableContainer.getContainerLocation().equals(containerLocation) || !refillableContainer.getHidingBlock().equals(((BlockSnapshot)blockSnapshot.get()).getState().getType())) continue;
                event.setCancelled(true);
                this.destroyedContainers.clear();
            }
        }
    }
}

