/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.chestrefill.scheduling;

import io.github.aquerr.chestrefill.entities.RefillableContainer;
import io.github.aquerr.chestrefill.managers.ContainerManager;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.carrier.TileEntityCarrier;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;

public class ScanForEmptyContainersTask
implements Runnable {
    private final ContainerManager containerManager;

    public ScanForEmptyContainersTask(ContainerManager containerManager) {
        this.containerManager = containerManager;
    }

    @Override
    public void run() {
        for (RefillableContainer refillableContainer : this.containerManager.getRefillableContainers()) {
            TileEntityCarrier container;
            Location location;
            Optional world = Sponge.getServer().getWorld(refillableContainer.getContainerLocation().getWorldUUID());
            if (!world.isPresent() || !(location = new Location((Extent)world.get(), refillableContainer.getContainerLocation().getBlockPosition())).getTileEntity().isPresent() && refillableContainer.shouldBeHiddenIfNoItems() || !location.getTileEntity().isPresent() || (container = (TileEntityCarrier)location.getTileEntity().get()).getInventory().totalItems() != 0 || !refillableContainer.shouldBeHiddenIfNoItems()) continue;
            location.setBlockType(refillableContainer.getHidingBlock());
        }
    }
}

