/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.chestrefill.storage;

import io.github.aquerr.chestrefill.caching.ContainerCache;
import io.github.aquerr.chestrefill.entities.ContainerLocation;
import io.github.aquerr.chestrefill.entities.Kit;
import io.github.aquerr.chestrefill.entities.RefillableContainer;
import io.github.aquerr.chestrefill.storage.JSONStorage;
import io.github.aquerr.chestrefill.storage.Storage;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class StorageHelper {
    private final Queue<RefillableContainer> containersToSave = new LinkedList<RefillableContainer>();
    private final Storage containerStorage;

    public StorageHelper(Path configDir) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(this.startContainerSavingThread());
        this.containerStorage = new JSONStorage(configDir);
        ContainerCache.loadCache(this.containerStorage.getRefillableContainers(), this.containerStorage.getKits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrUpdateContainer(RefillableContainer containerToSave) {
        boolean didSucceed = ContainerCache.addOrUpdateContainerCache(containerToSave);
        Queue<RefillableContainer> queue = this.containersToSave;
        synchronized (queue) {
            this.containersToSave.add(containerToSave);
            this.containersToSave.notify();
        }
        return didSucceed;
    }

    public boolean removeContainer(ContainerLocation containerLocation) {
        CompletableFuture.runAsync(() -> this.containerStorage.removeRefillableContainer(containerLocation));
        return ContainerCache.removeContainer(containerLocation);
    }

    public Collection<RefillableContainer> getRefillableContainers() {
        return ContainerCache.getContainersCache().values();
    }

    public Set<ContainerLocation> getContainerLocations() {
        return ContainerCache.getContainersCache().keySet();
    }

    public RefillableContainer getRefillableContainer(ContainerLocation containerLocation) {
        return ContainerCache.getContainersCache().get(containerLocation);
    }

    public boolean updateContainerTime(ContainerLocation containerLocation, int time) {
        CompletableFuture.runAsync(() -> this.containerStorage.updateContainerTime(containerLocation, time));
        return ContainerCache.updateContainerTime(containerLocation, time);
    }

    public boolean changeContainerName(ContainerLocation containerLocation, String containerName) {
        CompletableFuture.runAsync(() -> this.containerStorage.changeContainerName(containerLocation, containerName));
        return ContainerCache.updateContainerName(containerLocation, containerName);
    }

    public Map<String, Kit> getKits() {
        return ContainerCache.getKitsCache();
    }

    public boolean createKit(Kit kit) {
        CompletableFuture.runAsync(() -> this.containerStorage.createKit(kit));
        return ContainerCache.addOrUpdateKitCache(kit);
    }

    public boolean removeKit(String kitName) {
        CompletableFuture.runAsync(() -> this.containerStorage.removeKit(kitName));
        return ContainerCache.removeKit(kitName);
    }

    public boolean assignKit(ContainerLocation containerLocation, String kitName) {
        CompletableFuture.runAsync(() -> this.containerStorage.assignKit(containerLocation, kitName));
        return ContainerCache.assignKit(containerLocation, kitName);
    }

    private Runnable startContainerSavingThread() {
        return () -> {
            while (true) {
                Queue<RefillableContainer> queue = this.containersToSave;
                synchronized (queue) {
                    if (this.containersToSave.size() > 0) {
                        this.containerStorage.addOrUpdateContainer(this.containersToSave.poll());
                    } else {
                        try {
                            this.containersToSave.wait();
                        }
                        catch (InterruptedException exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
        };
    }
}

