/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjw.utils.Gamemode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandCreate
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world create").get();
    public static List<String> worlds = new ArrayList<String>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        WorldProperties properties;
        String worldName;
        if (arguments.equalsIgnoreCase("create")) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        String[] args = arguments.split(" ");
        if (args[args.length - 1].equalsIgnoreCase("--help")) {
            this.help.execute(source);
            return CommandResult.success();
        }
        try {
            worldName = args[0];
        }
        catch (Exception e) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        if (Sponge.getServer().getWorldProperties(worldName).isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, worldName, " already exists"}), false);
        }
        WorldArchetype.Builder builder = WorldArchetype.builder();
        ArrayList modifiers = new ArrayList();
        if (args.length > 2) {
            boolean skip = false;
            for (int i = 1; i < args.length - 1; ++i) {
                String value;
                if (skip) {
                    skip = false;
                    continue;
                }
                String arg = args[i];
                try {
                    value = args[i + 1];
                }
                catch (Exception e) {
                    throw new CommandException(this.getHelp().getUsageText());
                }
                if (arg.equalsIgnoreCase("-d") || arg.equalsIgnoreCase("-dimension")) {
                    Optional optionalDimension = Sponge.getRegistry().getType(DimensionType.class, value);
                    if (!optionalDimension.isPresent()) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid DimensionType"}));
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                    builder.dimension((DimensionType)optionalDimension.get());
                } else if (arg.equalsIgnoreCase("-g") || arg.equalsIgnoreCase("-generator")) {
                    String[] split = value.split(",");
                    Optional optionalGenerator = Sponge.getRegistry().getType(GeneratorType.class, split[0]);
                    if (!optionalGenerator.isPresent()) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid GeneratorType"}));
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                    builder.generator((GeneratorType)optionalGenerator.get());
                    if (split.length == 2) {
                        builder.generatorSettings(DataContainer.createNew().set(DataQuery.of((String[])new String[]{"customSettings"}), (Object)split[1]));
                    }
                } else if (arg.equalsIgnoreCase("-gm") || arg.equalsIgnoreCase("-gamemode")) {
                    Optional<Object> optionalGamemode = Optional.empty();
                    try {
                        optionalGamemode = Gamemode.get(Integer.parseInt(value));
                    }
                    catch (Exception e) {
                        optionalGamemode = Gamemode.get(value);
                    }
                    if (!optionalGamemode.isPresent()) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid GameMode"}));
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                    builder.gameMode((GameMode)optionalGamemode.get());
                } else if (arg.equalsIgnoreCase("-m") || arg.equalsIgnoreCase("-modifier")) {
                    Optional optionalModifier = Sponge.getRegistry().getType(WorldGeneratorModifier.class, value);
                    if (!optionalModifier.isPresent()) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid WorldGeneratorModifier"}));
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                    modifiers.add(optionalModifier.get());
                } else if (arg.equalsIgnoreCase("-s") || arg.equalsIgnoreCase("-seed")) {
                    try {
                        Long s = Long.parseLong(value);
                        builder.seed(s.longValue());
                    }
                    catch (Exception e) {
                        builder.seed((long)value.hashCode());
                    }
                } else if (arg.equalsIgnoreCase("-df") || arg.equalsIgnoreCase("-difficulty")) {
                    Optional optionalDifficulty = Sponge.getRegistry().getType(Difficulty.class, value);
                    if (!optionalDifficulty.isPresent()) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid Difficulty"}));
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                    builder.difficulty((Difficulty)optionalDifficulty.get());
                } else if (arg.equalsIgnoreCase("-l") || arg.equalsIgnoreCase("-loadonstartup")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid Boolean"}));
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                    builder.loadsOnStartup(Boolean.valueOf(value).booleanValue());
                } else if (arg.equalsIgnoreCase("-k") || arg.equalsIgnoreCase("-keepspawnloaded")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid Boolean"}));
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                    builder.keepsSpawnLoaded(Boolean.valueOf(value).booleanValue());
                } else if (arg.equalsIgnoreCase("-c") || arg.equalsIgnoreCase("-allowcommands")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid Boolean"}));
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                    builder.commandsAllowed(Boolean.valueOf(value).booleanValue());
                } else if (arg.equalsIgnoreCase("-b") || arg.equalsIgnoreCase("-bonuschest")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid Boolean"}));
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                    builder.generateBonusChest(Boolean.valueOf(value).booleanValue());
                } else {
                    if (!arg.equalsIgnoreCase("-f") && !arg.equalsIgnoreCase("-mapfeatures")) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid Flag"}));
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid Boolean"}));
                        throw new CommandException(this.getHelp().getUsageText());
                    }
                    builder.usesMapFeatures(Boolean.valueOf(value).booleanValue());
                }
                skip = true;
            }
        }
        WorldArchetype settings = builder.enabled(true).keepsSpawnLoaded(true).loadsOnStartup(true).build(worldName, worldName);
        try {
            properties = Sponge.getServer().createWorldProperties(worldName, settings);
            properties.setGeneratorModifiers(modifiers);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Something went wrong. Check server log for details"}), false);
        }
        Sponge.getServer().saveWorldProperties(properties);
        worlds.add(worldName);
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, worldName, " created successfully"}));
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("create")) {
            return list;
        }
        String[] args = arguments.split(" ");
        if (args.length <= 1) {
            return list;
        }
        String arg = args[args.length - 1];
        if (arg.equalsIgnoreCase("-d") || arg.equalsIgnoreCase("-dimension")) {
            for (DimensionType type : Sponge.getRegistry().getAllOf(DimensionType.class)) {
                list.add(type.getId());
            }
        } else if (arg.equalsIgnoreCase("-g") || arg.equalsIgnoreCase("-generator")) {
            for (GeneratorType type : Sponge.getRegistry().getAllOf(GeneratorType.class)) {
                list.add(type.getId());
            }
        } else if (arg.equalsIgnoreCase("-gm") || arg.equalsIgnoreCase("-gamemode")) {
            for (Gamemode type : Gamemode.values()) {
                list.add(Integer.toString(type.getIndex()));
                list.add(type.getGameMode().getName());
            }
        } else if (arg.equalsIgnoreCase("-m") || arg.equalsIgnoreCase("-modifier")) {
            for (WorldGeneratorModifier type : Sponge.getRegistry().getAllOf(WorldGeneratorModifier.class)) {
                list.add(type.getId());
            }
        } else if (arg.equalsIgnoreCase("-df") || arg.equalsIgnoreCase("-difficulty")) {
            for (Difficulty type : Sponge.getRegistry().getAllOf(Difficulty.class)) {
                list.add(type.getId());
            }
        } else if (arg.equalsIgnoreCase("-l") || arg.equalsIgnoreCase("-loadonstartup") || arg.equalsIgnoreCase("-k") || arg.equalsIgnoreCase("-keepspawnloaded") || arg.equalsIgnoreCase("-c") || arg.equalsIgnoreCase("-allowcommands") || arg.equalsIgnoreCase("-b") || arg.equalsIgnoreCase("-bonuschest") || arg.equalsIgnoreCase("-f") || arg.equalsIgnoreCase("-mapfeatures")) {
            list.add("true");
            list.add("false");
        } else {
            String parent = args[args.length - 2];
            if (parent.equalsIgnoreCase("-d") || parent.equalsIgnoreCase("-dimension")) {
                for (DimensionType type : Sponge.getRegistry().getAllOf(DimensionType.class)) {
                    if (!type.getId().toLowerCase().startsWith(arg.toLowerCase())) continue;
                    list.add(type.getId());
                }
            } else if (parent.equalsIgnoreCase("-g") || parent.equalsIgnoreCase("-generator")) {
                for (GeneratorType type : Sponge.getRegistry().getAllOf(GeneratorType.class)) {
                    if (!type.getId().toLowerCase().startsWith(arg.toLowerCase())) continue;
                    list.add(type.getId());
                }
            } else if (parent.equalsIgnoreCase("-gm") || parent.equalsIgnoreCase("-gamemode")) {
                for (Gamemode type : Gamemode.values()) {
                    if (!type.getGameMode().getName().toLowerCase().startsWith(arg.toLowerCase())) continue;
                    list.add(type.getGameMode().getName());
                }
            } else if (parent.equalsIgnoreCase("-m") || parent.equalsIgnoreCase("-modifier")) {
                for (WorldGeneratorModifier type : Sponge.getRegistry().getAllOf(WorldGeneratorModifier.class)) {
                    if (!type.getId().toLowerCase().startsWith(arg.toLowerCase())) continue;
                    list.add(type.getId());
                }
            } else if (parent.equalsIgnoreCase("-df") || parent.equalsIgnoreCase("-difficulty")) {
                for (Difficulty type : Sponge.getRegistry().getAllOf(Difficulty.class)) {
                    if (!type.getId().toLowerCase().startsWith(arg.toLowerCase())) continue;
                    list.add(type.getId());
                }
            } else if (arg.equalsIgnoreCase("-l") || arg.equalsIgnoreCase("-loadonstartup") || arg.equalsIgnoreCase("-k") || arg.equalsIgnoreCase("-keepspawnloaded") || arg.equalsIgnoreCase("-c") || arg.equalsIgnoreCase("-allowcommands") || arg.equalsIgnoreCase("-b") || arg.equalsIgnoreCase("-bonuschest") || arg.equalsIgnoreCase("-f") || arg.equalsIgnoreCase("-mapfeatures")) {
                if ("true".startsWith(arg.toLowerCase())) {
                    list.add("true");
                }
                if ("false".startsWith(arg.toLowerCase())) {
                    list.add("false");
                }
            }
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

