/*
 * Decompiled with CFR 0.152.
 */
package net.obnoxint.xnbt.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.obnoxint.xnbt.BaseTag;
import net.obnoxint.xnbt.types.NBTTag;
import net.obnoxint.xnbt.types.TagHeader;

public abstract class AbstractCompoundTag
extends BaseTag
implements Map<String, NBTTag> {
    private static Map<String, NBTTag> sanitizePayload(Map<String, NBTTag> payload) {
        if (payload == null) {
            return new HashMap<String, NBTTag>();
        }
        if (payload.containsKey(null) || payload.containsValue(null)) {
            throw new NullPointerException("payload must not contain null keys or values");
        }
        return new HashMap<String, NBTTag>(payload);
    }

    protected AbstractCompoundTag(String name, Map<String, NBTTag> payload) {
        super(new TagHeader(NBTTag.BaseType.COMPOUND.Id(), name), AbstractCompoundTag.sanitizePayload(payload));
    }

    @Override
    public void clear() {
        this.getPayload().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getPayload().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getPayload().containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, NBTTag>> entrySet() {
        return this.getPayload().entrySet();
    }

    @Override
    public NBTTag get(Object key) {
        return (NBTTag)this.getPayload().get(key);
    }

    @Override
    public Map<String, NBTTag> getPayload() {
        return (Map)super.getPayload();
    }

    @Override
    public boolean isEmpty() {
        return this.getPayload().isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.getPayload().keySet();
    }

    public abstract NBTTag put(NBTTag var1);

    @Override
    public final NBTTag put(String key, NBTTag value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public abstract void putAll(Collection<? extends NBTTag> var1);

    @Override
    public void putAll(Map<? extends String, ? extends NBTTag> m) {
        this.putAll(m.values());
    }

    @Override
    public NBTTag remove(Object key) {
        return (NBTTag)this.getPayload().remove(key);
    }

    public void setPayload(Map<String, NBTTag> payload) {
        super.setPayload(AbstractCompoundTag.sanitizePayload(payload));
    }

    @Override
    public int size() {
        return this.getPayload().size();
    }

    @Override
    public Collection<NBTTag> values() {
        return this.getPayload().values();
    }
}

