/*
 * Decompiled with CFR 0.152.
 */
package net.obnoxint.xnbt.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.obnoxint.xnbt.types.AbstractListTag;
import net.obnoxint.xnbt.types.NBTTag;

public class ListTag
extends AbstractListTag {
    public ListTag(String name) {
        this(name, null);
    }

    public ListTag(String name, List<NBTTag> payload) {
        super(name, payload);
    }

    @Override
    public boolean add(NBTTag e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (e.equals(ENDTAG)) {
            throw new IllegalArgumentException("ListTag may not contain EndTags");
        }
        if (!this.isEmpty() && e.getHeader().getType() != this.getContentType()) {
            throw new IllegalArgumentException("NBTTag of type " + e.getHeader().getType() + " can't be added to ListTag because it already contains one or more elements of type " + ((NBTTag)this.getPayload().get(0)).getHeader().getType());
        }
        return super.getPayload().add(e);
    }

    @Override
    public boolean addAll(Collection<? extends NBTTag> c) {
        boolean r = false;
        for (NBTTag nBTTag : c) {
            if (!this.add(nBTTag)) continue;
            r = true;
        }
        return r;
    }

    public byte getContentType() {
        return this.isEmpty() ? (byte)0 : ((NBTTag)this.getPayload().get(0)).getHeader().getType();
    }

    @Override
    public List<NBTTag> getPayload() {
        return Collections.unmodifiableList(super.getPayload());
    }
}

