/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import pw.aaron1011.rentableregions.data.LocationData;
import pw.aaron1011.rentableregions.data.RentedRegion;

@ConfigSerializable
public class RegionsData {
    @Setting(value="signs")
    private Map<String, RentedRegion> regionSigns = new HashMap<String, RentedRegion>();
    private Map<LocationData, RentedRegion> regionsCache = new HashMap<LocationData, RentedRegion>();

    public void rebuildCache() {
        this.regionsCache.clear();
        for (Map.Entry<String, RentedRegion> entry : this.regionSigns.entrySet()) {
            for (LocationData locationData : entry.getValue().signs) {
                this.regionsCache.put(locationData, entry.getValue());
            }
        }
    }

    public void removeFromCache(LocationData locationData) {
        this.regionsCache.remove(locationData);
    }

    public List<RentedRegion> getAllRegions() {
        return ImmutableList.copyOf(this.regionSigns.values());
    }

    public Optional<RentedRegion> getRegion(String name) {
        return Optional.ofNullable(this.regionSigns.get(name));
    }

    public Optional<RentedRegion> getForLocation(Location<World> location) {
        return Optional.ofNullable(this.regionsCache.get(new LocationData(location)));
    }

    public void addRegion(RentedRegion rentedRegion) {
        this.regionSigns.put(rentedRegion.name, rentedRegion);
        for (LocationData locationData : rentedRegion.signs) {
            this.regionsCache.put(locationData, rentedRegion);
        }
    }

    public RentedRegion addDuplicateSign(String regionName, LocationData locationData) {
        RentedRegion data = this.regionSigns.get(regionName);
        if (data == null) {
            throw new IllegalStateException("Region " + regionName + " is not registered as a rentable region!");
        }
        data.signs.add(locationData);
        this.regionsCache.put(locationData, data);
        return data;
    }
}

