/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionRole;
import com.universeguard.utils.RegionUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameLoadCompleteEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import pw.aaron1011.rentableregions.ConfigFileManager;
import pw.aaron1011.rentableregions.RegionsData;
import pw.aaron1011.rentableregions.RentableRegionsConfig;
import pw.aaron1011.rentableregions.SignListeners;
import pw.aaron1011.rentableregions.command.AdminCommand;
import pw.aaron1011.rentableregions.command.RentableRegionsCommand;
import pw.aaron1011.rentableregions.data.DataStorageManager;
import pw.aaron1011.rentableregions.data.LocationData;
import pw.aaron1011.rentableregions.data.PlayerData;
import pw.aaron1011.rentableregions.data.RentedRegion;
import pw.aaron1011.rentableregions.serializers.BigDecimalSerializer;
import pw.aaron1011.rentableregions.serializers.DurationSerializer;
import pw.aaron1011.rentableregions.serializers.InstantSerializer;

@Plugin(id="rentableregions", name="RentableRegions", description="Allows renting UniverseGuard2 regions", dependencies={@Dependency(id="universeguard", version="2.17")}, authors={"Aaron1011"})
public class RentableRegions {
    public static RentableRegions INSTANCE;
    @Inject
    public Logger logger;
    @Inject
    @DefaultConfig(sharedRoot=false)
    public ConfigurationLoader<CommentedConfigurationNode> configLoader;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configDir;
    public ConfigurationLoader<CommentedConfigurationNode> regionDataLoader;
    private ConfigFileManager<RentableRegionsConfig> configManager;
    private ConfigFileManager<RegionsData> regionDataManager;
    private DataStorageManager<PlayerData> playerDataManager;
    public HashMap<UUID, Consumer<Player>> confirmCallbacks = new HashMap();
    private Map<Character, ChronoUnit> timeCodes = ImmutableMap.builder().put((Object)Character.valueOf('d'), (Object)ChronoUnit.DAYS).put((Object)Character.valueOf('h'), (Object)ChronoUnit.HOURS).put((Object)Character.valueOf('m'), (Object)ChronoUnit.MINUTES).put((Object)Character.valueOf('s'), (Object)ChronoUnit.SECONDS).build();

    public static RentableRegionsConfig getConfig() {
        return RentableRegions.INSTANCE.configManager.getPluginConfig();
    }

    public static RegionsData getRegionsData() {
        return RentableRegions.INSTANCE.regionDataManager.getPluginConfig();
    }

    public static void addRentedRegion(String name, RentedRegion rentedRegion) {
        RentableRegions.getRegionsData().addRegion(rentedRegion);
        INSTANCE.saveRegionsData();
    }

    public static void addDuplicateSign(String regionName, LocationData locationData) {
        RentedRegion region = RentableRegions.getRegionsData().addDuplicateSign(regionName, locationData);
        INSTANCE.saveRegionsData();
        INSTANCE.refreshSigns(region);
    }

    public static void onConfigReloaded() {
        RentableRegions.getRegionsData().rebuildCache();
    }

    public static PlayerData getPlayerData(UUID owner) {
        return RentableRegions.INSTANCE.playerDataManager.getData(owner);
    }

    public static void savePlayerData(UUID owner) {
        RentableRegions.INSTANCE.playerDataManager.saveData(owner);
    }

    public static void onConfirm(Player player, Consumer<Player> runnable) {
        RentableRegions.INSTANCE.confirmCallbacks.put(player.getUniqueId(), runnable);
    }

    public void refreshSigns(RentedRegion region) {
        LiteralText fourthLine;
        LiteralText thirdLine;
        if (region.isRented()) {
            thirdLine = Text.of((String)"Time:");
            fourthLine = Text.of((String)RentableRegions.formatTime(region.getRemainingTime()));
        } else {
            thirdLine = Text.of((String)RentableRegions.formatTime(region.getRemainingTime()));
            fourthLine = Text.of((String)("$" + region.price));
        }
        for (LocationData location : region.signs) {
            Optional teOpt = location.getLocation().getTileEntity();
            if (!teOpt.isPresent()) {
                this.logger.error(String.format("Expected sign at location %s, but found %s", location.getLocation(), location.getLocation().getBlock()));
                continue;
            }
            TileEntity te = (TileEntity)teOpt.get();
            Optional lines = te.get(Keys.SIGN_LINES);
            if (!lines.isPresent()) {
                this.logger.error(String.format(String.format("Expected sign (with lines) at location %s, but found %s", location.getLocation(), te), new Object[0]));
                continue;
            }
            ((List)lines.get()).set(2, thirdLine);
            ((List)lines.get()).set(3, fourthLine);
            te.offer(Keys.SIGN_LINES, lines.get());
        }
    }

    public static List<RentedRegion> getRegionsFor(UUID owner) {
        return RentableRegions.getPlayerData((UUID)owner).rentedRegions.stream().flatMap(name -> {
            Optional<RentedRegion> region = RentableRegions.getRegionsData().getRegion((String)name);
            if (!region.isPresent()) {
                RentableRegions.INSTANCE.logger.error("Player " + owner + " is renting unknown region " + name);
                return Stream.empty();
            }
            return Stream.of(region.get());
        }).collect(Collectors.toList());
    }

    public static String formatTime(Duration duration) {
        StringBuilder output = new StringBuilder();
        for (Map.Entry<Character, ChronoUnit> entry : RentableRegions.INSTANCE.timeCodes.entrySet()) {
            long val = duration.getSeconds() / entry.getValue().getDuration().getSeconds();
            if (val != 0L) {
                output.append(String.valueOf(val) + entry.getKey());
            }
            duration = duration.minus(entry.getValue().getDuration().multipliedBy(val));
        }
        if (output.toString().isEmpty()) {
            return "0s";
        }
        return output.toString();
    }

    public static Duration parseTime(String time) {
        Duration duration = Duration.ofSeconds(0L);
        int prevNum = 0;
        for (int i = 0; i < time.length(); ++i) {
            char c = time.charAt(i);
            if (!Character.isAlphabetic(c)) continue;
            String num = time.substring(prevNum, i);
            Integer val = Integer.valueOf(num);
            ChronoUnit unit = RentableRegions.INSTANCE.timeCodes.get(Character.valueOf(c));
            if (unit == null) {
                throw new IllegalArgumentException("Unknown time unit: " + c);
            }
            duration = duration.plus(Duration.of(val.intValue(), unit));
            prevNum = i + 1;
        }
        return duration;
    }

    public void saveRegionsData() {
        this.regionDataManager.save();
    }

    @Listener
    public void onPreInit(GamePreInitializationEvent event) {
        INSTANCE = this;
        ConfigurationOptions configOptions = ConfigurationOptions.defaults();
        configOptions = configOptions.setSerializers(configOptions.getSerializers().newChild().registerType(TypeToken.of(Duration.class), (TypeSerializer)new DurationSerializer()).registerType(TypeToken.of(BigDecimal.class), (TypeSerializer)new BigDecimalSerializer()).registerType(TypeToken.of(Instant.class), (TypeSerializer)new InstantSerializer()));
        this.configManager = new ConfigFileManager<RentableRegionsConfig>(this.configLoader, configOptions, RentableRegionsConfig.class);
        this.configManager.reload(false);
        this.regionDataLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.configDir.resolve("regions.conf"))).build();
        this.regionDataManager = new ConfigFileManager<RegionsData>(this.regionDataLoader, configOptions, RegionsData.class);
        this.regionDataManager.reload(false);
        this.playerDataManager = new DataStorageManager<PlayerData>("player_data", PlayerData.class, configOptions);
        this.logger.info("Hello from RentableRegions!");
        Task.builder().interval(RentableRegions.getConfig().refreshRate, TimeUnit.SECONDS).execute(this::refreshAllSigns).submit((Object)this);
        RentableRegions.onConfigReloaded();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)RentableRegionsCommand.create(), new String[]{"rrg", "rentableregions"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)AdminCommand.create(), new String[]{"rrga"});
        Sponge.getEventManager().registerListeners((Object)this, (Object)new SignListeners());
    }

    public static Optional<Text> canRent(User player, RentedRegion region) {
        String limit = player.getOption(player.getActiveContexts(), "rrgrentlimit").orElse(null);
        if (limit == null) {
            return Optional.empty();
        }
        try {
            long val = Long.valueOf(limit);
            PlayerData data = RentableRegions.getPlayerData(player.getUniqueId());
            if ((long)data.rentedRegions.size() >= val) {
                return Optional.of(Text.of((Object[])new Object[]{TextColors.RED, "You cannot rent more than " + val + " regions (currently renting " + data.rentedRegions.size() + ")!"}));
            }
            return Optional.empty();
        }
        catch (NumberFormatException e) {
            RentableRegions.INSTANCE.logger.error("Invalid region limit for player " + player.getName() + ": " + limit);
            return Optional.empty();
        }
    }

    public static boolean stopRenting(UUID owner, RentedRegion rentedRegion, boolean refund) {
        if (!rentedRegion.owner.equals(owner)) {
            throw new IllegalStateException("Current owner is " + rentedRegion.owner + " but tried to un-rent as " + owner);
        }
        Optional playerOpt = Sponge.getServer().getPlayer(rentedRegion.owner);
        Region region = RegionUtils.load((String)rentedRegion.name);
        if (region == null) {
            RentableRegions.INSTANCE.logger.error("UniverseGuard2 region " + rentedRegion.name + " does not exist!");
            playerOpt.ifPresent(p -> p.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Unable to find UniverseGuard region with name " + rentedRegion.name})));
            return false;
        }
        RentableRegions.getPlayerData((UUID)rentedRegion.owner).rentedRegions.remove(rentedRegion.name);
        Sponge.getServer().getPlayer(rentedRegion.owner).ifPresent(p -> p.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "Your rental of region " + rentedRegion.name + " has ended!"})));
        Duration timeRemaining = rentedRegion.getRemainingTime();
        Duration fullDuration = rentedRegion.getRentalLength();
        rentedRegion.owner = null;
        rentedRegion.endTime = null;
        rentedRegion.startTime = null;
        rentedRegion.addedPlayers.clear();
        RentableRegions.INSTANCE.playerDataManager.saveData(owner);
        INSTANCE.saveRegionsData();
        ((LocalRegion)region).removeMemberByUUID(owner);
        for (UUID member : rentedRegion.addedPlayers) {
            ((LocalRegion)region).removeMemberByUUID(member);
        }
        if (!RegionUtils.save((Region)region)) {
            RentableRegions.INSTANCE.logger.error("An error occured while saving a UniverseGuard2 region!");
            playerOpt.ifPresent(p -> p.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "An error occured while saving the region!"})));
            return false;
        }
        if (refund) {
            TransactionResult result;
            double frac = (double)timeRemaining.getSeconds() / (double)fullDuration.getSeconds();
            BigDecimal refundAmount = rentedRegion.price.multiply(new BigDecimal(frac));
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause((Object)INSTANCE);
                UniqueAccount account = (UniqueAccount)((EconomyService)Sponge.getServiceManager().provideUnchecked(EconomyService.class)).getOrCreateAccount(owner).orElseThrow(() -> new RuntimeException("Failed to get economy account for " + owner));
                result = account.deposit(RentableRegions.getConfig().getCurrency(), refundAmount, frame.getCurrentCause());
            }
            if (result.getResult() != ResultType.SUCCESS) {
                playerOpt.ifPresent(p -> p.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Failed to refund you " + refundAmount})));
                RentableRegions.INSTANCE.logger.error("Failed to refund player" + owner + " amount " + refundAmount);
            } else {
                playerOpt.ifPresent(p -> p.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, String.format("You ended your rental early, and were refunded %s (%.2f%% of the price)", refundAmount.setScale(2, RoundingMode.CEILING), frac * 100.0)})));
            }
        }
        rentedRegion.updateTimeAndDuration();
        return true;
    }

    public static boolean startRenting(Player player, RentedRegion rentedRegion) {
        TransactionResult result;
        if (rentedRegion.isRented()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "This region is currently being rented!"}));
            return false;
        }
        Optional<Text> error = RentableRegions.canRent((User)player, rentedRegion);
        if (error.isPresent()) {
            player.sendMessage(error.get());
            return false;
        }
        rentedRegion.updateTimeAndDuration();
        Region region = RegionUtils.load((String)rentedRegion.name);
        if (region == null) {
            RentableRegions.INSTANCE.logger.error("UniverseGuard2 region " + rentedRegion.name + " does not exist!");
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Unable to find UniverseGuard region with name " + rentedRegion.name}));
            return false;
        }
        UniqueAccount account = (UniqueAccount)((EconomyService)Sponge.getServiceManager().provideUnchecked(EconomyService.class)).getOrCreateAccount(player.getUniqueId()).orElseThrow(() -> new RuntimeException("Failed to get economy account for player" + player.getName()));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)INSTANCE);
            result = account.withdraw(RentableRegions.getConfig().getCurrency(), rentedRegion.price, frame.getCurrentCause());
        }
        if (result.getResult() != ResultType.SUCCESS) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Failed to to withdraw " + rentedRegion.price + " from your balance: " + result.getResult()}));
            return false;
        }
        LocalRegion localRegion = (LocalRegion)region;
        localRegion.addMember(player, RegionRole.MEMBER);
        if (!RegionUtils.save((Region)localRegion)) {
            RentableRegions.INSTANCE.logger.error("An error occured while saving a UniverseGuard2 region!");
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "An error occured while saving the region!"}));
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause((Object)INSTANCE);
                account.deposit(RentableRegions.getConfig().getCurrency(), rentedRegion.price, frame.getCurrentCause());
            }
            localRegion.removeMember(player);
            return false;
        }
        rentedRegion.setRentedBy(player);
        RentableRegions.INSTANCE.playerDataManager.getData((UUID)player.getUniqueId()).rentedRegions.add(rentedRegion.name);
        RentableRegions.INSTANCE.playerDataManager.saveData(player.getUniqueId());
        INSTANCE.saveRegionsData();
        INSTANCE.startExpireTask(rentedRegion);
        return true;
    }

    private void startExpireTask(RentedRegion region) {
        String name = region.name;
        Task.builder().delay(region.getRemainingTime().toMillis(), TimeUnit.MILLISECONDS).execute(() -> {
            try {
                RentableRegions.getRegionsData().getRegion(name).ifPresent(RentedRegion::checkRented);
            }
            catch (Exception e) {
                this.logger.error("Error expiring region " + name, (Throwable)e);
            }
        }).submit((Object)this);
    }

    private void refreshAllSigns() {
        for (RentedRegion rentedRegion : RentableRegions.getRegionsData().getAllRegions()) {
            try {
                this.refreshSigns(rentedRegion);
            }
            catch (Exception e) {
                this.logger.error("Error refreshing sign for region " + (rentedRegion == null ? "<null>" : rentedRegion.name), (Throwable)e);
                return;
            }
        }
    }

    @Listener
    public void onReload(GameReloadEvent event) {
        this.configManager.reload(true);
        this.regionDataManager.reload(true);
        this.playerDataManager.reload();
    }

    @Listener
    public void onGameLoaded(GameLoadCompleteEvent event) {
        RentableRegions.getConfig().getCurrency();
        for (RentedRegion region : RentableRegions.getRegionsData().getAllRegions()) {
            if (!region.isRented()) continue;
            this.startExpireTask(region);
        }
    }
}

