/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions.command;

import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.Tristate;
import pw.aaron1011.rentableregions.RentableRegions;
import pw.aaron1011.rentableregions.command.AddCommand;
import pw.aaron1011.rentableregions.command.ConfirmCommand;
import pw.aaron1011.rentableregions.command.ListCommand;
import pw.aaron1011.rentableregions.command.OwnerCommand;
import pw.aaron1011.rentableregions.command.RemoveCommand;
import pw.aaron1011.rentableregions.command.RentCommand;
import pw.aaron1011.rentableregions.command.SourceChoicesElement;
import pw.aaron1011.rentableregions.command.TimeCommand;
import pw.aaron1011.rentableregions.command.UnrentCommand;
import pw.aaron1011.rentableregions.data.RentedRegion;

public class RentableRegionsCommand {
    public static CommandSpec create() {
        return CommandSpec.builder().child((CommandCallable)AddCommand.create(), new String[]{"add"}).child((CommandCallable)ConfirmCommand.create(), new String[]{"confirm"}).child((CommandCallable)ListCommand.create(), new String[]{"list"}).child((CommandCallable)OwnerCommand.create(), new String[]{"owner"}).child((CommandCallable)RemoveCommand.create(), new String[]{"remove"}).child((CommandCallable)RentCommand.create(), new String[]{"rent"}).child((CommandCallable)TimeCommand.create(), new String[]{"time"}).child((CommandCallable)UnrentCommand.create(), new String[]{"unrent"}).build();
    }

    public static Text getConfirmText() {
        String rawCommand = "/rrg confirm";
        LiteralText command = Text.builder((String)rawCommand).color(TextColors.LIGHT_PURPLE).style(new TextStyle[]{TextStyles.UNDERLINE}).onClick((ClickAction)TextActions.runCommand((String)rawCommand)).build();
        return command;
    }

    public static CommandElement getRegionElement() {
        return RentableRegionsCommand.getRegionElement((src, r) -> true);
    }

    public static CommandElement getOwnRegionElement() {
        return RentableRegionsCommand.getRegionElement((src, r) -> {
            if (!(src instanceof Player)) {
                return false;
            }
            return ((Player)src).getUniqueId().equals(r.owner);
        });
    }

    public static CommandElement getRegionElement(BiPredicate<CommandSource, RentedRegion> predicate) {
        return new SourceChoicesElement((Text)Text.of((String)"region"), src -> RentableRegions.getRegionsData().getAllRegions().stream().filter(r -> predicate.test((CommandSource)src, (RentedRegion)r)).map(r -> r.name).collect(Collectors.toList()), (src, name) -> RentableRegions.getRegionsData().getRegion((String)name).filter(r -> predicate.test((CommandSource)src, (RentedRegion)r)).orElse(null), Tristate.UNDEFINED);
    }
}

