/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions.data;

import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.apache.commons.io.FileUtils;
import org.spongepowered.api.Sponge;
import pw.aaron1011.rentableregions.RentableRegions;

public class DataStorageManager<T> {
    private final String folderName;
    private final Class<T> clazz;
    private Map<UUID, DataStorageInfo> dataMap = new HashMap<UUID, DataStorageInfo>();
    private ConfigurationOptions configurationOptions;
    private Path storageRoot;
    public static final String DATA_FILE_NAME = "data.conf";

    public DataStorageManager(String folderName, Class<T> clazz, ConfigurationOptions configurationOptions) {
        this.folderName = folderName;
        this.clazz = clazz;
        this.configurationOptions = configurationOptions;
        this.storageRoot = Sponge.getConfigManager().getPluginConfig((Object)RentableRegions.INSTANCE).getDirectory().resolve(this.folderName);
        try {
            Files.createDirectories(this.storageRoot, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create configuration directory " + this.folderName);
        }
        this.reload();
    }

    public void deleteData(UUID uuid) {
        try {
            RentableRegions.INSTANCE.logger.info(String.format("Deleting data for %s of type ", uuid) + this.clazz);
            this.dataMap.remove(uuid);
            FileUtils.deleteDirectory((File)this.storageRoot.resolve(uuid.toString()).toFile());
        }
        catch (Exception e) {
            RentableRegions.INSTANCE.logger.error(String.format("Error deleting data for %s for type ", uuid) + this.clazz, (Throwable)e);
        }
    }

    private DataStorageInfo getOrCreateStorage(UUID uuid) {
        DataStorageInfo dataStorage = this.dataMap.get(uuid);
        if (dataStorage == null) {
            dataStorage = this.loadRawDatatFromDisk(uuid).orElseGet(() -> {
                System.err.println("Creating fresh storage for " + this.formatPath(uuid));
                return new DataStorageInfo(uuid);
            });
            this.dataMap.put(uuid, dataStorage);
            this.saveData(uuid);
        }
        return dataStorage;
    }

    public T getData(UUID uuid) {
        return (T)this.getOrCreateStorage(uuid).data;
    }

    public List<T> getAllData() {
        return this.dataMap.entrySet().stream().map(e -> ((DataStorageInfo)e.getValue()).data).collect(Collectors.toList());
    }

    public void saveAllData() {
        for (UUID uuid : this.dataMap.keySet()) {
            this.saveData(uuid);
        }
    }

    public void saveData(UUID uuid) {
        DataStorageInfo storageInfo = this.getOrCreateStorage(uuid);
        storageInfo.writeToConfig();
        try {
            storageInfo.node.setValue(TypeToken.of(this.clazz), storageInfo.data);
            storageInfo.loader.save(storageInfo.node);
        }
        catch (Exception e) {
            RentableRegions.INSTANCE.logger.error("Failed to save config for " + this.formatPath(uuid), (Throwable)e);
        }
    }

    private T newDataInstance(UUID uuid) {
        try {
            return this.clazz.getConstructor(UUID.class).newInstance(uuid);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate class " + this.clazz, e);
        }
    }

    private String formatPath(UUID uuid) {
        return String.format("%s/%s", this.folderName, uuid);
    }

    private Optional<DataStorageInfo> loadRawDatatFromDisk(UUID uuid) {
        Path dataPath = this.getDataPath(uuid);
        if (Files.exists(dataPath, new LinkOption[0])) {
            try {
                HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(dataPath)).build();
                ConfigurationNode rootNode = loader.load(this.configurationOptions);
                Object data = rootNode.getValue(TypeToken.of(this.clazz));
                if (data == null) {
                    data = this.newDataInstance(uuid);
                }
                System.err.println("Successsfully loaded data from disk for " + this.formatPath(uuid));
                return Optional.of(new DataStorageInfo(uuid, (ConfigurationLoader<CommentedConfigurationNode>)loader, rootNode, data));
            }
            catch (Exception e) {
                RentableRegions.INSTANCE.logger.error(String.format("Unable to load data for %s. Backing up data and creating empty data", this.formatPath(uuid)), (Throwable)e);
                try {
                    Files.copy(dataPath, dataPath.resolveSibling("data.conf-" + new Date() + "-.bak"), new CopyOption[0]);
                }
                catch (IOException err) {
                    throw new RuntimeException(String.format("Error while attempting to make backup of bad data config for UUID %s", uuid), err);
                }
            }
        }
        return Optional.empty();
    }

    private Path getDataPath(UUID uuid) {
        Path path = this.storageRoot.resolve(uuid.toString()).resolve(DATA_FILE_NAME);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create config directory for UUID " + uuid, e);
        }
        return path;
    }

    public void reload() {
        this.saveAllData();
        this.dataMap.clear();
        try {
            Files.list(this.storageRoot).forEach(uuidPath -> {
                UUID uuid = UUID.fromString(uuidPath.getFileName().toString());
                this.getData(uuid);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    class DataStorageInfo {
        private UUID owner;
        private T data;
        private ConfigurationLoader<CommentedConfigurationNode> loader;
        private ConfigurationNode node;

        DataStorageInfo(UUID owner, ConfigurationLoader<CommentedConfigurationNode> loader, ConfigurationNode node, T data) {
            this.owner = owner;
            this.data = data;
            this.loader = loader;
            this.node = node;
        }

        DataStorageInfo(UUID owner) {
            this.owner = owner;
            this.data = DataStorageManager.this.newDataInstance(owner);
            this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(DataStorageManager.this.getDataPath(owner))).build();
            this.node = this.loader.createEmptyNode(DataStorageManager.this.configurationOptions);
        }

        public void writeToConfig() {
            try {
                this.node.setValue(TypeToken.of((Class)DataStorageManager.this.clazz), this.data);
            }
            catch (ObjectMappingException e) {
                throw new RuntimeException("Error serializing data for " + DataStorageManager.this.clazz, e);
            }
        }
    }
}

