/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import java.awt.Color;
import java.util.List;
import lumien.randomthings.item.ItemBase;
import lumien.randomthings.item.ItemIngredient;
import lumien.randomthings.item.ModItems;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemFlooPouch
extends ItemBase {
    public ItemFlooPouch() {
        super("flooPouch");
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ItemFlooPouch.getFlooCount(stack) + " / " + 128);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.func_70093_af()) {
            ItemStack me = playerIn.func_184586_b(handIn);
            int flooCount = ItemFlooPouch.getFlooCount(me);
            if (flooCount < 128) {
                for (int slot = 0; slot < playerIn.field_71071_by.func_70302_i_() && flooCount < 128; ++slot) {
                    ItemStack slotItem = playerIn.field_71071_by.func_70301_a(slot);
                    if (slotItem.func_190926_b() || slotItem.func_77973_b() != ModItems.ingredients || slotItem.func_77952_i() != ItemIngredient.INGREDIENT.FLOO_POWDER.id) continue;
                    int used = Math.min(slotItem.func_190916_E(), 128 - flooCount);
                    flooCount += used;
                    slotItem.func_190918_g(used);
                }
                ItemFlooPouch.setFlooCount(me, flooCount);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)me);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static void setFlooCount(ItemStack stack, int count) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = stack.func_77978_p();
        compound.func_74768_a("flooCount", count);
    }

    public static int getFlooCount(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            return compound.func_74762_e("flooCount");
        }
        return 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ItemFlooPouch.getFlooCount(stack) / 128.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Color.GREEN.getRGB();
    }
}

