/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp;

import com.gmail.trentech.pjc.core.ConfigManager;
import com.gmail.trentech.pjp.commands.CMDBack;
import com.gmail.trentech.pjp.data.Keys;
import com.gmail.trentech.pjp.data.immutable.ImmutableBedData;
import com.gmail.trentech.pjp.data.immutable.ImmutableHomeData;
import com.gmail.trentech.pjp.data.immutable.ImmutableLastLocationData;
import com.gmail.trentech.pjp.data.immutable.ImmutableSignPortalData;
import com.gmail.trentech.pjp.data.mutable.BedData;
import com.gmail.trentech.pjp.data.mutable.HomeData;
import com.gmail.trentech.pjp.data.mutable.LastLocationData;
import com.gmail.trentech.pjp.data.mutable.SignPortalData;
import com.gmail.trentech.pjp.init.Commands;
import com.gmail.trentech.pjp.init.Common;
import com.gmail.trentech.pjp.listeners.ButtonListener;
import com.gmail.trentech.pjp.listeners.DoorListener;
import com.gmail.trentech.pjp.listeners.LegacyListener;
import com.gmail.trentech.pjp.listeners.LeverListener;
import com.gmail.trentech.pjp.listeners.PlateListener;
import com.gmail.trentech.pjp.listeners.PortalListener;
import com.gmail.trentech.pjp.listeners.SignListener;
import com.gmail.trentech.pjp.listeners.TeleportListener;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalService;
import com.gmail.trentech.pjp.portal.features.Command;
import com.gmail.trentech.pjp.portal.features.Coordinate;
import com.gmail.trentech.pjp.portal.features.Properties;
import com.gmail.trentech.pjp.utils.Timings;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;

@Plugin(id="pjp", name="ProjectPortals", version="0.14.3", description="One stop shop for all things portal", authors={"TrenTech"}, url="http://github.com/TrenTech/ProjectPortals", dependencies={@Dependency(id="pjc", optional=false)})
public class Main {
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path path;
    @Inject
    private Logger log;
    private static PluginContainer plugin;
    private static Main instance;

    @Listener
    public void onPreInitializationEvent(GamePreInitializationEvent event) {
        plugin = (PluginContainer)Sponge.getPluginManager().getPlugin("pjp").get();
        instance = this;
        try {
            Files.createDirectories(this.path, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Key<MapValue<String, Coordinate>> key = Keys.BED_LOCATIONS;
    }

    @Listener
    public void onInitialization(GameInitializationEvent event) {
        Common.initConfig();
        CommentedConfigurationNode config = ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig();
        Timings timings = new Timings();
        DataRegistration.builder().dataClass(BedData.class).immutableClass(ImmutableBedData.class).builder((DataManipulatorBuilder)new BedData.Builder()).dataName("bed").manipulatorId("pjp_bed").buildAndRegister(Main.getPlugin());
        DataRegistration.builder().dataClass(LastLocationData.class).immutableClass(ImmutableLastLocationData.class).builder((DataManipulatorBuilder)new LastLocationData.Builder()).dataName("last_location").manipulatorId("pjp_last_location").buildAndRegister(Main.getPlugin());
        Sponge.getDataManager().registerBuilder(Coordinate.class, (DataBuilder)new Coordinate.Builder());
        Sponge.getDataManager().registerBuilder(Command.class, (DataBuilder)new Command.Builder());
        Sponge.getDataManager().registerBuilder(Properties.class, (DataBuilder)new Properties.Builder());
        Sponge.getDataManager().registerBuilder(Portal.Local.class, (DataBuilder)new Portal.Local.Builder());
        Sponge.getDataManager().registerBuilder(Portal.Server.class, (DataBuilder)new Portal.Server.Builder());
        Sponge.getEventManager().registerListeners((Object)this, (Object)new TeleportListener(timings));
        Sponge.getServiceManager().setProvider((Object)Main.getPlugin(), PortalService.class, (Object)new PortalService());
        ConfigurationNode modules = config.getNode(new Object[]{"settings", "modules"});
        if (modules.getNode(new Object[]{"back"}).getBoolean()) {
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new CMDBack().cmdBack, new String[]{"back"});
        }
        if (modules.getNode(new Object[]{"buttons"}).getBoolean()) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new ButtonListener(timings));
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdButton, new String[]{"button", "b"});
            this.getLog().info("Button module activated");
        }
        if (modules.getNode(new Object[]{"doors"}).getBoolean()) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new DoorListener(timings));
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdDoor, new String[]{"door", "d"});
            this.getLog().info("Door module activated");
        }
        if (modules.getNode(new Object[]{"plates"}).getBoolean()) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new PlateListener(timings));
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdPlate, new String[]{"plate", "pp"});
            this.getLog().info("Pressure plate module activated");
        }
        if (modules.getNode(new Object[]{"signs"}).getBoolean()) {
            DataRegistration signData = DataRegistration.builder().dataClass(SignPortalData.class).immutableClass(ImmutableSignPortalData.class).builder((DataManipulatorBuilder)new SignPortalData.Builder()).dataName("sign").manipulatorId("pjp_sign").buildAndRegister(Main.getPlugin());
            Sponge.getDataManager().registerLegacyManipulatorIds("com.gmail.trentech.pjp.data.mutable.SignPortalData", signData);
            Sponge.getEventManager().registerListeners((Object)this, (Object)new SignListener(timings));
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdSign, new String[]{"sign", "s"});
            this.getLog().info("Sign module activated");
        }
        if (modules.getNode(new Object[]{"levers"}).getBoolean()) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new LeverListener(timings));
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdLever, new String[]{"lever", "l"});
            this.getLog().info("Lever module activated");
        }
        if (modules.getNode(new Object[]{"portals"}).getBoolean()) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new PortalListener(timings));
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdPortal, new String[]{"portal", "p"});
            if (config.getNode(new Object[]{"options", "portal", "legacy_builder"}).getBoolean()) {
                Sponge.getEventManager().registerListeners((Object)this, (Object)new LegacyListener(timings));
            }
            this.getLog().info("Portal module activated");
        }
        if (modules.getNode(new Object[]{"homes"}).getBoolean()) {
            DataRegistration homeData = DataRegistration.builder().dataClass(HomeData.class).immutableClass(ImmutableHomeData.class).builder((DataManipulatorBuilder)new HomeData.Builder()).dataName("home").manipulatorId("pjp_home").buildAndRegister(Main.getPlugin());
            Sponge.getDataManager().registerLegacyManipulatorIds("com.gmail.trentech.pjp.data.mutable.HomeData", homeData);
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdHome, new String[]{"home", "h"});
            this.getLog().info("Home module activated");
        }
        if (modules.getNode(new Object[]{"warps"}).getBoolean()) {
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdWarp, new String[]{"warp", "w"});
            this.getLog().info("Warp module activated");
        }
        Common.initHelp();
        Common.initData();
    }

    @Listener
    public void onStartedServer(GameStartedServerEvent event) {
        ((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).init();
    }

    @Listener
    public void onReloadEvent(GameReloadEvent event) {
        Sponge.getEventManager().unregisterPluginListeners((Object)Main.getPlugin());
        for (CommandMapping mapping : Sponge.getCommandManager().getOwnedBy((Object)Main.getPlugin())) {
            Sponge.getCommandManager().removeMapping(mapping);
        }
        Common.initConfig();
        CommentedConfigurationNode config = ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig();
        Timings timings = new Timings();
        Sponge.getEventManager().registerListeners((Object)this, (Object)new TeleportListener(timings));
        ConfigurationNode modules = config.getNode(new Object[]{"settings", "modules"});
        if (modules.getNode(new Object[]{"back"}).getBoolean()) {
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new CMDBack().cmdBack, new String[]{"back"});
        }
        if (modules.getNode(new Object[]{"portals"}).getBoolean()) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new PortalListener(timings));
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdPortal, new String[]{"portal", "p"});
            if (config.getNode(new Object[]{"options", "portal", "legacy_builder"}).getBoolean()) {
                Sponge.getEventManager().registerListeners((Object)this, (Object)new LegacyListener(timings));
            }
            this.getLog().info("Portal module activated");
        }
        if (modules.getNode(new Object[]{"buttons"}).getBoolean()) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new ButtonListener(timings));
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdButton, new String[]{"button", "b"});
            this.getLog().info("Button module activated");
        }
        if (modules.getNode(new Object[]{"doors"}).getBoolean()) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new DoorListener(timings));
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdDoor, new String[]{"door", "d"});
            this.getLog().info("Door module activated");
        }
        if (modules.getNode(new Object[]{"plates"}).getBoolean()) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new PlateListener(timings));
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdPlate, new String[]{"plate", "pp"});
            this.getLog().info("Pressure plate module activated");
        }
        if (modules.getNode(new Object[]{"signs"}).getBoolean()) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new SignListener(timings));
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdSign, new String[]{"sign", "s"});
            this.getLog().info("Sign module activated");
        }
        if (modules.getNode(new Object[]{"levers"}).getBoolean()) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new LeverListener(timings));
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdLever, new String[]{"lever", "l"});
            this.getLog().info("Lever module activated");
        }
        if (modules.getNode(new Object[]{"homes"}).getBoolean()) {
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdHome, new String[]{"home", "h"});
            this.getLog().info("Home module activated");
        }
        if (modules.getNode(new Object[]{"warps"}).getBoolean()) {
            Sponge.getCommandManager().register((Object)this, (CommandCallable)new Commands().cmdWarp, new String[]{"warp", "w"});
            this.getLog().info("Warp module activated");
        }
        ((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).init();
    }

    public Logger getLog() {
        return this.log;
    }

    public Path getPath() {
        return this.path;
    }

    public static PluginContainer getPlugin() {
        return plugin;
    }

    public static Main instance() {
        return instance;
    }
}

