/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.commands.elements;

import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class PortalElement
extends CommandElement {
    private Portal.PortalType type;

    public PortalElement(Text key, Portal.PortalType type) {
        super(key);
        this.type = type;
    }

    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        String next = args.next().toLowerCase();
        Optional<Portal> optionalPortal = ((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).get(next, this.type);
        if (optionalPortal.isPresent()) {
            return optionalPortal.get();
        }
        throw args.createError(Text.of((Object[])new Object[]{TextColors.RED, "Portal not found"}));
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        ArrayList<String> list = new ArrayList<String>();
        Optional next = args.nextIfPresent();
        PortalService portalService = (PortalService)Sponge.getServiceManager().provide(PortalService.class).get();
        if (next.isPresent()) {
            for (Portal portal : portalService.all(this.type)) {
                if (!portal.getName().startsWith(((String)next.get()).toLowerCase())) continue;
                list.add(portal.getName());
            }
        } else {
            for (Portal portal : portalService.all(this.type)) {
                list.add(portal.getName());
            }
        }
        return list;
    }

    public Text getUsage(CommandSource src) {
        return Text.of((Object[])new Object[]{this.getKey()});
    }
}

