/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.commands.portal;

import com.flowpowered.math.vector.Vector3d;
import com.gmail.trentech.pjc.core.BungeeManager;
import com.gmail.trentech.pjc.core.ConfigManager;
import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjp.Main;
import com.gmail.trentech.pjp.effects.Particle;
import com.gmail.trentech.pjp.effects.ParticleColor;
import com.gmail.trentech.pjp.effects.Particles;
import com.gmail.trentech.pjp.listeners.LegacyListener;
import com.gmail.trentech.pjp.listeners.PortalListener;
import com.gmail.trentech.pjp.portal.LegacyBuilder;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalService;
import com.gmail.trentech.pjp.portal.features.Command;
import com.gmail.trentech.pjp.portal.features.Coordinate;
import com.gmail.trentech.pjp.portal.features.Properties;
import com.gmail.trentech.pjp.rotation.Rotation;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.world.World;

public class CMDCreate
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Help help = (Help)Help.get((String)"portal create").get();
        if (args.hasAny("help")) {
            help.execute(src);
            return CommandResult.empty();
        }
        if (!(src instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Must be a player"}), false);
        }
        Player player = (Player)src;
        if (!args.hasAny("name")) {
            throw new CommandException(Text.builder().onClick((ClickAction)TextActions.executeCallback((Consumer)help.execute())).append(new Text[]{help.getUsageText()}).build(), false);
        }
        String name = ((String)args.getOne("name").get()).toLowerCase();
        if (((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).get(name, Portal.PortalType.PORTAL).isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, name, " already exists"}), false);
        }
        if (!args.hasAny("destination")) {
            throw new CommandException(Text.builder().onClick((ClickAction)TextActions.executeCallback((Consumer)help.execute())).append(new Text[]{help.getUsageText()}).build(), false);
        }
        String destination = (String)args.getOne("destination").get();
        Optional<Object> coordinate = Optional.empty();
        AtomicReference<Rotation> rotation = new AtomicReference<Rotation>(Rotation.EAST);
        AtomicReference<Double> price = new AtomicReference<Double>(0.0);
        boolean force = false;
        AtomicReference<Particle> particle = new AtomicReference<Particle>(Particles.getDefaultEffect("portal"));
        AtomicReference<Optional<ParticleColor>> color = new AtomicReference<Optional<ParticleColor>>(Particles.getDefaultColor("portal", particle.get().isColorable()));
        Optional permission = args.getOne("permission");
        AtomicReference command = new AtomicReference(Optional.empty());
        if (args.hasAny("price")) {
            price.set((Double)args.getOne("price").get());
        }
        if (args.hasAny("command")) {
            String rawCommand = (String)args.getOne("command").get();
            String source = rawCommand.substring(0, 2);
            if (rawCommand.length() < 2) {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Did not specify command source. P: for player or C: for console. Example \"P:say hello world\""}), false);
            }
            if (source.equalsIgnoreCase("P:")) {
                command.set(Optional.of(new Command(Command.SourceType.PLAYER, rawCommand.substring(2))));
            } else if (source.equalsIgnoreCase("C:")) {
                command.set(Optional.of(new Command(Command.SourceType.CONSOLE, rawCommand.substring(2))));
            } else {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Did not specify command source. P: for player or C: for console. Example \"P:say hello world\""}), false);
            }
        }
        if (args.hasAny("particle")) {
            particle.set(((Particles)((Object)args.getOne("particle").get())).getParticle());
            if (args.hasAny("color")) {
                color.set(Optional.of(args.getOne("color").get()));
            }
        }
        if (args.hasAny("b")) {
            Consumer<List> consumer1 = list -> {
                if (!list.contains(destination)) {
                    try {
                        throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, destination, " does not exist"}), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Consumer<String> consumer2 = s -> {
                    if (destination.equalsIgnoreCase((String)s)) {
                        try {
                            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Destination cannot be the server you are currently on"}), false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Portal.Server server = new Portal.Server(Portal.PortalType.PORTAL, destination, (Rotation)((Object)((Object)((Object)rotation.get()))), (Double)price.get());
                    if (permission.isPresent()) {
                        server.setPermission((String)permission.get());
                    }
                    if (((Optional)command.get()).isPresent()) {
                        server.setCommand((Command)((Optional)command.get()).get());
                    }
                    Properties properties = new Properties((Particle)particle.get(), (Optional)color.get());
                    server.setProperties(properties);
                    server.setName(name);
                    if (ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "portal", "legacy_builder"}).getBoolean()) {
                        LegacyListener.builders.put(player.getUniqueId(), new LegacyBuilder(server));
                        player.sendMessage(Text.builder().color(TextColors.DARK_GREEN).append(new Text[]{Text.of((String)"Begin building your portal frame, followed by ")}).onClick((ClickAction)TextActions.runCommand((String)"/pjp:portal save")).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, TextStyles.UNDERLINE, "/portal save"})}).build());
                    } else {
                        PortalListener.builders.put(player.getUniqueId(), server);
                        player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Right click bottom with empty hand similar to vanilla nether portals "}));
                    }
                };
                BungeeManager.getServer(consumer2, (Player)player);
            };
            BungeeManager.getServers(consumer1, (Player)player);
        } else {
            Optional world = Sponge.getServer().getWorld(destination);
            if (!world.isPresent()) {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, destination, " is not loaded or does not exist"}), false);
            }
            if (args.hasAny("x,y,z")) {
                String[] coords = ((String)args.getOne("x,y,z").get()).split(",");
                if (coords[0].equalsIgnoreCase("random")) {
                    coordinate = Optional.of(new Coordinate((World)world.get(), Coordinate.Preset.RANDOM));
                } else if (coords[0].equalsIgnoreCase("bed")) {
                    coordinate = Optional.of(new Coordinate((World)world.get(), Coordinate.Preset.BED));
                } else if (coords[0].equalsIgnoreCase("last")) {
                    coordinate = Optional.of(new Coordinate((World)world.get(), Coordinate.Preset.LAST_LOCATION));
                } else {
                    try {
                        coordinate = Optional.of(new Coordinate((World)world.get(), new Vector3d(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]), Double.parseDouble(coords[2]))));
                    }
                    catch (Exception e) {
                        throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, coords.toString(), " is not valid"}), true);
                    }
                }
            } else {
                coordinate = Optional.of(new Coordinate((World)world.get(), Coordinate.Preset.NONE));
            }
            if (args.hasAny("direction")) {
                rotation.set((Rotation)((Object)args.getOne("direction").get()));
            }
            if (args.hasAny("f")) {
                force = true;
            }
            Portal.Local local = new Portal.Local(Portal.PortalType.PORTAL, rotation.get(), price.get(), force);
            if (coordinate.isPresent()) {
                local.setCoordinate((Coordinate)coordinate.get());
            }
            if (permission.isPresent()) {
                local.setPermission((String)permission.get());
            }
            if (command.get().isPresent()) {
                local.setCommand((Command)command.get().get());
            }
            Properties properties = new Properties(particle.get(), color.get());
            local.setProperties(properties);
            local.setName(name);
            if (ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "portal", "legacy_builder"}).getBoolean()) {
                LegacyListener.builders.put(player.getUniqueId(), new LegacyBuilder(local));
                player.sendMessage(Text.builder().color(TextColors.DARK_GREEN).append(new Text[]{Text.of((String)"Begin building your portal frame, followed by ")}).onClick((ClickAction)TextActions.runCommand((String)"/pjp:portal save")).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, TextStyles.UNDERLINE, "/portal save"})}).build());
            } else {
                PortalListener.builders.put(player.getUniqueId(), local);
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Right click bottom with empty hand similar to vanilla nether portals "}));
            }
        }
        return CommandResult.success();
    }
}

