/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;

public class HelmRevealingRecipe
extends ShapelessRecipes {
    @GameRegistry.ObjectHolder(value="thaumcraft:goggles")
    private static Item goggles = null;
    private final Item botaniaHelm;
    private static final String TAG_RUNIC = "TC.RUNIC";
    private static final String TAG_WARP = "TC.WARP";
    private static final String TAG_INFUSION_ENCH = "infench";

    public HelmRevealingRecipe(Item output, Item botaniaHelm) {
        super("botania:helm_revealing", new ItemStack(output), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193367_a((Item)botaniaHelm), Ingredient.func_193367_a((Item)goggles)}));
        this.botaniaHelm = botaniaHelm;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting var1) {
        ItemStack newHelm;
        ItemStack helm = ItemStack.field_190927_a;
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            ItemStack stack = var1.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != this.botaniaHelm) continue;
            helm = stack;
        }
        if (helm.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack helmCopy = helm.func_77946_l();
        Item helmItem = helmCopy.func_77973_b();
        if (helmItem == ModItems.manasteelHelm) {
            newHelm = new ItemStack(ModItems.manasteelHelmRevealing);
        } else if (helmItem == ModItems.terrasteelHelm) {
            newHelm = new ItemStack(ModItems.terrasteelHelmRevealing);
        } else if (helmItem == ModItems.elementiumHelm) {
            newHelm = new ItemStack(ModItems.elementiumHelmRevealing);
        } else {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < 6; ++i) {
            if (!ItemNBTHelper.getBoolean(helmCopy, "AncientWill" + i, false)) continue;
            ItemNBTHelper.setBoolean(newHelm, "AncientWill" + i, true);
        }
        NBTTagList enchList = ItemNBTHelper.getList(helmCopy, "ench", 10, true);
        if (enchList != null) {
            ItemNBTHelper.setList(newHelm, "ench", enchList);
        }
        HelmRevealingRecipe.copyTCData(helmCopy, newHelm);
        return newHelm;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static void copyTCData(ItemStack source, ItemStack destination) {
        NBTTagList infEnchList;
        byte warp;
        byte runicShielding = ItemNBTHelper.getByte(source, TAG_RUNIC, (byte)0);
        if (runicShielding != 0) {
            ItemNBTHelper.setByte(destination, TAG_RUNIC, runicShielding);
        }
        if ((warp = ItemNBTHelper.getByte(source, TAG_WARP, (byte)0)) != 0) {
            ItemNBTHelper.setByte(destination, TAG_WARP, warp);
        }
        if ((infEnchList = ItemNBTHelper.getList(source, TAG_INFUSION_ENCH, 10, true)) != null) {
            ItemNBTHelper.setList(destination, TAG_INFUSION_ENCH, infEnchList);
        }
    }
}

