/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.common.item.lens.ItemLens;

public class LensDyeingRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static final List<String> DYES = Arrays.asList("dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack", "manaPearl");

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting var1, @Nonnull World var2) {
        boolean foundLens = false;
        boolean foundDye = false;
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            ItemStack stack = var1.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ILens && !foundLens) {
                foundLens = true;
                continue;
            }
            if (!foundDye) {
                int color = this.getStackColor(stack);
                if (color > -1) {
                    foundDye = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundLens && foundDye;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting var1) {
        ItemStack lens = ItemStack.field_190927_a;
        int color = -1;
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            ItemStack stack = var1.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ILens && lens.func_190926_b()) {
                lens = stack;
                continue;
            }
            color = this.getStackColor(stack);
        }
        if (lens.func_77973_b() instanceof ILens) {
            lens.func_77973_b();
            ItemStack lensCopy = lens.func_77946_l();
            ItemLens.setLensColor(lensCopy, color);
            return lensCopy;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    int getStackColor(ItemStack stack) {
        int[] ids;
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            int index = DYES.indexOf(OreDictionary.getOreName((int)i));
            if (index < 0) continue;
            return index;
        }
        return -1;
    }
}

