/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.integrations.placeholderapi;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import java.time.Instant;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import me.rojo8399.placeholderapi.Placeholder;
import me.rojo8399.placeholderapi.PlaceholderService;
import me.rojo8399.placeholderapi.Source;
import me.rojo8399.placeholderapi.Token;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;

public class EFPlaceholderService {
    private static EFPlaceholderService INSTANCE = null;
    private final EagleFactions plugin;
    private final PlaceholderService placeholderService;

    public static EFPlaceholderService getInstance(EagleFactions plugin, Object placeholderService) {
        if (INSTANCE == null) {
            INSTANCE = new EFPlaceholderService(plugin, (PlaceholderService)placeholderService);
        }
        return INSTANCE;
    }

    private EFPlaceholderService(EagleFactions plugin, PlaceholderService placeholderService) {
        this.plugin = plugin;
        this.placeholderService = placeholderService;
        this.registerPlaceholders();
    }

    public PlaceholderService getPlaceholderService() {
        return this.placeholderService;
    }

    private void registerPlaceholders() {
        this.placeholderService.loadAll((Object)this, (Object)this.plugin).stream().map(builder -> {
            switch (builder.getId()) {
                case "faction": {
                    try {
                        return builder.tokens(new String[]{"name", "tag", "power", "maxpower", "last_online", "claims_count", "alliances", "enemies", "truce", "officers_count", "members_count", "recruits_count"}).description("Player's faction's placeholders.").url("https://github.com/Aquerr/EagleFactions").author("Aquerr (Nerdi)").version("1.0").plugin((Object)this.plugin);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                case "factionplayer": {
                    try {
                        return builder.tokens(new String[]{"power", "maxpower", "last_online"}).description("Player's placeholders.").url("https://github.com/Aquerr/EagleFactions").author("Aquerr (Nerdi)").version("1.0").plugin((Object)this.plugin);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return builder;
        }).map(builder -> builder.author("Aquerr (Nerdi)").version("1.0")).forEach(builder -> {
            try {
                builder.buildAndRegister();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Placeholder(id="faction")
    public Object faction(@Token(fix=true) @Nullable String token, @Nullable @Source User player) {
        if (token == null) {
            return "";
        }
        switch (token) {
            case "name": {
                return this.getFactionName(player);
            }
            case "tag": {
                return this.getFactionTag(player);
            }
            case "power": {
                return Float.valueOf(this.getFactionPower(player));
            }
            case "maxpower": {
                return Float.valueOf(this.getFactionMaxPower(player));
            }
            case "last_online": {
                return this.getFactionLastOnline(player);
            }
            case "claims_count": {
                return this.getFactionClaimCount(player);
            }
            case "officers_count": {
                return this.getFactionOfficerCount(player);
            }
            case "members_count": {
                return this.getFactionMemberCount(player);
            }
            case "recruits_count": {
                return this.getFactionRecruitCount(player);
            }
            case "alliances": {
                return this.getFactionAlliances(player);
            }
            case "enemies": {
                return this.getFactionEnemies(player);
            }
            case "truce": {
                return this.getFactionTruce(player);
            }
        }
        return "";
    }

    @Placeholder(id="factionplayer")
    public Object factionPlayer(@Token(fix=true) @Nullable String token, @Nullable @Source User player) {
        if (token == null) {
            return "";
        }
        switch (token) {
            case "power": {
                return Float.valueOf(this.getPlayerPower(player));
            }
            case "maxpower": {
                return Float.valueOf(this.getPlayerMaxPower(player));
            }
            case "last_online": {
                return this.getPlayerLastOnline(player);
            }
        }
        return "";
    }

    private String getFactionName(User user) {
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(user.getUniqueId());
        if (optionalFaction.isPresent()) {
            return optionalFaction.get().getName();
        }
        return "";
    }

    private Text getFactionTag(User user) {
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(user.getUniqueId());
        if (optionalFaction.isPresent()) {
            return optionalFaction.get().getTag();
        }
        return Text.of((String)"");
    }

    private float getFactionPower(User player) {
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        return optionalFaction.map(faction -> Float.valueOf(this.plugin.getPowerManager().getFactionPower((Faction)faction))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private float getFactionMaxPower(User player) {
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        return optionalFaction.map(faction -> Float.valueOf(this.plugin.getPowerManager().getFactionMaxPower((Faction)faction))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private Instant getFactionLastOnline(User player) {
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (optionalFaction.isPresent()) {
            return optionalFaction.get().getLastOnline();
        }
        return Instant.now();
    }

    private int getFactionClaimCount(User player) {
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        return optionalFaction.map(x -> x.getClaims().size()).orElse(0);
    }

    private int getFactionOfficerCount(User player) {
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        return optionalFaction.map(x -> x.getOfficers().size()).orElse(0);
    }

    private int getFactionMemberCount(User player) {
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        return optionalFaction.map(x -> x.getMembers().size()).orElse(0);
    }

    private int getFactionRecruitCount(User player) {
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        return optionalFaction.map(x -> x.getRecruits().size()).orElse(0);
    }

    private Set<String> getFactionAlliances(User player) {
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        return optionalFaction.map(Faction::getAlliances).orElse(new HashSet());
    }

    private Set<String> getFactionEnemies(User player) {
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        return optionalFaction.map(Faction::getEnemies).orElse(new HashSet());
    }

    private Set<String> getFactionTruce(User player) {
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        return optionalFaction.map(Faction::getTruces).orElse(new HashSet());
    }

    private float getPlayerPower(User player) {
        return this.plugin.getPlayerManager().getPlayerPower(player.getUniqueId());
    }

    private float getPlayerMaxPower(User player) {
        return this.plugin.getPlayerManager().getPlayerMaxPower(player.getUniqueId());
    }

    private String getPlayerLastOnline(User player) {
        return "";
    }
}

