/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.managers;

import com.google.inject.Singleton;
import io.github.aquerr.eaglefactions.api.config.ChatConfig;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.EagleFeather;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.managers.PermsManager;
import io.github.aquerr.eaglefactions.api.managers.PlayerManager;
import io.github.aquerr.eaglefactions.api.managers.ProtectionManager;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.ArmorStand;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Singleton
public class ProtectionManagerImpl
implements ProtectionManager {
    private final FactionLogic factionLogic;
    private final PermsManager permsManager;
    private final PlayerManager playerManager;
    private final ProtectionConfig protectionConfig;
    private final ChatConfig chatConfig;
    private final FactionsConfig factionsConfig;

    public ProtectionManagerImpl(FactionLogic factionLogic, PermsManager permsManager, PlayerManager playerManager, ProtectionConfig protectionConfig, ChatConfig chatConfig, FactionsConfig factionsConfig) {
        this.protectionConfig = protectionConfig;
        this.chatConfig = chatConfig;
        this.factionsConfig = factionsConfig;
        this.factionLogic = factionLogic;
        this.permsManager = permsManager;
        this.playerManager = playerManager;
    }

    @Override
    public boolean canInteractWithBlock(Location<World> location, User user, boolean shouldNotify) {
        boolean canInteract = this.canInteractWithBlock(location, user);
        if (shouldNotify && !canInteract) {
            this.notifyPlayer(user);
        }
        return canInteract;
    }

    private boolean canInteractWithBlock(Location<World> location, User user) {
        boolean isTileEntityAtLocation = location.getTileEntity().isPresent();
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)"Interact With Block:")));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Location: " + location.toString()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("User: " + user.getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Block at location: " + location.getBlockType().getName()))));
        }
        World world = (World)location.getExtent();
        if (this.playerManager.hasAdminMode(user)) {
            return true;
        }
        if (this.isBlockWhitelistedForInteraction(location.getBlockType().getId())) {
            return true;
        }
        Set<String> safeZoneWorlds = this.protectionConfig.getSafeZoneWorldNames();
        Set<String> warZoneWorlds = this.protectionConfig.getWarZoneWorldNames();
        if (safeZoneWorlds.contains(world.getName()) || warZoneWorlds.contains(world.getName())) {
            if (safeZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.safezone.interact")) {
                return true;
            }
            if (warZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.warzone.interact")) {
                return true;
            }
            if (warZoneWorlds.contains(world.getName()) && isTileEntityAtLocation && this.isHoldingEagleFeather(user)) {
                this.removeEagleFeather(user);
                return true;
            }
            return false;
        }
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        Optional<Faction> optionalPlayerFaction = this.factionLogic.getFactionByPlayerUUID(user.getUniqueId());
        if (!optionalChunkFaction.isPresent()) {
            return !this.protectionConfig.shouldProtectWildernessFromPlayers();
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.isSafeZone() && user.hasPermission("eaglefactions.safezone.interact")) {
            return true;
        }
        if (chunkFaction.isWarZone() && user.hasPermission("eaglefactions.warzone.interact")) {
            return true;
        }
        if (chunkFaction.isWarZone() && isTileEntityAtLocation && this.isHoldingEagleFeather(user)) {
            this.removeEagleFeather(user);
            return true;
        }
        if (!optionalPlayerFaction.isPresent()) {
            if (isTileEntityAtLocation && this.isHoldingEagleFeather(user)) {
                this.removeEagleFeather(user);
                return true;
            }
            return false;
        }
        Faction playerFaction = optionalPlayerFaction.get();
        if (this.permsManager.canInteract(user.getUniqueId(), playerFaction, chunkFaction)) {
            return true;
        }
        if (isTileEntityAtLocation && this.isHoldingEagleFeather(user)) {
            this.removeEagleFeather(user);
            return true;
        }
        return false;
    }

    @Override
    public boolean canUseItem(Location<World> location, User user, ItemStackSnapshot usedItem, boolean shouldNotify) {
        boolean canUseItem = this.canUseItem(location, user, usedItem);
        if (shouldNotify && !canUseItem) {
            this.notifyPlayer(user);
        }
        return canUseItem;
    }

    private boolean canUseItem(Location<World> location, User user, ItemStackSnapshot usedItem) {
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)"Usage of item:")));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Location: " + location.toString()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("User: " + user.getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Block at location: " + location.getBlockType().getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Used item: " + usedItem.getType().getName()))));
        }
        World world = (World)location.getExtent();
        if (this.playerManager.hasAdminMode(user) || this.isItemWhitelisted(usedItem.getType().getId())) {
            return true;
        }
        Set<String> safeZoneWorlds = this.protectionConfig.getSafeZoneWorldNames();
        Set<String> warZoneWorlds = this.protectionConfig.getWarZoneWorldNames();
        if (safeZoneWorlds.contains(world.getName()) || warZoneWorlds.contains(world.getName())) {
            if (safeZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.safezone.interact")) {
                return true;
            }
            return warZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.warzone.interact");
        }
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        Optional<Faction> optionalPlayerFaction = this.factionLogic.getFactionByPlayerUUID(user.getUniqueId());
        if (!optionalChunkFaction.isPresent()) {
            return !this.protectionConfig.shouldProtectWildernessFromPlayers();
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.isSafeZone() && user.hasPermission("eaglefactions.safezone.interact")) {
            return true;
        }
        if (chunkFaction.isWarZone() && user.hasPermission("eaglefactions.warzone.interact")) {
            return true;
        }
        if (!optionalPlayerFaction.isPresent()) {
            return false;
        }
        Faction playerFaction = optionalPlayerFaction.get();
        return this.permsManager.canInteract(user.getUniqueId(), playerFaction, chunkFaction);
    }

    @Override
    public boolean canBreak(Location<World> location, User user, boolean shouldNotify) {
        boolean canBreak = this.canBreak(location, user);
        if (shouldNotify && !canBreak) {
            this.notifyPlayer(user);
        }
        return canBreak;
    }

    private boolean canBreak(Location<World> location, User user) {
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)"Block break event!")));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Location: " + location.toString()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("User: " + user.getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Block at location: " + location.getBlockType().getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Block id: " + location.getBlockType().getId()))));
        }
        World world = (World)location.getExtent();
        if (this.playerManager.hasAdminMode(user) || this.isBlockWhitelistedForPlaceDestroy(location.getBlockType().getId())) {
            return true;
        }
        Set<String> safeZoneWorlds = this.protectionConfig.getSafeZoneWorldNames();
        Set<String> warZoneWorlds = this.protectionConfig.getWarZoneWorldNames();
        if (safeZoneWorlds.contains(world.getName()) || warZoneWorlds.contains(world.getName())) {
            if (safeZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.safezone.build")) {
                return true;
            }
            return warZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.warzone.build");
        }
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        Optional<Faction> optionalPlayerFaction = this.factionLogic.getFactionByPlayerUUID(user.getUniqueId());
        if (optionalChunkFaction.isPresent()) {
            if (optionalChunkFaction.get().isSafeZone() || optionalChunkFaction.get().isWarZone()) {
                if (optionalChunkFaction.get().isSafeZone() && user.hasPermission("eaglefactions.safezone.build")) {
                    return true;
                }
                return optionalChunkFaction.get().isWarZone() && user.hasPermission("eaglefactions.warzone.build");
            }
            return optionalPlayerFaction.filter(faction -> this.permsManager.canBreakBlock(user.getUniqueId(), (Faction)faction, (Faction)optionalChunkFaction.get())).isPresent();
        }
        return !this.protectionConfig.shouldProtectWildernessFromPlayers();
    }

    @Override
    public boolean canBreak(Location<World> location) {
        World world = (World)location.getExtent();
        if (this.isBlockWhitelistedForPlaceDestroy(location.getBlockType().getId())) {
            return true;
        }
        if (this.protectionConfig.getSafeZoneWorldNames().contains(world.getName())) {
            return false;
        }
        if (this.protectionConfig.getWarZoneWorldNames().contains(world.getName()) && this.protectionConfig.shouldProtectWarZoneFromMobGrief()) {
            return false;
        }
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        if (!optionalChunkFaction.isPresent()) {
            return true;
        }
        if (optionalChunkFaction.get().isSafeZone()) {
            return false;
        }
        if (optionalChunkFaction.get().isWarZone() && this.protectionConfig.shouldProtectWarZoneFromMobGrief()) {
            return false;
        }
        return !this.protectionConfig.shouldProtectClaimFromMobGrief();
    }

    @Override
    public boolean canPlace(Location<World> location, User user, boolean shouldNotify) {
        boolean canPlace = this.canPlace(location, user);
        if (shouldNotify && !canPlace) {
            this.notifyPlayer(user);
        }
        return canPlace;
    }

    private boolean canPlace(Location<World> location, User user) {
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)"Block place:")));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Location: " + location.toString()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("User: " + user.getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Block at location: " + location.getBlockType().getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Item in hand: " + (user.getItemInHand(HandTypes.MAIN_HAND).isPresent() ? ((ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get()).getType().getName() : "")))));
        }
        World world = (World)location.getExtent();
        if (this.playerManager.hasAdminMode(user) || user.getItemInHand(HandTypes.MAIN_HAND).isPresent() && this.isBlockWhitelistedForPlaceDestroy(((ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get()).getType().getId())) {
            return true;
        }
        Set<String> safeZoneWorlds = this.protectionConfig.getSafeZoneWorldNames();
        Set<String> warZoneWorlds = this.protectionConfig.getWarZoneWorldNames();
        if (safeZoneWorlds.contains(world.getName()) || warZoneWorlds.contains(world.getName())) {
            if (safeZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.safezone.build")) {
                return true;
            }
            return warZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.warzone.build");
        }
        Optional<Faction> optionalPlayerFaction = this.factionLogic.getFactionByPlayerUUID(user.getUniqueId());
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        if (optionalChunkFaction.isPresent()) {
            if (optionalChunkFaction.get().isSafeZone() || optionalChunkFaction.get().isWarZone()) {
                if (optionalChunkFaction.get().isSafeZone() && user.hasPermission("eaglefactions.safezone.build")) {
                    return true;
                }
                return optionalChunkFaction.get().isWarZone() && user.hasPermission("eaglefactions.warzone.build");
            }
            return optionalPlayerFaction.filter(faction -> this.permsManager.canPlaceBlock(user.getUniqueId(), (Faction)faction, (Faction)optionalChunkFaction.get())).isPresent();
        }
        return !this.protectionConfig.shouldProtectWildernessFromPlayers();
    }

    @Override
    public boolean canExplode(Location<World> location, User user, boolean shouldNotify) {
        boolean canExplode = this.canExplode(location, user);
        if (shouldNotify && !canExplode) {
            this.notifyPlayer(user);
        }
        return canExplode;
    }

    private boolean canExplode(Location<World> location, User user) {
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)"Explosion:")));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Location: " + location.toString()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("User: " + user.getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Block at location: " + location.getBlockType().getName()))));
        }
        boolean shouldProtectWarZoneFromPlayers = this.protectionConfig.shouldProtectWarzoneFromPlayers();
        boolean allowExplosionsByOtherPlayersInClaims = this.protectionConfig.shouldAllowExplosionsByOtherPlayersInClaims();
        if (this.playerManager.hasAdminMode(user)) {
            return true;
        }
        if (this.protectionConfig.getSafeZoneWorldNames().contains(((World)location.getExtent()).getName())) {
            return false;
        }
        if (this.protectionConfig.getWarZoneWorldNames().contains(((World)location.getExtent()).getName())) {
            return !shouldProtectWarZoneFromPlayers;
        }
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(((World)location.getExtent()).getUniqueId(), location.getChunkPosition());
        if (!optionalChunkFaction.isPresent()) {
            return !this.protectionConfig.shouldProtectWildernessFromPlayers();
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.isSafeZone() || chunkFaction.isWarZone()) {
            if (chunkFaction.isSafeZone() && user.hasPermission("eaglefactions.safezone.build")) {
                return true;
            }
            return chunkFaction.isWarZone() && user.hasPermission("eaglefactions.warzone.build");
        }
        Optional<Faction> optionalPlayerFaction = this.factionLogic.getFactionByPlayerUUID(user.getUniqueId());
        if (optionalPlayerFaction.isPresent()) {
            Faction playerFaction = optionalPlayerFaction.get();
            if (chunkFaction.getName().equalsIgnoreCase(playerFaction.getName())) {
                return this.permsManager.canPlaceBlock(user.getUniqueId(), playerFaction, chunkFaction);
            }
        }
        return allowExplosionsByOtherPlayersInClaims;
    }

    @Override
    public boolean canExplode(Location<World> location) {
        boolean shouldProtectWarZoneFromMobGrief = this.protectionConfig.shouldProtectWarZoneFromMobGrief();
        boolean shouldProtectClaimsFromMobGrief = this.protectionConfig.shouldProtectClaimFromMobGrief();
        if (this.protectionConfig.getSafeZoneWorldNames().contains(((World)location.getExtent()).getName())) {
            return false;
        }
        if (this.protectionConfig.getWarZoneWorldNames().contains(((World)location.getExtent()).getName())) {
            return !shouldProtectWarZoneFromMobGrief;
        }
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(((World)location.getExtent()).getUniqueId(), location.getChunkPosition());
        if (!optionalChunkFaction.isPresent()) {
            return true;
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.isSafeZone()) {
            return false;
        }
        if (chunkFaction.isWarZone() && shouldProtectWarZoneFromMobGrief) {
            return false;
        }
        return !shouldProtectClaimsFromMobGrief;
    }

    @Override
    public boolean canAttackEntity(Entity attackedEntity, Player player, boolean shouldNotify) {
        boolean canAttack = this.canAttackEntity(attackedEntity, player);
        if (shouldNotify && !canAttack) {
            this.notifyPlayer((User)player);
        }
        return canAttack;
    }

    private boolean canAttackEntity(Entity attackedEntity, Player player) {
        boolean isMob;
        if (this.playerManager.hasAdminMode((User)player)) {
            return true;
        }
        boolean isPlayer = attackedEntity instanceof Player;
        boolean bl = isMob = !isPlayer && attackedEntity instanceof Living && !(attackedEntity instanceof ArmorStand);
        if (isMob) {
            return true;
        }
        Location entityLocation = attackedEntity.getLocation();
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(((World)entityLocation.getExtent()).getUniqueId(), entityLocation.getChunkPosition());
        Optional<Faction> optionalAttackerPlayerFaction = this.factionLogic.getFactionByPlayerUUID(player.getUniqueId());
        Optional<Faction> optionalSourceChunkFaction = this.factionLogic.getFactionByChunk(player.getWorld().getUniqueId(), player.getLocation().getChunkPosition());
        boolean isSafeZoneWorld = this.protectionConfig.getSafeZoneWorldNames().contains(((World)entityLocation.getExtent()).getName());
        boolean isWarZoneWorld = this.protectionConfig.getWarZoneWorldNames().contains(((World)entityLocation.getExtent()).getName());
        if (isPlayer) {
            Player attackedPlayer = (Player)attackedEntity;
            Optional<Faction> optionalAttackedPlayerFaction = this.factionLogic.getFactionByPlayerUUID(attackedPlayer.getUniqueId());
            if (isSafeZoneWorld) {
                return false;
            }
            if (optionalChunkFaction.isPresent() && optionalChunkFaction.get().isSafeZone()) {
                return false;
            }
            if (attackedEntity.equals(player)) {
                return true;
            }
            if (optionalSourceChunkFaction.isPresent() && optionalSourceChunkFaction.get().isSafeZone()) {
                return false;
            }
            if (!optionalAttackerPlayerFaction.isPresent()) {
                return true;
            }
            if (!optionalAttackedPlayerFaction.isPresent()) {
                return true;
            }
            Faction attackedFaction = optionalAttackedPlayerFaction.get();
            Faction attackerFaction = optionalAttackerPlayerFaction.get();
            if (!attackerFaction.getName().equals(attackedFaction.getName())) {
                if (attackerFaction.isAlly(attackedFaction) && !this.factionsConfig.isAllianceFriendlyFire()) {
                    return false;
                }
                return !attackerFaction.isTruce(attackedFaction) || this.factionsConfig.isTruceFriendlyFire();
            }
            return this.factionsConfig.isFactionFriendlyFire();
        }
        if (isSafeZoneWorld) {
            return false;
        }
        if (isWarZoneWorld) {
            return !this.protectionConfig.shouldProtectWarzoneFromPlayers();
        }
        if (!optionalChunkFaction.isPresent()) {
            return true;
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.isSafeZone()) {
            return false;
        }
        if (chunkFaction.isWarZone()) {
            return !this.protectionConfig.shouldProtectWarzoneFromPlayers();
        }
        if (!optionalAttackerPlayerFaction.isPresent()) {
            return false;
        }
        Faction attackerFaction = optionalAttackerPlayerFaction.get();
        return this.permsManager.canBreakBlock(player.getUniqueId(), attackerFaction, chunkFaction);
    }

    @Override
    public boolean isItemWhitelisted(String itemId) {
        Set<String> whiteListedItems = this.protectionConfig.getWhiteListedItems();
        return this.isWhiteListed(whiteListedItems, itemId);
    }

    @Override
    public boolean isBlockWhitelistedForInteraction(String blockId) {
        Set<String> whiteListedBlocks = this.protectionConfig.getWhiteListedInteractBlocks();
        return this.isWhiteListed(whiteListedBlocks, blockId);
    }

    @Override
    public boolean isBlockWhitelistedForPlaceDestroy(String blockOrItemId) {
        Set<String> whiteListedBlocks = this.protectionConfig.getWhiteListedPlaceDestroyBlocks();
        return this.isWhiteListed(whiteListedBlocks, blockOrItemId);
    }

    private boolean isWhiteListed(Collection<String> collection, String itemId) {
        for (String whiteListedItemId : collection) {
            if (whiteListedItemId.equals(itemId)) {
                return true;
            }
            try {
                Pattern pattern = Pattern.compile(whiteListedItemId);
                if (!pattern.matcher(itemId).matches()) continue;
                return true;
            }
            catch (PatternSyntaxException patternSyntaxException) {
            }
        }
        return false;
    }

    private boolean isHoldingEagleFeather(User user) {
        return user.getItemInHand(HandTypes.MAIN_HAND).isPresent() && ((ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get()).getType() == ItemTypes.FEATHER && ((ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get()).get(Keys.DISPLAY_NAME).isPresent() && ((Text)((ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get()).get(Keys.DISPLAY_NAME).get()).equals((Object)EagleFeather.getDisplayName());
    }

    private void removeEagleFeather(User user) {
        ItemStack feather = (ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get();
        feather.setQuantity(feather.getQuantity() - 1);
        user.getPlayer().ifPresent(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.DARK_PURPLE, "You have used eagle's feather!"})));
    }

    private void notifyPlayer(User user) {
        if (this.chatConfig.shouldDisplayProtectionSystemMessages()) {
            user.getPlayer().ifPresent(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_DONT_HAVE_ACCESS_TO_DO_THIS})));
        }
    }
}

