/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.file.hocon;

import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.entities.FactionPlayerImpl;
import io.github.aquerr.eaglefactions.common.storage.IPlayerStorage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;

public class HOCONPlayerStorage
implements IPlayerStorage {
    private Path playersDirectoryPath;

    public HOCONPlayerStorage(Path configDir) {
        try {
            this.playersDirectoryPath = configDir.resolve("players");
            if (!Files.exists(this.playersDirectoryPath, new LinkOption[0])) {
                Files.createDirectory(this.playersDirectoryPath, new FileAttribute[0]);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean checkIfPlayerExists(UUID playerUUID, String playerName) {
        Path playerFile = this.playersDirectoryPath.resolve(playerUUID.toString() + ".conf");
        return Files.exists(playerFile, new LinkOption[0]);
    }

    @Override
    public boolean addPlayer(UUID playerUUID, String playerName, float startingPower, float maxPower) {
        Path playerFile = this.playersDirectoryPath.resolve(playerUUID.toString() + ".conf");
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(playerFile)).build();
        try {
            ConfigurationNode configurationNode = configurationLoader.load();
            configurationNode.getNode(new Object[]{"name"}).setValue((Object)playerName);
            configurationNode.getNode(new Object[]{"power"}).setValue((Object)Float.valueOf(startingPower));
            configurationNode.getNode(new Object[]{"maxpower"}).setValue((Object)Float.valueOf(maxPower));
            configurationNode.getNode(new Object[]{"death-in-warzone"}).setValue((Object)false);
            configurationLoader.save(configurationNode);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setDeathInWarzone(UUID playerUUID, boolean didDieInWarZone) {
        Path playerFile = this.playersDirectoryPath.resolve(playerUUID.toString() + ".conf");
        if (!Files.exists(playerFile, new LinkOption[0])) {
            return false;
        }
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(playerFile)).build();
        try {
            ConfigurationNode configurationNode = configurationLoader.load();
            configurationNode.getNode(new Object[]{"death-in-warzone"}).setValue((Object)didDieInWarZone);
            configurationLoader.save(configurationNode);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean getLastDeathInWarzone(UUID playerUUID) {
        Path playerFile = this.playersDirectoryPath.resolve(playerUUID.toString() + ".conf");
        if (!Files.exists(playerFile, new LinkOption[0])) {
            return false;
        }
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(playerFile)).build();
        try {
            ConfigurationNode configurationNode = configurationLoader.load();
            return configurationNode.getNode(new Object[]{"death-in-warzone"}).getBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public float getPlayerPower(UUID playerUUID) {
        Path playerFile = this.playersDirectoryPath.resolve(playerUUID.toString() + ".conf");
        if (!Files.exists(playerFile, new LinkOption[0])) {
            return 0.0f;
        }
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(playerFile)).build();
        try {
            ConfigurationNode configurationNode = configurationLoader.load();
            return configurationNode.getNode(new Object[]{"power"}).getFloat(0.0f);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    @Override
    public boolean setPlayerPower(UUID playerUUID, float power) {
        Path playerFile = this.playersDirectoryPath.resolve(playerUUID.toString() + ".conf");
        if (!Files.exists(playerFile, new LinkOption[0])) {
            return false;
        }
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(playerFile)).build();
        try {
            ConfigurationNode configurationNode = configurationLoader.load();
            configurationNode.getNode(new Object[]{"power"}).setValue((Object)Float.valueOf(power));
            configurationLoader.save(configurationNode);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public float getPlayerMaxPower(UUID playerUUID) {
        Path playerFile = this.playersDirectoryPath.resolve(playerUUID.toString() + ".conf");
        if (!Files.exists(playerFile, new LinkOption[0])) {
            return 0.0f;
        }
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(playerFile)).build();
        try {
            ConfigurationNode configurationNode = configurationLoader.load();
            return configurationNode.getNode(new Object[]{"maxpower"}).getFloat(0.0f);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    @Override
    public boolean setPlayerMaxPower(UUID playerUUID, float maxpower) {
        Path playerFile = this.playersDirectoryPath.resolve(playerUUID.toString() + ".conf");
        if (!Files.exists(playerFile, new LinkOption[0])) {
            return false;
        }
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(playerFile)).build();
        try {
            ConfigurationNode configurationNode = configurationLoader.load();
            configurationNode.getNode(new Object[]{"maxpower"}).setValue((Object)Float.valueOf(maxpower));
            configurationLoader.save(configurationNode);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Set<String> getServerPlayerNames() {
        File[] playerFiles;
        HashSet<String> playerSet = new HashSet<String>();
        File playerDir = new File(this.playersDirectoryPath.toUri());
        for (File playerFile : playerFiles = playerDir.listFiles()) {
            HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(playerFile.toPath())).build();
            try {
                ConfigurationNode configurationNode = configurationLoader.load();
                playerSet.add(configurationNode.getNode(new Object[]{"name"}).getString(""));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return playerSet;
    }

    @Override
    public Set<FactionPlayer> getServerPlayers() {
        File[] playerFiles;
        HashSet<FactionPlayer> playerSet = new HashSet<FactionPlayer>();
        File playerDir = new File(this.playersDirectoryPath.toUri());
        for (File playerFile : playerFiles = playerDir.listFiles()) {
            HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(playerFile.toPath())).build();
            try {
                UUID playerUUID;
                ConfigurationNode configurationNode = configurationLoader.load();
                String playerName = configurationNode.getNode(new Object[]{"name"}).getString("");
                try {
                    playerUUID = UUID.fromString(playerFile.getName().substring(0, playerFile.getName().indexOf(46)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Files.delete(playerFile.toPath());
                    continue;
                }
                String factionName = configurationNode.getNode(new Object[]{"faction"}).getString("");
                String factionMemberTypeString = configurationNode.getNode(new Object[]{"faction-member-type"}).getString("");
                FactionMemberType factionMemberType = null;
                if (!factionMemberTypeString.equals("")) {
                    factionMemberType = FactionMemberType.valueOf(factionMemberTypeString);
                }
                FactionPlayerImpl factionPlayer = new FactionPlayerImpl(playerName, playerUUID, factionName, factionMemberType);
                playerSet.add(factionPlayer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return playerSet;
    }

    @Override
    public String getPlayerName(UUID playerUUID) {
        Path playerFile = this.playersDirectoryPath.resolve(playerUUID.toString() + ".conf");
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(playerFile)).build();
        try {
            ConfigurationNode configurationNode = configurationLoader.load();
            return configurationNode.getNode(new Object[]{"name"}).getString("");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public boolean updatePlayerName(UUID playerUUID, String playerName) {
        String oldPlayerName;
        Path playerFile = this.playersDirectoryPath.resolve(playerUUID.toString() + ".conf");
        if (!Files.exists(playerFile, new LinkOption[0])) {
            return false;
        }
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(playerFile)).build();
        ConfigurationNode configurationNode = null;
        try {
            configurationNode = configurationLoader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object playerNameInFile = configurationNode.getNode(new Object[]{"name"}).getValue();
        if (playerNameInFile != null && !(oldPlayerName = (String)playerNameInFile).equals(playerName)) {
            configurationNode.getNode(new Object[]{"name"}).setValue((Object)playerName);
            try {
                configurationLoader.save(configurationNode);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

