/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.container;

import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerTileComponent;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.slots.SlotBase;
import ic2.core.inventory.slots.SlotOutput;
import ic2.core.util.misc.StackUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.tileentity.TileEntityAutocraftingTable;
import trinsdar.ic2c_extras.util.StackHelper;

public class ContainerAutocraftingTable
extends ContainerTileComponent<TileEntityAutocraftingTable> {
    private InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 3, 3);
    private InventoryCraftResult craftResult = new InventoryCraftResult();
    private final World world;
    private final EntityPlayer player;
    TileEntityAutocraftingTable block;

    public ContainerAutocraftingTable(InventoryPlayer player, TileEntityAutocraftingTable tile) {
        super((IHasGui)tile);
        this.block = tile;
        this.world = player.field_70458_d.func_130014_f_();
        this.player = player.field_70458_d;
        this.func_75146_a((Slot)new SlotCrafting(this.player, this.craftMatrix, (IInventory)this.craftResult, 0, 143, 5));
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                this.func_75146_a((Slot)new SlotBase((IHasInventory)tile, k + l * 3 + 1, 8 + l * 18, 5 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.func_75146_a((Slot)new SlotOutput(player.field_70458_d, (IHasInventory)tile, l + 10, 8 + l * 18, 60));
        }
        this.func_75146_a((Slot)new SlotOutput(player.field_70458_d, (IHasInventory)tile, 19, 143, 41));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, 0 + (j + i * 3), 64 + j * 17, 6 + i * 17));
            }
        }
        this.addPlayerInventory(player, 0, 0);
        this.readTileCraftingList();
    }

    @SideOnly(value=Side.CLIENT)
    public void onGuiLoaded(GuiIC2 gui) {
        gui.disableName();
        gui.dissableInvName();
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.func_192389_a(this.world, this.player, this.craftMatrix, this.craftResult);
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (clickTypeIn == ClickType.QUICK_MOVE && (slotId <= 9 || slotId >= 20)) {
            return ItemStack.field_190927_a;
        }
        if (slotId == 0) {
            return ItemStack.field_190927_a;
        }
        if (ContainerAutocraftingTable.within(slotId, 20, 28)) {
            ItemStack stack = player.field_71071_by.func_70445_o();
            this.craftMatrix.func_70299_a(slotId - 20, this.doWeirdStackCraftingStuff(stack, slotId));
            this.writeTileCraftingList();
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public static boolean within(int value, int low, int high) {
        return value >= low && value <= high;
    }

    public ItemStack doWeirdStackCraftingStuff(ItemStack stack, int slotId) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack slotStack = this.craftMatrix.func_70301_a(slotId - 20);
        if (StackHelper.isEqual(stack, slotStack) && slotStack.func_190916_E() < slotStack.func_77976_d()) {
            return StackUtil.copyWithSize((ItemStack)slotStack, (int)(slotStack.func_190916_E() + 1));
        }
        return StackUtil.copyWithSize((ItemStack)stack, (int)1);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.writeTileCraftingList();
    }

    public void writeTileCraftingList() {
        this.block.craftingList.clear();
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack mSlot = this.craftMatrix.func_70301_a(i);
            this.block.craftingList.set(i, (Object)mSlot);
        }
        this.block.target = this.craftResult.func_70301_a(0);
    }

    public void readTileCraftingList() {
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack mSlot = (ItemStack)this.block.craftingList.get(i);
            this.craftMatrix.func_70299_a(i, mSlot);
        }
    }

    public ResourceLocation getTexture() {
        return ((TileEntityAutocraftingTable)((Object)this.getGuiHolder())).getGuiTexture();
    }

    public boolean func_75145_c(EntityPlayer player) {
        return ((TileEntityAutocraftingTable)((Object)this.getGuiHolder())).canInteractWith(player);
    }

    public int guiInventorySize() {
        return ((TileEntityAutocraftingTable)((Object)this.getGuiHolder())).slotCount;
    }
}

