/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.guicomponent;

import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.util.math.Box2D;
import ic2.core.util.math.Vec2i;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.tileentity.TileEntityThermalCentrifuge;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;

public class MachineHeatComp
extends GuiComponent {
    TileEntityThermalCentrifuge block;
    Vec2i texPos;

    public MachineHeatComp(TileEntityThermalCentrifuge tile, Box2D box, Vec2i pos) {
        super(box);
        this.block = tile;
        this.texPos = pos;
    }

    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.ToolTip);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        float heat = this.block.getHeat();
        if (heat > 0.0f) {
            Box2D box;
            int maxX;
            int lvl;
            int x = gui.getXOffset();
            int y = gui.getYOffset();
            float per = heat / (float)this.block.maxHeat;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * (float)(maxX = (box = this.getPosition()).getLenght()))) <= 0) {
                return;
            }
            gui.func_73729_b(x + box.getX(), y + box.getY(), this.texPos.getX(), this.texPos.getY(), lvl, box.getHeight());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (this.isMouseOver(mouseX, mouseY) && PlayerHandler.getClientPlayerHandler().hasEUReader()) {
            tooltips.add(Ic2cExtrasLang.heat.getLocalizedFormatted(new Object[]{Float.valueOf(this.block.getHeat()), this.block.maxHeat}));
        }
    }
}

