/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjc.core;

import com.gmail.trentech.pjc.Main;
import com.gmail.trentech.pjc.core.ConfigManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.sql.SqlService;

public class SQLManager {
    private static ConcurrentHashMap<String, SQLManager> sqlManagers = new ConcurrentHashMap();
    private PluginContainer plugin;
    private String database;
    private boolean mySql;
    private String url;
    private String prefix;
    private String username;
    private String password;

    private SQLManager(PluginContainer plugin) {
        this.plugin = plugin;
        this.initSettings();
    }

    public void initSettings() {
        ConfigManager configManager = ConfigManager.get(this.plugin);
        CommentedConfigurationNode config = configManager.getConfig();
        CommentedConfigurationNode defaultConfig = ConfigManager.get(Main.getPlugin()).getConfig();
        this.mySql = config.getNode(new Object[]{"settings", "sql", "enable"}).isVirtual() ? config.getNode(new Object[]{"settings", "sql", "enable"}).setValue((Object)defaultConfig.getNode(new Object[]{"settings", "sql", "enable"}).getBoolean()).getBoolean() : config.getNode(new Object[]{"settings", "sql", "enable"}).getBoolean();
        this.prefix = config.getNode(new Object[]{"settings", "sql", "prefix"}).isVirtual() ? config.getNode(new Object[]{"settings", "sql", "prefix"}).setValue((Object)defaultConfig.getNode(new Object[]{"settings", "sql", "prefix"}).getString()).getString() : config.getNode(new Object[]{"settings", "sql", "prefix"}).getString();
        this.url = config.getNode(new Object[]{"settings", "sql", "url"}).isVirtual() ? config.getNode(new Object[]{"settings", "sql", "url"}).setValue((Object)defaultConfig.getNode(new Object[]{"settings", "sql", "url"}).getString()).getString() : config.getNode(new Object[]{"settings", "sql", "url"}).getString();
        this.username = config.getNode(new Object[]{"settings", "sql", "username"}).isVirtual() ? config.getNode(new Object[]{"settings", "sql", "username"}).setValue((Object)defaultConfig.getNode(new Object[]{"settings", "sql", "username"}).getString()).getString() : config.getNode(new Object[]{"settings", "sql", "username"}).getString();
        this.password = config.getNode(new Object[]{"settings", "sql", "password"}).isVirtual() ? config.getNode(new Object[]{"settings", "sql", "password"}).setValue((Object)defaultConfig.getNode(new Object[]{"settings", "sql", "password"}).getString()).getString() : config.getNode(new Object[]{"settings", "sql", "password"}).getString();
        this.database = config.getNode(new Object[]{"settings", "sql", "database"}).isVirtual() ? config.getNode(new Object[]{"settings", "sql", "database"}).setValue((Object)this.plugin.getId()).getString() : config.getNode(new Object[]{"settings", "sql", "database"}).getString();
        configManager.save();
    }

    public static SQLManager get(PluginContainer plugin) {
        if (!sqlManagers.containsKey(plugin.getId())) {
            SQLManager sqlManager = new SQLManager(plugin);
            sqlManagers.put(plugin.getId(), sqlManager);
        }
        return sqlManagers.get(plugin.getId());
    }

    public DataSource getDataSource() throws SQLException {
        SqlService sqlService = (SqlService)Sponge.getServiceManager().provide(SqlService.class).get();
        if (this.mySql) {
            Connection connection = sqlService.getDataSource("jdbc:mysql://" + this.url + "/?user=" + this.username + "&password=" + this.password).getConnection();
            PreparedStatement statement = connection.prepareStatement("CREATE DATABASE IF NOT EXISTS " + this.database);
            statement.executeUpdate();
            connection.close();
            return sqlService.getDataSource("jdbc:mysql://" + this.url + "/" + this.database + "?user=" + this.username + "&password=" + this.password);
        }
        return sqlService.getDataSource("jdbc:h2:./config/" + this.plugin.getId() + "/" + this.database);
    }

    public String getPrefix(String table) {
        if (!this.prefix.equalsIgnoreCase("NONE") && this.mySql) {
            return ("`" + this.prefix + table + "`").toUpperCase();
        }
        return ("`" + table + "`").toUpperCase();
    }

    public String stripPrefix(String table) {
        if (!this.prefix.equalsIgnoreCase("NONE") && this.mySql) {
            return table.toUpperCase().replace(this.prefix.toUpperCase(), "").toUpperCase();
        }
        return table.toUpperCase();
    }
}

