/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui.materiallist;

import com.direwolf20.buildinggadgets.client.gui.materiallist.MaterialListGUI;
import com.direwolf20.buildinggadgets.client.util.AlignmentUtil;
import com.direwolf20.buildinggadgets.client.util.RenderUtil;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.GuiScrollingList;

class ScrollingMaterialList
extends GuiScrollingList {
    static final int MARGIN = 2;
    static final int ENTRY_HEIGHT = Math.max(22, RenderUtil.getFontRenderer().field_78288_b * 2 + 6);
    static final int TOP = 24;
    static final int BOTTOM = 32;
    static final int LINE_SIDE_MARGIN = 8;
    private MaterialListGUI parent;

    public ScrollingMaterialList(MaterialListGUI parent, int width, int height) {
        super(Minecraft.func_71410_x(), parent.getWindowWidth(), height, parent.getWindowTopY() + 24, parent.getWindowBottomY() - 32, parent.getWindowLeftX(), ENTRY_HEIGHT, parent.field_146294_l, parent.field_146295_m);
        this.parent = parent;
    }

    protected int getSize() {
        return this.parent.getMaterials().size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.selectedIndex = index;
    }

    protected boolean isSelected(int slotIndex) {
        return false;
    }

    protected void drawBackground() {
    }

    protected void drawSlot(int index, int rightIn, int top, int entryHeight, Tessellator tess) {
        ItemStack item = this.parent.getMaterials().get(index);
        int right = rightIn - 2;
        int bottom = top + entryHeight;
        int slotX = this.left + 2;
        int slotY = top + 2;
        this.drawIcon(item, slotX, slotY);
        this.drawTextOverlay(index, right, top, item, bottom, slotX);
        this.drawHoveringText(item, slotX, slotY);
    }

    private void drawTextOverlay(int index, int right, int top, ItemStack item, int bottom, int slotX) {
        String itemName = item.func_82833_r();
        int itemNameX = slotX + 18 + 2;
        RenderUtil.renderTextVerticalCenter(itemName, itemNameX, top, bottom - 1, Color.WHITE.getRGB());
        int required = item.func_190916_E();
        int available = MathHelper.func_76125_a((int)this.parent.getAvailable().getInt(index), (int)0, (int)required);
        boolean fulfilled = available == required;
        int color = fulfilled ? Color.GREEN.getRGB() : Color.RED.getRGB();
        String amount = I18n.func_135052_a((String)"gui.buildinggadgets.materialList.text.statusTemplate", (Object[])new Object[]{available, required});
        RenderUtil.renderTextHorizontalRight(amount, right, AlignmentUtil.getYForAlignedCenter(RenderUtil.getFontRenderer().field_78288_b, top, bottom), color);
        int widthItemName = Minecraft.func_71410_x().field_71466_p.func_78256_a(itemName);
        int widthAmount = Minecraft.func_71410_x().field_71466_p.func_78256_a(amount);
        this.drawGuidingLine(index, right, top, bottom, itemNameX, widthItemName, widthAmount);
    }

    private void drawGuidingLine(int index, int right, int top, int bottom, int itemNameX, int widthItemName, int widthAmount) {
        if (!this.isSelected(index)) {
            int lineXStart = itemNameX + widthItemName + 8;
            int lineXEnd = right - widthAmount - 8;
            int lineY = AlignmentUtil.getYForAlignedCenter(1, top, bottom) - 1;
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            this.parent.func_73730_a(lineXStart, lineXEnd, lineY, 0x22FFFFFF);
        }
    }

    private void drawHoveringText(ItemStack item, int slotX, int slotY) {
        if (this.mouseX > slotX && this.mouseY > slotY && this.mouseX <= slotX + 18 && this.mouseY <= slotY + 18) {
            this.parent.setTaskHoveringText(this.mouseX, this.mouseY, this.parent.func_191927_a(item));
        }
    }

    private void drawIcon(ItemStack item, int slotX, int slotY) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        Minecraft.func_71410_x().func_175599_af().func_180450_b(item, slotX, slotY);
        GlStateManager.func_179140_f();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

