/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.hooklib.minecraft;

import galaxyspace.core.hooklib.asm.AsmHook;
import galaxyspace.core.hooklib.asm.ClassMetadataReader;
import galaxyspace.core.hooklib.asm.HookClassTransformer;
import galaxyspace.core.hooklib.minecraft.DeobfuscationMetadataReader;
import galaxyspace.core.hooklib.minecraft.HookLibPlugin;
import galaxyspace.core.hooklib.minecraft.MinecraftClassTransformer;
import galaxyspace.core.hooklib.minecraft.PrimaryClassTransformer;
import java.util.Map;
import net.minecraftforge.fml.common.asm.transformers.DeobfuscationTransformer;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;

public abstract class HookLoader
implements IFMLLoadingPlugin {
    private static DeobfuscationTransformer deobfuscationTransformer;
    private static ClassMetadataReader deobfuscationMetadataReader;

    static DeobfuscationTransformer getDeobfuscationTransformer() {
        if (HookLibPlugin.getObfuscated() && deobfuscationTransformer == null) {
            deobfuscationTransformer = new DeobfuscationTransformer();
        }
        return deobfuscationTransformer;
    }

    public static HookClassTransformer getTransformer() {
        return PrimaryClassTransformer.instance.registeredSecondTransformer ? MinecraftClassTransformer.instance : PrimaryClassTransformer.instance;
    }

    public static void registerHook(AsmHook hook) {
        HookLoader.getTransformer().registerHook(hook);
    }

    public static void registerHookContainer(String className) {
        HookLoader.getTransformer().registerHookContainer(className);
    }

    public static ClassMetadataReader getDeobfuscationMetadataReader() {
        return deobfuscationMetadataReader;
    }

    public String[] getLibraryRequestClass() {
        return null;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        this.registerHooks();
    }

    protected abstract void registerHooks();

    static {
        deobfuscationMetadataReader = new DeobfuscationMetadataReader();
    }
}

