/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon;

import asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart.DungeonConfiguration;
import galaxyspace.GalaxySpace;
import galaxyspace.core.prefab.blocks.DungeonBlocks;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.DirectionalPieceIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.DungeonStartIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.PieceIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.SizedPieceIo;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class RoomEntranceIo
extends SizedPieceIo {
    private static int range = 18;
    private EnumFacing exitDirection;

    public RoomEntranceIo() {
    }

    public RoomEntranceIo(World world, DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ) {
        super(configuration, range, rand.nextInt(2) + 15, range, EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = new StructureBoundingBox(blockPosX - range, configuration.getYPosition() - 5, blockPosZ - range, blockPosX + range - 1, 150, blockPosZ + range);
        GalaxySpace.debug(blockPosX + " | " + blockPosZ);
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        int i;
        int maxLevel = 0;
        for (int i2 = -range; i2 <= range; ++i2) {
            for (int k = -range; k <= range; ++k) {
                Block block;
                int j = this.field_74887_e.func_78882_c();
                while (j >= 0 && (Blocks.field_150350_a == (block = this.func_175807_a(worldIn, i2 + range, --j, k + range, this.field_74887_e).func_177230_c()) || block == null)) {
                }
                maxLevel = Math.max(maxLevel, j + 3);
            }
        }
        int startX = range - this.sizeX / 2;
        int startZ = range - this.sizeZ / 2;
        int endX = range + this.sizeX / 2;
        int endZ = range + this.sizeZ / 2;
        for (i = startX; i <= endX; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                block17: for (int k = startZ; k <= endZ; ++k) {
                    if (!(j != this.sizeY || i != startX + 3 && i != endX - 3 || k != startZ + 3 && k != endZ - 3)) {
                        this.func_175811_a(worldIn, Blocks.field_150356_k.func_176223_P(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    if (i == startX || i == endX || j == 0 || j == 5 || j == this.sizeY || k == startZ || k == endZ) {
                        if (j == this.sizeY) {
                            if (this.configuration.getOtherBlock(false) == null) continue;
                            this.func_175811_a(worldIn, this.configuration.getOtherBlock(false), i, j, k, this.field_74887_e);
                            continue;
                        }
                        if (j == 0) {
                            this.func_175811_a(worldIn, Blocks.field_150353_l.func_176223_P(), i, j, k, this.field_74887_e);
                            continue;
                        }
                        if (j >= 5 && j <= 9 && this.configuration.getOtherBlock(true) != null) {
                            int l = 5;
                            if (j == 5) {
                                if (i > startX + 3 && i < endX - 3 && k > startZ + 3 && k < endZ - 3) {
                                    this.func_175811_a(worldIn, this.configuration.getOtherBlock(true), i, j, k, this.field_74887_e);
                                } else if (i != startX && i != endX && k != startZ && k != endZ) {
                                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                                } else {
                                    this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                                }
                                switch (this.exitDirection) {
                                    case EAST: {
                                        if (k <= startZ + l || k >= endZ - l || i >= endX - l) continue block17;
                                        this.func_175811_a(worldIn, this.configuration.getOtherBlock(true), i, j, k, this.field_74887_e);
                                        break;
                                    }
                                    case NORTH: {
                                        if (i <= startX + l || i >= endX - l || k <= endZ - l) continue block17;
                                        this.func_175811_a(worldIn, this.configuration.getOtherBlock(true), i, j, k, this.field_74887_e);
                                        break;
                                    }
                                    case SOUTH: {
                                        if (i <= startX + l || i >= endX - l || k >= endZ - l) continue block17;
                                        this.func_175811_a(worldIn, this.configuration.getOtherBlock(true), i, j, k, this.field_74887_e);
                                        break;
                                    }
                                    case WEST: {
                                        if (k <= startZ + l || k >= endZ - l || i <= endX - l) continue block17;
                                        this.func_175811_a(worldIn, this.configuration.getOtherBlock(true), i, j, k, this.field_74887_e);
                                        break;
                                    }
                                }
                                continue;
                            }
                            this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                            switch (this.exitDirection) {
                                case EAST: {
                                    if (k <= startZ + l || k >= endZ - l || i >= endX - l) break;
                                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                                    break;
                                }
                                case NORTH: {
                                    if (i <= startX + l || i >= endX - l || k <= endZ - l) break;
                                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                                    break;
                                }
                                case SOUTH: {
                                    if (i <= startX + l || i >= endX - l || k >= endZ - l) break;
                                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                                    break;
                                }
                                case WEST: {
                                    if (k <= startZ + l || k >= endZ - l || i <= endX - l) break;
                                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                                    break;
                                }
                            }
                            continue;
                        }
                        if (j == 1) {
                            this.func_175811_a(worldIn, GSBlocks.DUNGEON_BLOCKS.func_176223_P().func_177226_a(DungeonBlocks.BASIC_TYPE, (Comparable)((Object)DungeonBlocks.EnumDungeonBlocks.IO_BRICKS)), i, j, k, this.field_74887_e);
                            continue;
                        }
                        if (j >= 2 && j <= 4 && worldIn.field_73012_v.nextInt(10) > 4) {
                            this.func_175811_a(worldIn, GSBlocks.DUNGEON_BLOCKS.func_176223_P().func_177226_a(DungeonBlocks.BASIC_TYPE, (Comparable)((Object)DungeonBlocks.EnumDungeonBlocks.IO_BRICKS)), i, j, k, this.field_74887_e);
                            continue;
                        }
                        this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                }
            }
        }
        for (i = -range; i < range; ++i) {
            for (int k = -range; k < range; ++k) {
                double xDev = (double)i / 20.0;
                double zDev = (double)k / 20.0;
                double distance = xDev * xDev + zDev * zDev;
                int depth = (int)Math.abs(0.5 / (distance * 2.0 + 1.0E-5));
                int helper = 0;
                for (int j = maxLevel; j > 5 && helper <= depth; --j) {
                    IBlockState block1 = this.func_175807_a(worldIn, i + range, j, k + range, this.field_74887_e);
                    if (block1 != this.configuration.getBrickBlock() && block1 != this.configuration.getOtherBlock(false) && j == this.sizeY && j == 5) continue;
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i + range, j, k + range, this.field_74887_e);
                    ++helper;
                }
            }
        }
        return true;
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        if (this.exitDirection != null) {
            tagCompound.func_74768_a("direction_exit", this.exitDirection.ordinal());
        }
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager manager) {
        super.func_143011_b(tagCompound, manager);
        this.exitDirection = tagCompound.func_74764_b("direction_exit") ? EnumFacing.func_82600_a((int)tagCompound.func_74762_e("direction_exit")) : null;
    }

    @Override
    public PieceIo getNextPiece(DungeonStartIo startPiece, Random rand) {
        if (startPiece.attachedComponents.isEmpty()) {
            DirectionalPieceIo corridor = (DirectionalPieceIo)this.getCorridor(rand, startPiece, 20, false, 12);
            this.exitDirection = corridor == null ? null : corridor.getDirection().func_176734_d();
            return corridor;
        }
        return null;
    }

    @Override
    protected StructureBoundingBox getExtension(EnumFacing direction, int length, int width) {
        int blockZ;
        int blockX;
        int sizeZ;
        int sizeX;
        int startX = this.field_74887_e.field_78897_a + range - this.sizeX / 2;
        int startZ = this.field_74887_e.field_78896_c + range - this.sizeZ / 2;
        int endX = this.field_74887_e.field_78897_a + range + this.sizeX / 2;
        int endZ = this.field_74887_e.field_78896_c + range + this.sizeZ / 2;
        switch (direction) {
            case NORTH: {
                sizeX = width;
                sizeZ = length;
                blockX = startX + (endX - startX) / 2 - sizeX / 2;
                blockZ = startZ - sizeZ;
                break;
            }
            case EAST: {
                sizeX = length;
                sizeZ = width;
                blockX = endX;
                blockZ = startZ + (endZ - startZ) / 2 - sizeZ / 2;
                break;
            }
            case SOUTH: {
                sizeX = width;
                sizeZ = length;
                blockX = startX + (endX - startX) / 2 - sizeX / 2;
                blockZ = endZ;
                break;
            }
            default: {
                sizeX = length;
                sizeZ = width;
                blockX = startX - sizeX;
                blockZ = startZ + (endZ - startZ) / 2 - sizeZ / 2;
            }
        }
        return new StructureBoundingBox(blockX, blockZ, blockX + sizeX, blockZ + sizeZ);
    }
}

