/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.BoundingBox;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.structure.StructureManager;

public class ListSaveZonesSubCommand
extends BasePregenCommand {
    public ListSaveZonesSubCommand() {
        super(2);
        this.addDescription(0, "Dimension: The Dimension that needs to be checkt");
        this.addDescription(1, "Type: The Structure that should be checkt for");
        this.addSuggestion("ListSaveZones 0 Village", "Lists all the Villages in the Overworld");
        this.addSuggestion("ListSaveZones -1 Fortress", "Lists all the Fortresses in the Nether");
    }

    @Override
    public String getName() {
        return "ListSaveZones";
    }

    @Override
    public String getDescription() {
        return "Lists all the SaveZones that exist";
    }

    @Override
    public int getRequiredParameterCount() {
        return 2;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (args.length >= 2) {
            int dimension = ListSaveZonesSubCommand.getDimension(container, args[0]);
            String type = args[1];
            if (!ListSaveZonesSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            if (type.equalsIgnoreCase("All")) {
                container.sendChatMessage("All SaveZones for Dimension " + dimension);
                for (Map.Entry<String, List<BoundingBox>> boxes : StructureManager.instance.getBoxes(dimension).entrySet()) {
                    container.sendChatMessage("Structure: " + boxes.getKey());
                    for (BoundingBox box : boxes.getValue()) {
                        container.sendChatMessage("Box At: [X: " + new FilePos(box.getCenterX(), box.getCenterZ()) + "], with a Chunk Radius of: " + box.getRadius() + " Chunks");
                    }
                }
            } else {
                if (!StructureManager.instance.validateType(dimension, type)) {
                    container.sendChatMessage("Type: " + type + " doesn't exist in Dimension " + dimension);
                    return;
                }
                container.sendChatMessage("Structure " + type + " for Dimension " + dimension);
                for (BoundingBox box : StructureManager.instance.getBoxes(dimension, type)) {
                    container.sendChatMessage("Box At: [X: " + new FilePos(box.getCenterX(), box.getCenterZ()) + "], with a Chunk Radius of: " + box.getRadius() + " Chunks");
                }
            }
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return ListSaveZonesSubCommand.getBestMatch(args, CompleterHelper.STRUCTURE_DIMENSION);
        }
        if (commandIndex == 1) {
            return ListSaveZonesSubCommand.getBestMatch(args, CompleterHelper.getStructures(ListSaveZonesSubCommand.parseNumber(args[argLayer - 1], 0), true));
        }
        return new ArrayList<String>();
    }
}

