/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraftforge.fml.common.FMLLog;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.ProcessResult;
import pregenerator.impl.processor.ChunkProcess;
import pregenerator.impl.retrogen.RetrogenHandler;

public class ChunkFile {
    public static final byte STATE_TERRAIN_ONLY = 0;
    public static final byte STATE_TERRAIN_AND_POST = 1;
    public static final byte STATE_POST_ONLY = 2;
    private File chunkFile;
    private ChunkProcess process;
    private RegionFile region;
    private Set<FilePos> toProcess = new LinkedHashSet<FilePos>();
    private boolean requireSave = false;

    public ChunkFile(ChunkProcess progress, FilePos pos) {
        this.process = progress;
        this.chunkFile = new File(progress.worldFile, "r." + pos.x + "." + pos.z + ".mca");
    }

    private RegionFile getRegionFile() {
        if (this.region == null) {
            this.region = this.process.getFile(this.chunkFile);
        } else {
            int i = this.process.isFileValid(this.chunkFile);
            if (i > 0) {
                return i > 1 ? (this.region = null) : (this.region = this.process.getFile(this.chunkFile));
            }
        }
        return this.region;
    }

    public ProcessResult isChunkCreated(FilePos pos) {
        if (this.process.getProvider().func_73149_a(pos.x, pos.z)) {
            return ProcessResult.SUCCESS;
        }
        RegionFile file = this.getRegionFile();
        if (file == null) {
            return ProcessResult.CRASH;
        }
        return file.chunkExists(pos.x & 0x1F, pos.z & 0x1F) ? ProcessResult.SUCCESS : ProcessResult.MISSING;
    }

    public boolean isChunkLoaded(FilePos pos) {
        return this.process.getHelper().containsChunk(FilePos.asLong(pos.x, pos.z));
    }

    public Chunk loadChunk(FilePos pos) {
        return this.process.getHelper().loadChunk(pos.x, pos.z);
    }

    public Chunk createChunk(FilePos pos, boolean disablePost, boolean post) {
        return this.process.getHelper().createChunk(pos.x, pos.z, disablePost, post);
    }

    public void unloadChunk(Chunk chunk) {
        this.process.unloadChunk(chunk);
    }

    public boolean populate(Chunk chunk) {
        try {
            chunk.func_186030_a((IChunkProvider)this.process.getProvider(), this.process.getProvider().field_186029_c);
            return true;
        }
        catch (Exception e) {
            FMLLog.getLogger().info("Chunk Gen crash happend. No worry the Chunk gets skipped!");
            e.printStackTrace();
            return false;
        }
    }

    public boolean retrogen(Chunk chunk) {
        return RetrogenHandler.INSTANCE.retrogenChunk(chunk, this.process.getProvider().field_186029_c, (IChunkProvider)this.process.getProvider());
    }

    public void onProcessed(ChunkFileEntry entry, boolean needsSaving) {
        this.toProcess.remove(entry.chunkPos);
        this.requireSave |= needsSaving;
        if (this.toProcess.isEmpty()) {
            this.process.unloadChunks();
            this.region = null;
            this.process.removeFiles();
            if (this.process.world.field_72996_f.size() >= 5000) {
                int old = this.process.world.field_72996_f.size();
                int count = 0;
                for (Entity entity : new ArrayList(this.process.world.field_72996_f)) {
                    if (this.process.getProvider().func_73149_a(entity.field_70176_ah, entity.field_70164_aj)) continue;
                    this.process.world.func_72973_f(entity);
                    ++count;
                }
                this.process.helper.clearUnloadedEntities();
            }
        }
        entry.clearChilds();
    }

    public static class ChunkFileEntry {
        ChunkFile file;
        FilePos chunkPos;
        byte requestedState;
        boolean changed = false;
        List<ChunkFileEntry> childs = new LinkedList<ChunkFileEntry>();

        public ChunkFileEntry(ChunkFile file, FilePos pos) {
            this.file = file;
            this.chunkPos = pos;
        }

        public void addChild(ChunkFileEntry child) {
            this.childs.add(child);
        }

        public void addToList() {
            this.file.toProcess.add(this.chunkPos);
        }

        public void setState(byte type) {
            this.requestedState = type;
        }

        public boolean isPostProcess() {
            return this.requestedState > 0 && this.requestedState != 3;
        }

        public boolean requiresChunkLoading() {
            return this.requestedState > 1 && this.requestedState != 3;
        }

        public boolean requiresChunkCreation() {
            return this.requestedState < 2 || this.requestedState == 3;
        }

        public boolean isRetrogen() {
            return this.requestedState == 4;
        }

        public boolean shouldDisablePost() {
            return this.requestedState == 3;
        }

        public boolean prepaireChilds() {
            for (ChunkFileEntry entry : this.childs) {
                if (entry.isPrepaired()) continue;
                return false;
            }
            return true;
        }

        public void clearChilds() {
            this.childs = null;
        }

        public boolean isPrepaired() {
            if (!this.file.isChunkLoaded(this.chunkPos)) {
                ProcessResult result = this.file.isChunkCreated(this.chunkPos);
                if (result == ProcessResult.CRASH) {
                    return false;
                }
                if (result == ProcessResult.SUCCESS) {
                    return this.file.loadChunk(this.chunkPos) != null;
                }
                if (result == ProcessResult.MISSING) {
                    if (this.requiresChunkCreation()) {
                        this.changed = true;
                        this.file.process.addReminder(this.chunkPos);
                        return this.file.createChunk(this.chunkPos, false, true) != null;
                    }
                    return false;
                }
            }
            return true;
        }

        public ProcessResult process() {
            ProcessResult result = this.file.isChunkCreated(this.chunkPos);
            if (result == ProcessResult.CRASH) {
                this.file.onProcessed(this, false);
                return ProcessResult.CRASH;
            }
            if (result == ProcessResult.MISSING) {
                if (!this.requiresChunkCreation()) {
                    this.file.onProcessed(this, false);
                    return ProcessResult.MISSING;
                }
                Chunk chunk = this.file.createChunk(this.chunkPos, this.shouldDisablePost(), this.isPostProcess());
                if (this.isPostProcess()) {
                    if (!this.prepaireChilds()) {
                        this.file.onProcessed(this, false);
                        return ProcessResult.MISSING;
                    }
                    if (!this.file.populate(chunk)) {
                        chunk.func_177446_d(false);
                        this.file.onProcessed(this, true);
                        this.file.unloadChunk(chunk);
                        return ProcessResult.CRASH;
                    }
                    this.file.onProcessed(this, true);
                    this.file.unloadChunk(chunk);
                    return chunk.func_177419_t() ? ProcessResult.SUCCESS : ProcessResult.MISSING;
                }
                this.file.onProcessed(this, false);
                this.file.unloadChunk(chunk);
                return ProcessResult.SUCCESS;
            }
            if (this.requiresChunkLoading() || this.changed) {
                if (!this.prepaireChilds()) {
                    this.file.onProcessed(this, false);
                    return ProcessResult.MISSING;
                }
                Chunk chunk = this.file.loadChunk(this.chunkPos);
                if (chunk == null) {
                    this.file.onProcessed(this, false);
                    return ProcessResult.CRASH;
                }
                if (chunk.func_177419_t()) {
                    if (this.isRetrogen()) {
                        boolean retrogen = this.file.retrogen(chunk);
                        this.file.unloadChunk(chunk);
                        this.file.onProcessed(this, false);
                        return retrogen ? ProcessResult.SUCCESS : ProcessResult.MISSING;
                    }
                    this.file.unloadChunk(chunk);
                    this.file.onProcessed(this, false);
                    return ProcessResult.MISSING;
                }
                if (!this.file.populate(chunk)) {
                    chunk.func_177446_d(false);
                    this.file.onProcessed(this, true);
                    this.file.unloadChunk(chunk);
                    return ProcessResult.CRASH;
                }
                this.file.onProcessed(this, true);
                this.file.unloadChunk(chunk);
                return chunk.func_177419_t() ? ProcessResult.SUCCESS : ProcessResult.MISSING;
            }
            this.file.onProcessed(this, false);
            return ProcessResult.SUCCESS;
        }

        public FilePos getPosition() {
            return this.chunkPos;
        }
    }
}

