/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.advancedsolars.blocks;

import ic2.core.item.block.ItemBlockRare;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import trinsdar.advancedsolars.util.AdvancedSolarLang;
import trinsdar.advancedsolars.util.Config;
import trinsdar.advancedsolars.util.Registry;

public class ItemBlockAdvancedSolarPanel
extends ItemBlockRare {
    public ItemBlockAdvancedSolarPanel(Block block) {
        super(block);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
        if (handler.hasEUReader()) {
            tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{this.getProduction()}));
            tooltip.add(AdvancedSolarLang.electricLowerProduction.getLocalizedFormatted(new Object[]{this.getLowerProduction()}));
            tooltip.add(AdvancedSolarLang.solarPanelTier.getLocalizedFormatted(new Object[]{this.getTier()}));
        }
    }

    private String getTier() {
        if (this.func_179223_d() == Registry.advancedSolarPanel) {
            return this.getTierFromOutput(Config.energyGeneratorSolarAdvanced * 16.0f);
        }
        if (this.func_179223_d() == Registry.hybridSolarPanel) {
            return this.getTierFromOutput(Config.energyGeneratorSolarHybrid * 128.0f);
        }
        if (this.func_179223_d() == Registry.ultimateHybridSolarPanel) {
            return this.getTierFromOutput(Config.energyGeneratorSolarUltimateHybrid * 1024.0f);
        }
        return "";
    }

    public String getTierFromOutput(float output) {
        if (output <= 8.0f) {
            return "ULV";
        }
        if (output <= 32.0f) {
            return "LV";
        }
        if (output <= 128.0f) {
            return "MV";
        }
        if (output <= 512.0f) {
            return "HV";
        }
        if (output <= 2048.0f) {
            return "EV";
        }
        if (output <= 8192.0f) {
            return "IV";
        }
        if (output <= 32768.0f) {
            return "LuV";
        }
        if (output <= 131072.0f) {
            return "ZPM";
        }
        return "UV";
    }

    private double getProduction() {
        if (this.func_179223_d() == Registry.advancedSolarPanel) {
            return (double)Config.energyGeneratorSolarAdvanced * 16.0;
        }
        if (this.func_179223_d() == Registry.hybridSolarPanel) {
            return (double)Config.energyGeneratorSolarHybrid * 128.0;
        }
        if (this.func_179223_d() == Registry.ultimateHybridSolarPanel) {
            return (double)Config.energyGeneratorSolarUltimateHybrid * 1024.0;
        }
        return 0.0;
    }

    private double getLowerProduction() {
        if (this.func_179223_d() == Registry.advancedSolarPanel) {
            return (double)Config.energyGeneratorSolarAdvanced * 2.0;
        }
        if (this.func_179223_d() == Registry.hybridSolarPanel) {
            return (double)Config.energyGeneratorSolarHybrid * 16.0;
        }
        if (this.func_179223_d() == Registry.ultimateHybridSolarPanel) {
            return (double)Config.energyGeneratorSolarUltimateHybrid * 128.0;
        }
        return 0.0;
    }
}

