/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcreboot.Tasks;

import java.util.TimerTask;
import net.moddedminecraft.mmcreboot.Config.Config;
import net.moddedminecraft.mmcreboot.Main;
import org.spongepowered.api.scheduler.Task;

public class ShutdownTask
extends TimerTask {
    private final Main plugin;

    public ShutdownTask(Main instance) {
        this.plugin = instance;
    }

    @Override
    public void run() {
        if (this.plugin.getTPSRestarting()) {
            if (this.plugin.getTPS() >= (double)Config.tpsMinimum && Config.tpsRestartCancel) {
                this.plugin.cancelTasks();
                this.plugin.removeScoreboard();
                this.plugin.removeBossBar();
                this.plugin.isRestarting = false;
                this.plugin.setTPSRestarting(false);
                if (!Config.tpsRestartCancelMsg.isEmpty()) {
                    this.plugin.broadcastMessage("&f[&6Restart&f] " + Config.tpsRestartCancelMsg);
                }
            } else if (this.plugin.getTPS() < (double)Config.tpsMinimum) {
                if (Config.restartUseCommand) {
                    Task.builder().execute(() -> {
                        this.plugin.cancelTasks();
                        this.plugin.removeScoreboard();
                        this.plugin.removeBossBar();
                        this.plugin.useCommandOnRestart();
                    }).submit((Object)this.plugin);
                } else {
                    Task.builder().execute(t -> this.plugin.stopServer()).submit((Object)this.plugin);
                }
            }
        } else if (Config.restartUseCommand) {
            Task.builder().execute(() -> {
                this.plugin.cancelTasks();
                this.plugin.removeScoreboard();
                this.plugin.removeBossBar();
                this.plugin.useCommandOnRestart();
            }).submit((Object)this.plugin);
        } else {
            Task.builder().execute(t -> this.plugin.stopServer()).submit((Object)this.plugin);
        }
    }
}

