/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import omtteam.omlib.api.network.INetworkTile;
import omtteam.omlib.api.network.IPowerExchangeTile;
import omtteam.omlib.api.network.OMLibNetwork;
import omtteam.omlib.api.permission.EnumAccessLevel;
import omtteam.omlib.api.permission.TrustedPlayer;
import omtteam.omlib.api.render.camo.ICamoSupport;
import omtteam.omlib.api.tile.IDebugTile;
import omtteam.omlib.compatibility.OMLibModCompatibility;
import omtteam.omlib.network.ISyncableTE;
import omtteam.omlib.network.OMLibNetworkingHandler;
import omtteam.omlib.network.messages.MessageCamoSettings;
import omtteam.omlib.power.OMEnergyStorage;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.tileentity.TileEntityTrustedMachine;
import omtteam.omlib.util.EnumMachineMode;
import omtteam.omlib.util.NetworkUtil;
import omtteam.omlib.util.WorldUtil;
import omtteam.omlib.util.camo.CamoSettings;
import omtteam.omlib.util.player.PlayerUtil;
import omtteam.openmodularturrets.api.network.IBaseController;
import omtteam.openmodularturrets.handler.OMTNetworkingHandler;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.network.messages.MessageTurretBase;
import omtteam.openmodularturrets.tileentity.turrets.AbstractDirectedTurret;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.util.OMTUtil;
import omtteam.openmodularturrets.util.TargetingSettings;
import omtteam.openmodularturrets.util.TurretHeadUtil;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="computercraft")})
public class TurretBase
extends TileEntityTrustedMachine
implements IPeripheral,
ICamoSupport,
IDebugTile,
IPowerExchangeTile,
INetworkTile,
ISyncableTE,
ITickable {
    public int trustedPlayerIndex = 0;
    public boolean shouldConcealTurrets;
    protected CamoSettings camoSettings;
    protected int tier;
    protected IItemHandlerModifiable inventory;
    protected FluidTank tank;
    private IBlockState camoBlockStateTemp;
    private boolean multiTargeting = false;
    private int currentMaxRange;
    private int upperBoundMaxRange;
    private boolean rangeOverridden;
    private boolean attacksMobs;
    private boolean attacksNeutrals;
    private boolean attacksPlayers;
    private boolean updateRange;
    private int ticks;
    private boolean forceFire = false;
    private int kills;
    private int playerKills;
    private IBaseController controller;
    private OMLibNetwork network;
    private List<EntityPlayerMP> openClients = new ArrayList<EntityPlayerMP>();

    public TurretBase(int MaxEnergyStorage, int MaxIO, int tier, IBlockState camoState) {
        this.currentMaxRange = 0;
        this.upperBoundMaxRange = 0;
        this.rangeOverridden = false;
        this.storage = new OMEnergyStorage(MaxEnergyStorage, MaxIO);
        this.attacksMobs = true;
        this.attacksNeutrals = false;
        this.attacksPlayers = false;
        this.tier = tier;
        this.camoBlockStateTemp = camoState;
        this.mode = EnumMachineMode.INVERTED;
        this.camoSettings = new CamoSettings();
        this.setupInventory();
    }

    public TurretBase() {
        this.setupInventory();
    }

    private static void updateRedstoneReactor(TurretBase base) {
        OMEnergyStorage storage = (OMEnergyStorage)base.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
        if (!TurretHeadUtil.hasRedstoneReactor(base) || storage == null) {
            return;
        }
        if (OMTConfig.MISCELLANEOUS.redstoneReactorAddonGen * 9 < storage.getMaxEnergyStored() - storage.getEnergyStored()) {
            ItemStack redstoneBlock = TurretHeadUtil.getSpecificItemStackFromBase(base, new ItemStack(Blocks.field_150451_bX));
            if (redstoneBlock == ItemStack.field_190927_a) {
                redstoneBlock = TurretHeadUtil.getSpecificItemFromInvExpanders(base.func_145831_w(), new ItemStack(Blocks.field_150451_bX), base, null);
            }
            if (redstoneBlock != ItemStack.field_190927_a) {
                base.storage.modifyEnergyStored(OMTConfig.MISCELLANEOUS.redstoneReactorAddonGen * 9);
                return;
            }
        }
        if (OMTConfig.MISCELLANEOUS.redstoneReactorAddonGen < storage.getMaxEnergyStored() - storage.getEnergyStored()) {
            ItemStack redstone = TurretHeadUtil.getSpecificItemStackFromBase(base, new ItemStack(Items.field_151137_ax));
            if (redstone == ItemStack.field_190927_a) {
                redstone = TurretHeadUtil.getSpecificItemFromInvExpanders(base.func_145831_w(), new ItemStack(Items.field_151137_ax), base, null);
            }
            if (redstone != ItemStack.field_190927_a) {
                storage.modifyEnergyStored(OMTConfig.MISCELLANEOUS.redstoneReactorAddonGen);
            }
        }
    }

    public IItemHandler getCapabilityInventory(EnumFacing facing) {
        return new RangedWrapper(this.inventory, 0, 9);
    }

    protected void setupInventory() {
        this.inventory = new ItemStackHandler(13){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TurretBase.this.func_70296_d();
            }

            public boolean isItemValidForSlot(int index, ItemStack stack) {
                if (index < 9) {
                    return OMTUtil.isItemStackValidAmmo(stack);
                }
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValidForSlot(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    protected void setupTank() {
        this.tank = new FluidTank(4000){

            public boolean canFillFluidType(FluidStack fluid) {
                return super.canFillFluidType(fluid);
            }

            public boolean canDrain() {
                return false;
            }
        };
    }

    @Nonnull
    public CamoSettings getCamoSettings() {
        return this.camoSettings == null ? new CamoSettings() : this.camoSettings;
    }

    @Nonnull
    public IBlockState getDefaultCamoState() {
        Block base = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("openmodularturrets:turret_base"));
        return base.func_176203_a(this.tier - 1);
    }

    @Nonnull
    public IBlockState getCamoState() {
        return this.getCamoSettings().getCamoBlockState() != null && this.getCamoSettings().getCamoBlockState() instanceof IExtendedBlockState ? (IExtendedBlockState)this.getCamoSettings().getCamoBlockState() : (this.getCamoSettings().getCamoBlockState() != null ? this.getCamoSettings().getCamoBlockState().func_177230_c().getExtendedState(this.getCamoSettings().getCamoBlockState(), (IBlockAccess)this.func_145831_w(), this.func_174877_v()) : this.getDefaultCamoState());
    }

    public void setCamoState(IBlockState state) {
        if (!(state instanceof IExtendedBlockState)) {
            if (this.getCamoState() == state.func_177230_c().getExtendedState(state, (IBlockAccess)this.func_145831_w(), this.func_174877_v())) {
                return;
            }
            this.getCamoSettings().setCamoBlockState(state.func_177230_c().getExtendedState(state, (IBlockAccess)this.func_145831_w(), this.func_174877_v()));
        } else {
            if (this.getCamoState() == state) {
                return;
            }
            this.getCamoSettings().setCamoBlockState(state);
        }
        this.camoBlockStateTemp = state;
        if (!this.field_145850_b.field_72995_K) {
            OMLibNetworkingHandler.INSTANCE.sendToAllTracking((IMessage)new MessageCamoSettings((ICamoSupport)this), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 80.0));
            this.setUpdateNBT(true);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("currentMaxRange", this.currentMaxRange);
        tag.func_74768_a("upperBoundMaxRange", this.upperBoundMaxRange);
        tag.func_74757_a("rangeOverridden", this.rangeOverridden);
        tag.func_74757_a("attacksMobs", this.attacksMobs);
        tag.func_74757_a("attacksNeutrals", this.attacksNeutrals);
        tag.func_74757_a("attacksPlayers", this.attacksPlayers);
        tag.func_74757_a("shouldConcealTurrets", this.shouldConcealTurrets);
        tag.func_74757_a("multiTargeting", this.multiTargeting);
        tag.func_74757_a("forceFire", this.forceFire);
        tag.func_74768_a("tier", this.tier);
        tag.func_74768_a("mode", this.mode.ordinal());
        tag.func_74768_a("kills", this.kills);
        this.camoSettings.writeNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.currentMaxRange = tag.func_74762_e("currentMaxRange");
        this.upperBoundMaxRange = tag.func_74762_e("upperBoundMaxRange");
        this.rangeOverridden = tag.func_74767_n("rangeOverridden");
        this.attacksMobs = tag.func_74767_n("attacksMobs");
        this.attacksNeutrals = tag.func_74767_n("attacksNeutrals");
        this.attacksPlayers = tag.func_74767_n("attacksPlayers");
        this.shouldConcealTurrets = tag.func_74767_n("shouldConcealTurrets");
        this.multiTargeting = tag.func_74767_n("multiTargeting");
        this.forceFire = tag.func_74767_n("forceFire");
        this.tier = tag.func_74762_e("tier");
        this.mode = tag.func_74764_b("mode") ? EnumMachineMode.values()[tag.func_74762_e("mode")] : EnumMachineMode.INVERTED;
        this.camoSettings = CamoSettings.getSettingsFromNBT((NBTTagCompound)tag);
        this.camoBlockStateTemp = this.camoSettings.getCamoBlockState() != null ? this.camoSettings.getCamoBlockState() : this.getDefaultCamoState();
        this.kills = tag.func_74764_b("kills") ? tag.func_74762_e("kills") : 0;
        if (tag.func_74764_b("playerKills")) {
            this.kills = tag.func_74762_e("playerKills");
        } else {
            this.playerKills = 0;
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.camoBlockStateTemp instanceof IExtendedBlockState) {
            this.camoSettings.setCamoBlockState(this.camoBlockStateTemp);
        } else {
            this.setCamoState(this.camoBlockStateTemp.func_177230_c().getExtendedState(this.camoBlockStateTemp, (IBlockAccess)this.func_145831_w(), this.func_174877_v()));
        }
        this.updateNBT = true;
    }

    public List<EntityPlayerMP> getSyncPlayerList() {
        return this.openClients;
    }

    public TileEntity getTE() {
        return this;
    }

    public void sendMessageToAllTracking() {
        OMTNetworkingHandler.INSTANCE.sendToAllAround((IMessage)new MessageTurretBase((TileEntity)this), NetworkUtil.getTargetPointFromTE((TileEntity)this, (double)20.0));
    }

    private void updateControllerSettings() {
        if (this.controller != null) {
            TargetingSettings settings = this.controller.getTargetingSettings();
            this.attacksMobs = settings.isTargetMobs();
            this.attacksNeutrals = settings.isTargetPassive();
            this.attacksPlayers = settings.isTargetPlayers();
            this.currentMaxRange = settings.getMaxRange();
        }
    }

    public List<String> getDebugInfo() {
        ArrayList<String> debugInfo = new ArrayList<String>();
        debugInfo.add("Camo: " + this.camoSettings.getCamoBlockState().func_177230_c().getRegistryName());
        debugInfo.add("Force Fire: " + this.forceFire + ", UpperMaxRange: " + this.upperBoundMaxRange);
        return debugInfo;
    }

    @Nonnull
    public TileEntityOwnedBlock getOwnedBlock() {
        return this;
    }

    @Nonnull
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.dropBlock) {
            this.func_145831_w().func_175655_b(this.field_174879_c, true);
            return;
        }
        if (!this.func_145831_w().field_72995_K && this.updateNBT) {
            this.markBlockForUpdate();
            OMTNetworkingHandler.INSTANCE.sendToAllAround((IMessage)new MessageTurretBase((TileEntity)this), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 160.0));
            this.updateNBT = false;
        }
        if (!this.func_145831_w().field_72995_K) {
            for (EntityPlayerMP player : this.openClients) {
                OMTNetworkingHandler.INSTANCE.sendTo((IMessage)new MessageTurretBase((TileEntity)this), player);
            }
        }
        ++this.ticks;
        if (!this.func_145831_w().field_72995_K && this.ticks % 5 == 0) {
            this.setBaseUpperBoundRange();
            this.updateControllerSettings();
            if (this.currentMaxRange > this.upperBoundMaxRange) {
                this.currentMaxRange = this.upperBoundMaxRange;
            }
            if (!this.rangeOverridden) {
                this.currentMaxRange = this.upperBoundMaxRange;
            }
            this.shouldConcealTurrets = TurretHeadUtil.hasConcealmentAddon(this);
            this.storage.setCapacity(this.getMaxEnergyStorageWithExtenders());
            if (this.ticks % 20 == 0) {
                this.ticks = 0;
                TurretBase.updateRedstoneReactor(this);
                if (this.updateRange) {
                    this.setCurrentMaxRange(this.upperBoundMaxRange);
                    this.updateRange = false;
                }
                this.scrubSyncPlayerList();
            }
        }
    }

    public NBTTagCompound writeMemoryCardNBT() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74768_a("currentMaxRange", this.currentMaxRange);
        nbtTagCompound.func_74757_a("attacksMobs", this.attacksMobs);
        nbtTagCompound.func_74757_a("attacksNeutrals", this.attacksNeutrals);
        nbtTagCompound.func_74757_a("attacksPlayers", this.attacksPlayers);
        nbtTagCompound.func_74757_a("multiTargeting", this.multiTargeting);
        nbtTagCompound.func_74768_a("mode", this.mode.ordinal());
        if (this.rangeOverridden) {
            nbtTagCompound.func_74768_a("range", this.currentMaxRange);
        }
        NBTTagCompound trustedPlayers = new NBTTagCompound();
        nbtTagCompound.func_74782_a("trustedPlayers", (NBTBase)this.getTrustManager().writeToNBT(trustedPlayers));
        return nbtTagCompound;
    }

    public void readMemoryCardNBT(NBTTagCompound nbtTagCompound) {
        this.currentMaxRange = nbtTagCompound.func_74762_e("currentMaxRange");
        this.attacksMobs = nbtTagCompound.func_74767_n("attacksMobs");
        this.attacksNeutrals = nbtTagCompound.func_74767_n("attacksNeutrals");
        this.attacksPlayers = nbtTagCompound.func_74767_n("attacksPlayers");
        this.multiTargeting = nbtTagCompound.func_74767_n("multiTargeting");
        this.mode = nbtTagCompound.func_74764_b("mode") ? EnumMachineMode.values()[nbtTagCompound.func_74762_e("mode")] : EnumMachineMode.INVERTED;
        if (nbtTagCompound.func_74764_b("range")) {
            this.rangeOverridden = true;
            this.currentMaxRange = nbtTagCompound.func_74762_e("range");
        } else {
            this.rangeOverridden = false;
            this.currentMaxRange = this.getUpperBoundMaxRange();
        }
        if (nbtTagCompound.func_74764_b("trustedPlayers")) {
            this.getTrustManager().readFromNBT((NBTTagCompound)nbtTagCompound.func_74781_a("trustedPlayers"));
        }
    }

    private void setBaseUpperBoundRange() {
        int maxRange = 0;
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        for (TileEntity te : tileEntities) {
            if (!(te instanceof TurretHead)) continue;
            maxRange = Math.max(((TurretHead)te).getTurretBaseRange() + TurretHeadUtil.getRangeUpgrades(this, (TurretHead)te), maxRange);
        }
        this.upperBoundMaxRange = maxRange;
    }

    @Nullable
    public FluidTank getTank() {
        return this.tank;
    }

    @Nullable
    public FluidTank getCapabilityTank(EnumFacing facing) {
        return this.tank;
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public boolean isActive() {
        boolean changedActive = false;
        if (this.controller != null && this.controller.overridesMode() && this.controller.getOverriddenMode() != this.mode) {
            this.refreshActive(this.controller.getOverriddenMode());
            changedActive = true;
        }
        if (!changedActive) {
            this.refreshActive(this.mode);
        }
        return this.active;
    }

    public void setUpdateRange(boolean updateRange) {
        this.updateRange = updateRange;
    }

    public boolean isAttacksMobs() {
        return this.attacksMobs;
    }

    public void setAttacksMobs(boolean attacksMobs) {
        this.attacksMobs = attacksMobs;
    }

    public boolean isAttacksNeutrals() {
        return this.attacksNeutrals;
    }

    public void setAttacksNeutrals(boolean attacksNeutrals) {
        this.attacksNeutrals = attacksNeutrals;
    }

    public boolean isAttacksPlayers() {
        return this.attacksPlayers;
    }

    public void setAttacksPlayers(boolean attacksPlayers) {
        this.attacksPlayers = attacksPlayers;
    }

    public boolean isMultiTargeting() {
        return this.multiTargeting;
    }

    public void setMultiTargeting(boolean multiTargeting) {
        this.multiTargeting = multiTargeting;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public boolean isComputerAccessible() {
        return !(!OMLibModCompatibility.OpenComputersLoaded && !OMLibModCompatibility.ComputerCraftLoaded || this.tier != 5 && !TurretHeadUtil.hasSerialPortAddon(this));
    }

    public void increaseKillCounter() {
        ++this.kills;
    }

    public void increasePlayerKillCounter() {
        ++this.playerKills;
    }

    public int getKills() {
        return this.kills;
    }

    public void setKills(int kills) {
        this.kills = kills;
    }

    public int getPlayerKills() {
        return this.playerKills;
    }

    public void setPlayerKills(int playerKills) {
        this.playerKills = playerKills;
    }

    public int getCurrentMaxRange() {
        return this.currentMaxRange;
    }

    public void setCurrentMaxRange(int newCurrentMaxRange) {
        this.currentMaxRange = newCurrentMaxRange;
        this.rangeOverridden = true;
        if (this.currentMaxRange > this.upperBoundMaxRange) {
            this.currentMaxRange = this.upperBoundMaxRange;
        }
        if (this.currentMaxRange < 0) {
            this.currentMaxRange = 0;
        }
    }

    public int getUpperBoundMaxRange() {
        return this.upperBoundMaxRange;
    }

    public void setUpperBoundMaxRange(int upperBoundMaxRange) {
        this.upperBoundMaxRange = upperBoundMaxRange;
    }

    @Nullable
    public IBaseController getController() {
        return this.controller;
    }

    private int getMaxEnergyStorageWithExtenders() {
        int tier = this.getTier();
        switch (tier) {
            case 1: {
                return OMTConfig.BASES.baseTierOne.baseMaxCharge + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
            case 2: {
                return OMTConfig.BASES.baseTierTwo.baseMaxCharge + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
            case 3: {
                return OMTConfig.BASES.baseTierThree.baseMaxCharge + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
            case 4: {
                return OMTConfig.BASES.baseTierFour.baseMaxCharge + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
            case 5: {
                return OMTConfig.BASES.baseTierFive.baseMaxCharge + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
        }
        return 0;
    }

    public boolean registerController(IBaseController controller) {
        if (this.controller != null) {
            return false;
        }
        this.controller = controller;
        return true;
    }

    public List<EntityLivingBase> getEntitiesWithinRange() {
        AxisAlignedBB axis = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - this.currentMaxRange - 1), (double)(this.field_174879_c.func_177956_o() - this.currentMaxRange - 1), (double)(this.field_174879_c.func_177952_p() - this.currentMaxRange - 1), (double)(this.field_174879_c.func_177958_n() + this.currentMaxRange + 1), (double)(this.field_174879_c.func_177956_o() + this.currentMaxRange + 1), (double)(this.field_174879_c.func_177952_p() + this.currentMaxRange + 1));
        return this.func_145831_w().func_72872_a(EntityLivingBase.class, axis);
    }

    public void setAllTurretsYawPitch(float yaw, float pitch) {
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.func_145831_w(), (BlockPos)this.field_174879_c);
        for (TileEntity te : tileEntities) {
            if (!(te instanceof AbstractDirectedTurret)) continue;
            ((AbstractDirectedTurret)te).setPitch(pitch);
            ((AbstractDirectedTurret)te).setYaw(yaw);
        }
    }

    public boolean setTurretYawPitch(EnumFacing facing, float yaw, float pitch) {
        TileEntity turretHead = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (turretHead instanceof AbstractDirectedTurret) {
            ((AbstractDirectedTurret)turretHead).setPitch(pitch);
            ((AbstractDirectedTurret)turretHead).setYaw(yaw);
            return true;
        }
        return false;
    }

    public void setAllTurretsForceFire(boolean state) {
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.func_145831_w(), (BlockPos)this.field_174879_c);
        for (TileEntity te : tileEntities) {
            if (!(te instanceof TurretHead)) continue;
            ((TurretHead)te).setAutoFire(state);
        }
    }

    public boolean setTurretForceFire(EnumFacing facing, boolean state) {
        TileEntity turretHead = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (turretHead instanceof TurretHead) {
            ((TurretHead)turretHead).setAutoFire(state);
            return true;
        }
        return false;
    }

    public boolean forceShootTurret(EnumFacing facing) {
        TileEntity turretHead = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
        return turretHead instanceof AbstractDirectedTurret && ((AbstractDirectedTurret)turretHead).forceShot();
    }

    public int forceShootAllTurrets() {
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.func_145831_w(), (BlockPos)this.field_174879_c);
        int successes = 0;
        for (TileEntity te : tileEntities) {
            if (!(te instanceof AbstractDirectedTurret)) continue;
            successes += ((AbstractDirectedTurret)te).forceShot() ? 1 : 0;
        }
        return successes;
    }

    public boolean requiresEnergy() {
        return true;
    }

    public boolean deliversEnergy() {
        return false;
    }

    public OMEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Nullable
    public OMLibNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(OMLibNetwork network) {
        this.network = network;
    }

    @Nonnull
    public String getDeviceName() {
        return "TurretBase";
    }

    @Optional.Method(modid="computercraft")
    @Nonnull
    public String getType() {
        return "turret_base";
    }

    @Optional.Method(modid="computercraft")
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{commands.getOwner.toString(), commands.attacksPlayers.toString(), commands.setAttacksPlayers.toString(), commands.attacksMobs.toString(), commands.setAttacksMobs.toString(), commands.attacksNeutrals.toString(), commands.setAttacksNeutrals.toString(), commands.getTrustedPlayers.toString(), commands.getTrustedPlayer.toString(), commands.addTrustedPlayer.toString(), commands.removeTrustedPlayer.toString(), commands.changeAccessLevel.toString(), commands.getActive.toString(), commands.getMode.toString(), commands.getRedstone.toString(), commands.setMode.toString(), commands.getType.toString()};
    }

    @Optional.Method(modid="computercraft")
    @ParametersAreNonnullByDefault
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        if (!this.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        switch (commands.values()[method]) {
            case getOwner: {
                return new Object[]{this.getOwner()};
            }
            case attacksPlayers: {
                return new Object[]{this.attacksPlayers};
            }
            case setAttacksPlayers: {
                boolean b;
                if (!arguments[0].toString().equals("true") && !arguments[0].toString().equals("false")) {
                    return new Object[]{"wrong arguments"};
                }
                this.attacksPlayers = b = arguments[0].toString().equals("true");
                return new Object[]{true};
            }
            case attacksMobs: {
                return new Object[]{this.attacksMobs};
            }
            case setAttacksMobs: {
                boolean b;
                if (!arguments[0].toString().equals("true") && !arguments[0].toString().equals("false")) {
                    return new Object[]{"wrong arguments"};
                }
                this.attacksMobs = b = arguments[0].toString().equals("true");
                return new Object[]{true};
            }
            case attacksNeutrals: {
                return new Object[]{this.attacksNeutrals};
            }
            case setAttacksNeutrals: {
                boolean b;
                if (!arguments[0].toString().equals("true") && !arguments[0].toString().equals("false")) {
                    return new Object[]{"wrong arguments"};
                }
                this.attacksNeutrals = b = arguments[0].toString().equals("true");
                return new Object[]{true};
            }
            case getTrustedPlayers: {
                return new Object[]{this.getTrustManager().getTrustedPlayersAsListMap()};
            }
            case getTrustedPlayer: {
                if (this.getTrustManager().getTrustedPlayer(arguments[0].toString()) != null) {
                    return new Object[]{this.getTrustManager().getTrustedPlayer(arguments[0].toString()).asMap()};
                }
            }
            case addTrustedPlayer: {
                if (arguments[0].toString().equals("")) {
                    return new Object[]{"wrong arguments"};
                }
                if (!this.getTrustManager().addTrustedPlayer(arguments[0].toString())) {
                    return new Object[]{"Name not valid!"};
                }
                if (arguments[1].toString().equals("")) {
                    return new Object[]{"successfully added"};
                }
                if (!(arguments[1] instanceof Integer)) {
                    return new Object[]{"wrong arguments"};
                }
                TrustedPlayer trustedPlayer = this.getTrustManager().getTrustedPlayer(arguments[0].toString());
                trustedPlayer.setAccessLevel(EnumAccessLevel.values()[(Integer)arguments[1]]);
                trustedPlayer.setUuid(PlayerUtil.getPlayerUUID((String)arguments[0].toString()));
                return new Object[]{true};
            }
            case removeTrustedPlayer: {
                if (arguments[0].toString().equals("")) {
                    return new Object[]{"wrong arguments"};
                }
                this.getTrustManager().removeTrustedPlayer(arguments[0].toString());
                return new Object[]{true};
            }
            case changeAccessLevel: {
                if (this.getTrustManager().getTrustedPlayer(arguments[0].toString()) == null) {
                    return new Object[]{"Not found!"};
                }
                if (!(arguments[1] instanceof Integer) || (Integer)arguments[1] < 0 || (Integer)arguments[1] > 3) {
                    return new Object[]{"Invalid Access Level!"};
                }
                TrustedPlayer trustedPlayer = this.getTrustManager().getTrustedPlayer(arguments[0].toString());
                trustedPlayer.setAccessLevel(EnumAccessLevel.values()[(Integer)arguments[1]]);
                return new Object[]{true};
            }
            case getActive: {
                return new Object[]{this.active};
            }
            case getMode: {
                return new Object[]{this.mode.getName()};
            }
            case getRedstone: {
                return new Object[]{this.redstone};
            }
            case setMode: {
                String arg = arguments[0].toString();
                if (!(arg.equals("0") || arg.equals("1") || arg.equals("2") || arg.equals("3"))) {
                    return new Object[]{"wrong arguments, expect number between 0 and 3"};
                }
                int mode = Integer.valueOf(arguments[0].toString());
                this.setMode(EnumMachineMode.values()[mode]);
                return new Object[]{true};
            }
            case getType: {
                return new Object[]{this.getType()};
            }
        }
        return new Object[]{false};
    }

    @Optional.Method(modid="computercraft")
    public boolean equals(IPeripheral other) {
        return other.getType().equals(this.getType());
    }

    @Optional.Method(modid="computercraft")
    public void attach(@Nonnull IComputerAccess computer) {
    }

    @Optional.Method(modid="computercraft")
    public void detach(@Nonnull IComputerAccess computer) {
    }

    public static enum commands {
        getOwner,
        attacksPlayers,
        setAttacksPlayers,
        attacksMobs,
        setAttacksMobs,
        attacksNeutrals,
        setAttacksNeutrals,
        getTrustedPlayers,
        getTrustedPlayer,
        addTrustedPlayer,
        removeTrustedPlayer,
        changeAccessLevel,
        getActive,
        getMode,
        getRedstone,
        setMode,
        getType;

    }
}

