/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.node;

import com.google.common.collect.ImmutableList;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.executable.SymbolCall;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.node.SymbolOpNode;
import java.util.List;

public class SymbolCallNode<E>
extends SymbolOpNode<E> {
    private final List<IExprNode<E>> args;

    public SymbolCallNode(String symbol, List<? extends IExprNode<E>> args) {
        super(symbol);
        this.args = ImmutableList.copyOf(args);
    }

    @Override
    public void flatten(List<IExecutable<E>> output) {
        for (IExprNode<E> arg : this.args) {
            arg.flatten(output);
        }
        output.add(new SymbolCall(this.symbol, this.args.size(), 1));
    }

    public String toString() {
        return "<call: " + this.symbol + " " + this.args + ">";
    }

    @Override
    public Iterable<IExprNode<E>> getChildren() {
        return this.args;
    }
}

