/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.relay;

import javax.annotation.Nullable;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftools.blocks.relay.RelayTileEntity;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla")
class RelayEnergyStorage
implements IEnergyStorage,
ITeslaConsumer {
    private final RelayTileEntity relayTileEntity;
    private final EnumFacing side;

    public RelayEnergyStorage(RelayTileEntity relayTileEntity, @Nullable EnumFacing side) {
        this.relayTileEntity = relayTileEntity;
        this.side = side;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.relayTileEntity.receiveEnergy(this.side, maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return EnergyTools.getIntEnergyStored((long)this.relayTileEntity.getStoredPower(), (long)this.relayTileEntity.getCapacity());
    }

    public int getMaxEnergyStored() {
        return EnergyTools.unsignedClampToInt((long)this.relayTileEntity.getCapacity());
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Optional.Method(modid="tesla")
    public long givePower(long power, boolean simulated) {
        return this.relayTileEntity.receiveEnergy(this.side, EnergyTools.unsignedClampToInt((long)power), simulated);
    }
}

